/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.util.Collection;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.interfacedef.DataType;

public class Collection2CollectionTransformer
extends BaseTransformer<Collection, Collection>
implements PullTransformer<Collection, Collection> {
    private static final String JAVA_COLLECTION = "java:collection";
    protected Mediator mediator;

    public Collection2CollectionTransformer(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public String getSourceDataBinding() {
        return JAVA_COLLECTION;
    }

    public String getTargetDataBinding() {
        return JAVA_COLLECTION;
    }

    protected Class<Collection> getSourceType() {
        return Collection.class;
    }

    protected Class<Collection> getTargetType() {
        return Collection.class;
    }

    public int getWeight() {
        return 10;
    }

    public Collection transform(Collection sourceCollection, TransformationContext context) {
        try {
            if (sourceCollection == null) {
                return null;
            }
            DataType sourceType = context.getSourceDataType();
            DataType targetType = context.getTargetDataType();
            Collection targetCollection = this.createCollection(targetType.getPhysical());
            for (Object sourceItem : sourceCollection) {
                Object targetItem = this.mediator.mediate(sourceItem, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                targetCollection.add(targetItem);
            }
            return targetCollection;
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }

    private Collection createCollection(Class<?> collectionClass) throws Exception {
        return (Collection)collectionClass.newInstance();
    }
}

