/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.transformers;

import java.lang.reflect.Array;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.interfacedef.DataType;

public class Array2ArrayTransformer
extends BaseTransformer<Object, Object>
implements PullTransformer<Object, Object> {
    protected Mediator mediator;

    public Array2ArrayTransformer(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public String getSourceDataBinding() {
        return "java:array";
    }

    public String getTargetDataBinding() {
        return "java:array";
    }

    protected Class<Object> getSourceType() {
        return Object.class;
    }

    protected Class<Object> getTargetType() {
        return Object.class;
    }

    public int getWeight() {
        return 10;
    }

    public Object transform(Object array, TransformationContext context) {
        try {
            if (array == null) {
                return null;
            }
            DataType sourceType = context.getSourceDataType();
            DataType targetType = context.getTargetDataType();
            int length = Array.getLength(array);
            Object targetArray = Array.newInstance(targetType.getPhysical().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Object sourceItem = Array.get(array, i);
                Object targetItem = this.mediator.mediate(sourceItem, (DataType)sourceType.getLogical(), (DataType)targetType.getLogical(), context.getMetadata());
                Array.set(targetArray, i, targetItem);
            }
            return targetArray;
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }
}

