/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.processor;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

public class WrapperJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private static final String JAXB_DATABINDING = "javax.xml.bind.JAXBElement";
    private DataBindingExtensionPoint dataBindingRegistry;

    public WrapperJavaInterfaceProcessor(ExtensionPointRegistry registry) {
        this.dataBindingRegistry = (DataBindingExtensionPoint)registry.getExtensionPoint(DataBindingExtensionPoint.class);
    }

    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        for (Operation operation : javaInterface.getOperations()) {
            DataBinding dbObj;
            WrapperHandler handler;
            WrapperInfo inputWrapperInfo = operation.getInputWrapper();
            WrapperInfo outputWrapperInfo = operation.getOutputWrapper();
            if (inputWrapperInfo == null || outputWrapperInfo == null) continue;
            String db = inputWrapperInfo.getDataBinding();
            if (db == null || JAXB_DATABINDING.equals(db)) {
                db = this.assignInputDataBinding(operation);
            }
            WrapperHandler wrapperHandler = handler = (dbObj = this.dataBindingRegistry.getDataBinding(db)) == null ? null : dbObj.getWrapperHandler();
            if (handler != null) {
                inputWrapperInfo.setWrapperType(handler.getWrapperType(operation, true));
            }
            if (dbObj != null && handler == null) {
                inputWrapperInfo.setWrapperType(null);
            }
            if ((db = outputWrapperInfo.getDataBinding()) == null || JAXB_DATABINDING.equals(db)) {
                db = this.assignOutputDataBinding(operation);
            }
            WrapperHandler wrapperHandler2 = handler = (dbObj = this.dataBindingRegistry.getDataBinding(db)) == null ? null : dbObj.getWrapperHandler();
            if (handler != null) {
                outputWrapperInfo.setWrapperType(handler.getWrapperType(operation, false));
            }
            if (dbObj == null || handler != null) continue;
            outputWrapperInfo.setWrapperType(null);
        }
    }

    private String assignInputDataBinding(Operation operation) {
        HashSet<String> dbs = new HashSet<String>();
        LinkedList opDataTypes = new LinkedList();
        opDataTypes.addAll((Collection)operation.getInputType().getLogical());
        for (DataType d : opDataTypes) {
            if (d == null) continue;
            String dataBinding = d.getDataBinding();
            if ("java:array".equals(dataBinding)) {
                dataBinding = ((DataType)d.getLogical()).getDataBinding();
            }
            if (dataBinding == null) continue;
            dbs.add(dataBinding);
        }
        dbs.remove("java:complexType");
        dbs.remove("java:simpleType");
        if (dbs.size() == 1) {
            String db = (String)dbs.iterator().next();
            operation.getInputWrapper().setDataBinding(db);
            return db;
        }
        return operation.getInputWrapper().getDataBinding();
    }

    private String assignOutputDataBinding(Operation operation) {
        HashSet<String> dbs = new HashSet<String>();
        LinkedList opDataTypes = new LinkedList();
        opDataTypes.addAll((Collection)operation.getOutputType().getLogical());
        for (DataType d : opDataTypes) {
            if (d == null) continue;
            String dataBinding = d.getDataBinding();
            if ("java:array".equals(dataBinding)) {
                dataBinding = ((DataType)d.getLogical()).getDataBinding();
            }
            if (dataBinding == null) continue;
            dbs.add(dataBinding);
        }
        dbs.remove("java:complexType");
        dbs.remove("java:simpleType");
        if (dbs.size() == 1) {
            String db = (String)dbs.iterator().next();
            operation.getOutputWrapper().setDataBinding(db);
            return db;
        }
        return operation.getOutputWrapper().getDataBinding();
    }
}

