/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.databinding.wire;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.FaultExceptionMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceRuntimeException;

public class DataTransformationInterceptor
implements Interceptor,
DataExchangeSemantics {
    private Invoker next;
    private Operation sourceOperation;
    private Operation targetOperation;
    private RuntimeWire wire;
    private Mediator mediator;
    private FaultExceptionMapper faultExceptionMapper;

    public DataTransformationInterceptor(RuntimeWire wire, Operation sourceOperation, Operation targetOperation, Mediator mediator, FaultExceptionMapper faultExceptionMapper) {
        this.sourceOperation = sourceOperation;
        this.targetOperation = targetOperation;
        this.mediator = mediator;
        this.wire = wire;
        this.faultExceptionMapper = faultExceptionMapper;
    }

    public Invoker getNext() {
        return this.next;
    }

    public Message invoke(Message msg) {
        Object input = this.transform(msg.getBody(), this.sourceOperation.getInputType(), this.targetOperation.getInputType(), false);
        msg.setBody(input);
        Message resultMsg = this.next.invoke(msg);
        Object result = resultMsg.getBody();
        if (this.sourceOperation.isNonBlocking()) {
            return resultMsg;
        }
        DataTypeImpl targetType = new DataTypeImpl("idl:output", Object.class, (Object)this.targetOperation.getOutputType());
        DataTypeImpl sourceType = new DataTypeImpl("idl:output", Object.class, (Object)this.sourceOperation.getOutputType());
        if (resultMsg.isFault()) {
            if (result instanceof Exception && !(result instanceof RuntimeException)) {
                DataType targetFaultType;
                if (result instanceof InvocationTargetException) {
                    result = ((InvocationTargetException)result).getCause();
                }
                DataType targetDataType = null;
                for (DataType exType : this.targetOperation.getFaultTypes()) {
                    if (!exType.getPhysical().isInstance(result)) continue;
                    if (result instanceof FaultException) {
                        DataType faultType = (DataType)exType.getLogical();
                        if (!((FaultException)result).isMatchingType(faultType.getLogical())) continue;
                        targetDataType = exType;
                        break;
                    }
                    targetDataType = exType;
                    break;
                }
                if ((targetFaultType = this.getFaultType(targetDataType)) == null) {
                    Throwable cause = (Throwable)result;
                    throw new ServiceRuntimeException(cause);
                }
                DataType sourceDataType = null;
                DataType sourceFaultType = null;
                for (DataType exType : this.sourceOperation.getFaultTypes()) {
                    DataType faultType = this.getFaultType(exType);
                    if (faultType == null || !this.typesMatch(targetFaultType.getLogical(), faultType.getLogical())) continue;
                    sourceDataType = exType;
                    sourceFaultType = faultType;
                    break;
                }
                if (sourceFaultType == null) {
                    Throwable cause = (Throwable)result;
                    throw new ServiceRuntimeException(cause);
                }
                Object newResult = this.transformException(result, targetDataType, sourceDataType, targetFaultType, sourceFaultType);
                if (newResult != result) {
                    resultMsg.setFaultBody(newResult);
                }
            }
        } else {
            assert (!(result instanceof Throwable)) : "Expected messages that are not throwable " + result;
            Object newResult = this.transform(result, (DataType)targetType, (DataType)sourceType, true);
            if (newResult != result) {
                resultMsg.setBody(newResult);
            }
        }
        return resultMsg;
    }

    private Object transform(Object source, DataType sourceType, DataType targetType, boolean isResponse) {
        if (sourceType == targetType || sourceType != null && sourceType.equals(targetType)) {
            return source;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("source.operation", isResponse ? this.targetOperation : this.sourceOperation);
        metadata.put("target.operation", isResponse ? this.sourceOperation : this.targetOperation);
        metadata.put("wire", this.wire);
        return this.mediator.mediate(source, sourceType, targetType, metadata);
    }

    private DataType getFaultType(DataType exceptionType) {
        return exceptionType == null ? null : (DataType)exceptionType.getLogical();
    }

    private boolean typesMatch(Object first, Object second) {
        if (first.equals(second)) {
            return true;
        }
        if (first instanceof XMLType && second instanceof XMLType) {
            XMLType t1 = (XMLType)first;
            XMLType t2 = (XMLType)second;
            return this.matches(t1.getElementName(), t2.getElementName());
        }
        return false;
    }

    private boolean matches(QName qn1, QName qn2) {
        String e2;
        if (qn1 == qn2) {
            return true;
        }
        if (qn1 == null || qn2 == null) {
            return false;
        }
        String ns1 = qn1.getNamespaceURI();
        String ns2 = qn2.getNamespaceURI();
        String e1 = qn1.getLocalPart();
        return e1.equals(e2 = qn2.getLocalPart()) && (ns1.equals(ns2) || ns1.equals(ns2 + "/") || ns2.equals(ns1 + "/"));
    }

    private Object transformException(Object source, DataType sourceExType, DataType targetExType, DataType sourceType, DataType targetType) {
        if (sourceType == targetType || sourceType != null && sourceType.equals(targetType)) {
            return source;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("source.operation", this.targetOperation);
        metadata.put("target.operation", this.sourceOperation);
        metadata.put("wire", this.wire);
        DataTypeImpl eSourceDataType = new DataTypeImpl("idl:fault", sourceExType.getPhysical(), (Object)sourceType);
        DataTypeImpl eTargetDataType = new DataTypeImpl("idl:fault", targetExType.getPhysical(), (Object)targetType);
        return this.mediator.mediate(source, (DataType)eSourceDataType, (DataType)eTargetDataType, metadata);
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

