/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.work.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.work.impl.ThreadPoolWorkManager;
import org.apache.tuscany.sca.core.work.impl.Work;
import org.apache.tuscany.sca.core.work.impl.WorkEvent;
import org.apache.tuscany.sca.core.work.impl.WorkListener;
import org.apache.tuscany.sca.work.NotificationListener;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.apache.tuscany.sca.work.WorkSchedulerException;

public class DefaultWorkScheduler
implements WorkScheduler,
LifeCycleListener {
    private ThreadPoolWorkManager jsr237WorkManager;
    private int maxThreads = 0;

    public DefaultWorkScheduler(ExtensionPointRegistry registry, Map<String, String> attributes) {
        String value;
        if (attributes != null && (value = attributes.get("maxThreads")) != null) {
            this.maxThreads = Integer.parseInt(value.trim());
        }
    }

    private synchronized ThreadPoolWorkManager getWorkManager() {
        if (this.jsr237WorkManager != null) {
            return this.jsr237WorkManager;
        }
        if (this.jsr237WorkManager == null) {
            this.jsr237WorkManager = new ThreadPoolWorkManager(this.maxThreads);
        }
        return this.jsr237WorkManager;
    }

    public <T extends Runnable> void scheduleWork(T work) {
        this.scheduleWork(work, null);
    }

    public <T extends Runnable> void scheduleWork(T work, NotificationListener<T> listener) {
        if (work == null) {
            throw new IllegalArgumentException("Work cannot be null");
        }
        Work<T> jsr237Work = new Work<T>(work);
        try {
            if (listener == null) {
                this.getWorkManager().schedule(jsr237Work);
            } else {
                Jsr237WorkListener jsr237WorkListener = new Jsr237WorkListener(this, listener, work);
                this.getWorkManager().schedule(jsr237Work, jsr237WorkListener);
            }
        }
        catch (IllegalArgumentException ex) {
            if (listener != null) {
                listener.workRejected(work);
            }
            throw new WorkSchedulerException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new WorkSchedulerException((Throwable)ex);
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.jsr237WorkManager instanceof ThreadPoolWorkManager) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    DefaultWorkScheduler.this.jsr237WorkManager.destroy();
                    return null;
                }
            });
        }
    }

    public ExecutorService getExecutorService() {
        return this.getWorkManager().getExecutorService();
    }

    private static class Jsr237WorkListener<T extends Runnable>
    implements WorkListener {
        private NotificationListener<T> listener;
        private T work;
        final /* synthetic */ DefaultWorkScheduler this$0;

        public Jsr237WorkListener(NotificationListener<T> listener, T work) {
            this.this$0 = var1_1;
            this.listener = listener;
            this.work = work;
        }

        @Override
        public void workAccepted(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workAccepted(work);
        }

        @Override
        public void workRejected(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workRejected(work);
        }

        @Override
        public void workStarted(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workStarted(work);
        }

        @Override
        public void workCompleted(WorkEvent workEvent) {
            T work = this.getWork();
            WorkSchedulerException exception = workEvent.getException();
            if (exception != null) {
                this.listener.workFailed(work, (Throwable)exception);
            } else {
                this.listener.workCompleted(work);
            }
        }

        private T getWork() {
            return this.work;
        }
    }
}

