/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.runtime.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.PolicyBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.impl.RuntimeEndpointImpl;
import org.apache.tuscany.sca.core.assembly.impl.RuntimeEndpointReferenceImpl;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.impl.TuscanyInterfaceContractImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.util.Audit;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentMap;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.Qualifier;
import org.apache.tuscany.sca.provider.EndpointReferenceAsyncProvider;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.EndpointReferenceBinder;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.UnknownEndpointHandler;
import org.oasisopen.sca.ServiceRuntimeException;

public class EndpointReferenceBinderImpl
implements EndpointReferenceBinder {
    private static final Logger logger = Logger.getLogger(EndpointReferenceBinderImpl.class.getName());
    protected ExtensionPointRegistry extensionPoints;
    protected AssemblyFactory assemblyFactory;
    protected InterfaceContractMapper interfaceContractMapper;
    protected BuilderExtensionPoint builders;
    protected CompositeActivator compositeActivator;
    protected Monitor monitor;
    protected UnknownEndpointHandler unknownEndpointHandler;
    protected CompositeBuilder policyAppliesToBuilder;

    public EndpointReferenceBinderImpl(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        FactoryExtensionPoint factories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)factories.getFactory(AssemblyFactory.class);
        UtilityExtensionPoint utils = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = (InterfaceContractMapper)utils.getUtility(InterfaceContractMapper.class);
        MonitorFactory monitorFactory = (MonitorFactory)utils.getUtility(MonitorFactory.class);
        this.monitor = monitorFactory.createMonitor();
        this.unknownEndpointHandler = (UnknownEndpointHandler)utils.getUtility(UnknownEndpointHandler.class);
        this.builders = (BuilderExtensionPoint)extensionPoints.getExtensionPoint(BuilderExtensionPoint.class);
        this.compositeActivator = (CompositeActivator)extensionPoints.getExtensionPoint(CompositeActivator.class);
    }

    public void bindBuildTime(DomainRegistry domainRegistry, EndpointReference endpointReference, BuilderContext builderContext) {
        this.bind(domainRegistry, endpointReference, builderContext, false);
    }

    public void bindRunTime(DomainRegistry domainRegistry, EndpointReference endpointReference) {
        this.bind(domainRegistry, endpointReference, null, true);
    }

    public void bind(DomainRegistry domainRegistry, EndpointReference endpointReference, BuilderContext builderContext, boolean runtime) {
        logger.fine("Binding " + endpointReference.toString());
        Audit matchAudit = new Audit();
        if (endpointReference.getStatus() == EndpointReference.Status.AUTOWIRE_PLACEHOLDER) {
            Multiplicity multiplicity = endpointReference.getReference().getMultiplicity();
            for (Endpoint endpoint : domainRegistry.getEndpoints()) {
                if ((multiplicity == Multiplicity.ZERO_ONE || multiplicity == Multiplicity.ONE_ONE) && endpointReference.getReference().getEndpointReferences().size() > 1) break;
                if (endpointReference.getComponent() == endpoint.getComponent() || !this.haveMatchingPolicy(endpointReference, endpoint, matchAudit, builderContext) || !this.haveMatchingInterfaceContracts(endpointReference, endpoint, matchAudit)) continue;
                Endpoint autowireEndpoint = null;
                for (EndpointReference epr : endpointReference.getReference().getEndpointReferences()) {
                    if (epr.getTargetEndpoint() != endpoint) continue;
                    autowireEndpoint = endpoint;
                    break;
                }
                if (autowireEndpoint != null) continue;
                EndpointReference autowireEndpointRefrence = null;
                try {
                    autowireEndpointRefrence = (EndpointReference)endpointReference.clone();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                autowireEndpointRefrence.setTargetEndpoint(endpoint);
                autowireEndpointRefrence.setBinding(endpoint.getBinding());
                autowireEndpointRefrence.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
                endpointReference.getReference().getEndpointReferences().add(autowireEndpointRefrence);
            }
            if ((multiplicity == Multiplicity.ONE_N || multiplicity == Multiplicity.ONE_ONE) && endpointReference.getReference().getEndpointReferences().size() == 1) {
                Monitor.error((Monitor)this.monitor, (Object)this, (String)"endpoint-validation-messages", (String)"NoComponentReferenceTarget", (Object[])new Object[]{endpointReference.getReference().getName()});
            }
            this.setSingleAutoWireTarget(endpointReference.getReference());
        } else if (endpointReference.getStatus() == EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED || endpointReference.getStatus() == EndpointReference.Status.RESOLVED_BINDING) {
            this.build(endpointReference);
            if (this.hasCallback(endpointReference) && (endpointReference.getCallbackEndpoint() == null || endpointReference.getCallbackEndpoint().isUnresolved())) {
                this.selectCallbackEndpoint(endpointReference, endpointReference.getReference().getCallbackService(), matchAudit, builderContext, runtime);
            }
        } else if (endpointReference.getStatus() == EndpointReference.Status.WIRED_TARGET_FOUND_READY_FOR_MATCHING) {
            this.selectForwardEndpoint(endpointReference, endpointReference.getTargetEndpoint().getService().getEndpoints(), matchAudit, builderContext, runtime);
            if (this.hasCallback(endpointReference)) {
                this.selectCallbackEndpoint(endpointReference, endpointReference.getReference().getCallbackService(), matchAudit, builderContext, runtime);
            }
        } else if (endpointReference.getStatus() == EndpointReference.Status.WIRED_TARGET_IN_BINDING_URI || endpointReference.getStatus() == EndpointReference.Status.WIRED_TARGET_NOT_FOUND || endpointReference.getStatus() == EndpointReference.Status.NOT_CONFIGURED) {
            List endpoints = domainRegistry.findEndpoint(endpointReference);
            if (endpoints.size() > 0) {
                this.selectForwardEndpoint(endpointReference, endpoints, matchAudit, builderContext, runtime);
                if (endpointReference.getStatus().equals((Object)EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED) && this.hasCallback(endpointReference)) {
                    this.selectCallbackEndpoint(endpointReference, endpointReference.getReference().getCallbackService(), matchAudit, builderContext, runtime);
                }
            } else if (runtime) {
                if (endpointReference.getStatus() == EndpointReference.Status.WIRED_TARGET_IN_BINDING_URI) {
                    endpointReference.getTargetEndpoint().setBinding(endpointReference.getBinding());
                    endpointReference.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                } else {
                    this.processUnknownEndpoint(endpointReference, matchAudit);
                    if (!endpointReference.getStatus().equals((Object)EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED)) {
                        Monitor.error((Monitor)this.monitor, (Object)this, (String)"endpoint-validation-messages", (String)"NoEndpointsFound", (Object[])new Object[]{endpointReference.toString()});
                        throw new ServiceRuntimeException(this.monitor.getMessageString(EndpointReferenceBinderImpl.class.getName(), "endpoint-validation-messages", "UnableToBind") + " " + this.monitor.getLastProblem().toString());
                    }
                }
            } else {
                this.processUnknownEndpoint(endpointReference, matchAudit);
            }
        }
        logger.fine(matchAudit.toString());
        if (endpointReference.getStatus() != EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED && endpointReference.getStatus() != EndpointReference.Status.RESOLVED_BINDING) {
            if (runtime) {
                Monitor.error((Monitor)this.monitor, (Object)this, (String)"endpoint-validation-messages", (String)"EndpointReferenceCantBeMatched", (Object[])new Object[]{endpointReference.toString(), matchAudit});
                throw new ServiceRuntimeException(this.monitor.getMessageString(EndpointReferenceBinderImpl.class.getName(), "endpoint-validation-messages", "UnableToBind") + " " + this.monitor.getLastProblem().toString());
            }
            Monitor.warning((Monitor)this.monitor, (Object)this, (String)"endpoint-validation-messages", (String)"ComponentReferenceTargetNotFound", (Object[])new Object[]{endpointReference.toString()});
            return;
        }
        if (endpointReference.getTargetEndpoint().getBinding() == null) {
            endpointReference.getTargetEndpoint().setBinding(endpointReference.getBinding());
        }
        try {
            ((RuntimeEndpointReference)endpointReference).validateReferenceInterfaceCompatibility();
        }
        catch (ServiceRuntimeException ex) {
            if (runtime) {
                throw ex;
            }
            Monitor.error((Monitor)this.monitor, (Object)this, (String)"endpoint-validation-messages", (String)"EndpointReferenceCantBeMatched", (Object[])new Object[]{endpointReference.toString(), ex.getMessage()});
        }
        ReferenceBindingProvider referenceBindingProvider = ((RuntimeEndpointReference)endpointReference).getBindingProvider();
        if (referenceBindingProvider instanceof EndpointReferenceAsyncProvider && !((EndpointReferenceAsyncProvider)referenceBindingProvider).supportsNativeAsync() && endpointReference.isAsyncInvocation() && endpointReference.getCallbackEndpoint() == null) {
            ((RuntimeEndpointReference)endpointReference).createAsyncCallbackEndpoint();
        }
    }

    private void processUnknownEndpoint(EndpointReference endpointReference, Audit matchAudit) {
        Binding b = null;
        if (this.unknownEndpointHandler != null) {
            b = this.unknownEndpointHandler.handleUnknownEndpoint(endpointReference);
        }
        if (b != null) {
            RuntimeEndpointImpl matchedEndpoint = new RuntimeEndpointImpl(this.extensionPoints);
            matchedEndpoint.setBinding(b);
            matchedEndpoint.setRemote(true);
            endpointReference.setTargetEndpoint((Endpoint)matchedEndpoint);
            endpointReference.setBinding(b);
            endpointReference.setUnresolved(false);
            endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
            matchAudit.append("Match because the UnknownEndpointHandler provided a binding: " + b.getType() + " uri: " + b.getURI());
            matchAudit.appendSeperator();
        }
    }

    private boolean hasCallback(EndpointReference endpointReference) {
        return endpointReference.getReference().getInterfaceContract() != null && endpointReference.getReference().getInterfaceContract().getCallbackInterface() != null && !endpointReference.getReference().getName().startsWith("$self$.");
    }

    private void selectForwardEndpoint(EndpointReference endpointReference, List<Endpoint> endpoints, Audit matchAudit, BuilderContext builderContext, boolean runtime) {
        Endpoint matchedEndpoint = null;
        if (endpointReference.getReference().getName().startsWith("$self$.")) {
            matchedEndpoint = endpointReference.getTargetEndpoint() != null && !endpointReference.getTargetEndpoint().isUnresolved() ? endpointReference.getTargetEndpoint() : endpoints.get(0);
        } else {
            ArrayList<Endpoint> matchedEndpoints = new ArrayList<Endpoint>();
            for (Endpoint endpoint : endpoints) {
                if (!this.haveMatchingPolicy(endpointReference, endpoint, matchAudit, builderContext) || !this.haveMatchingInterfaceContracts(endpointReference, endpoint, matchAudit)) continue;
                matchedEndpoints.add(endpoint);
            }
            if (endpointReference.getTargetEndpoint().getService() == null && endpointReference.getTargetEndpoint().getBinding() == null && matchedEndpoints.size() > 1) {
                String serviceName = null;
                for (Endpoint endpoint : matchedEndpoints) {
                    if (serviceName == null && !endpoint.getService().getName().equals("default")) {
                        serviceName = endpoint.getService().getName();
                    }
                    if (serviceName == null || endpoint.getService().getName().equals("default") || endpoint.getService().getName().equals(serviceName)) continue;
                    if (runtime) {
                        Monitor.error((Monitor)this.monitor, (Object)this, (String)"endpoint-validation-messages", (String)"TooManyTargetServices", (Object[])new Object[]{endpointReference.toString(), endpointReference.getTargetEndpoint().toString(), matchAudit});
                        throw new ServiceRuntimeException("Unable to bind " + this.monitor.getLastProblem().toString());
                    }
                    Monitor.warning((Monitor)this.monitor, (Object)this, (String)"endpoint-validation-messages", (String)"TooManyTargetServices", (Object[])new Object[]{endpointReference.toString(), endpointReference.getTargetEndpoint().toString()});
                    return;
                }
            }
            if (endpointReference.getBinding() != null && endpointReference.getBinding() instanceof SCABinding) {
                for (Endpoint endpoint : matchedEndpoints) {
                    if (!(endpoint.getBinding() instanceof SCABinding)) continue;
                    matchedEndpoint = endpoint;
                    break;
                }
            }
            if (matchedEndpoint == null && matchedEndpoints.size() > 0) {
                matchedEndpoint = (Endpoint)matchedEndpoints.get(0);
            }
        }
        if (matchedEndpoint == null) {
            return;
        }
        endpointReference.setTargetEndpoint(matchedEndpoint);
        Binding binding = matchedEndpoint.getBinding();
        try {
            endpointReference.setBinding((Binding)binding.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        endpointReference.getPolicySets().addAll(matchedEndpoint.getPolicySets());
        ArrayList<PolicySet> psToRemove = new ArrayList<PolicySet>();
        for (PolicySet ps : endpointReference.getPolicySets()) {
            if (ps.getAppliesTo().contains(endpointReference.getBinding().getType().getLocalPart())) continue;
            psToRemove.add(ps);
        }
        endpointReference.getPolicySets().removeAll(psToRemove);
        this.build(endpointReference);
        endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        endpointReference.setUnresolved(false);
    }

    private void build(EndpointReference endpointReference) {
        BindingBuilder builder = this.builders.getBindingBuilder(endpointReference.getBinding().getType());
        if (builder != null) {
            builder.build(endpointReference.getComponent(), (Contract)endpointReference.getReference(), endpointReference.getBinding(), new BuilderContext(this.extensionPoints), false);
        }
    }

    private void selectCallbackEndpoint(EndpointReference endpointReference, ComponentService callbackService, Audit matchAudit, BuilderContext builderContext, boolean runtime) {
        RuntimeEndpoint callbackEndpoint = null;
        for (Endpoint loopCallbackEndpoint : callbackService.getEndpoints()) {
            if (!loopCallbackEndpoint.getBinding().getType().equals(endpointReference.getBinding().getType())) continue;
            callbackEndpoint = (RuntimeEndpoint)loopCallbackEndpoint;
            break;
        }
        if (callbackEndpoint == null) {
            ComponentReference callbackReference;
            callbackEndpoint = (RuntimeEndpoint)this.assemblyFactory.createEndpoint();
            callbackEndpoint.setComponent(endpointReference.getComponent());
            callbackEndpoint.setService(callbackService);
            Binding forwardBinding = endpointReference.getBinding();
            Binding callbackBinding = null;
            Callback serviceCallback = endpointReference.getTargetEndpoint().getService().getCallback();
            if (serviceCallback != null) {
                for (Binding loopCallbackBinding : serviceCallback.getBindings()) {
                    if (!loopCallbackBinding.getType().equals(endpointReference.getBinding().getType())) continue;
                    callbackBinding = loopCallbackBinding;
                    break;
                }
            }
            if ((callbackReference = endpointReference.getTargetEndpoint().getService().getCallbackReference()) != null) {
                for (EndpointReference loopEndpointReference : callbackReference.getEndpointReferences()) {
                    if (!loopEndpointReference.getBinding().getType().equals(endpointReference.getBinding().getType())) continue;
                    callbackBinding = loopEndpointReference.getBinding();
                    break;
                }
            }
            if (callbackBinding == null) {
                try {
                    callbackBinding = (Binding)forwardBinding.clone();
                }
                catch (CloneNotSupportedException ex) {
                    // empty catch block
                }
            }
            callbackBinding.setURI(null);
            for (Endpoint endpoint : callbackService.getEndpoints()) {
                if (!endpoint.getBinding().getType().equals(SCABinding.TYPE)) continue;
                callbackBinding.setURI(endpoint.getBinding().getURI());
            }
            callbackEndpoint.setBinding(callbackBinding);
            callbackService.getBindings().add(callbackBinding);
            callbackEndpoint.setUnresolved(false);
            callbackService.getEndpoints().add(callbackEndpoint);
            this.build((Endpoint)callbackEndpoint);
            if (runtime) {
                this.compositeActivator.activate(((RuntimeEndpointReferenceImpl)endpointReference).getCompositeContext(), callbackEndpoint);
                this.compositeActivator.start(((RuntimeEndpointReferenceImpl)endpointReference).getCompositeContext(), callbackEndpoint);
            }
        }
        endpointReference.setCallbackEndpoint(callbackEndpoint);
    }

    private void build(Endpoint endpoint) {
        BindingBuilder builder = this.builders.getBindingBuilder(endpoint.getBinding().getType());
        if (builder != null) {
            builder.build(endpoint.getComponent(), (Contract)endpoint.getService(), endpoint.getBinding(), new BuilderContext(this.extensionPoints), true);
        }
    }

    private boolean haveMatchingPolicy(EndpointReference endpointReference, Endpoint endpoint, Audit matchAudit, BuilderContext builderContext) {
        QName policyType;
        PolicyBuilder policyBuilder;
        matchAudit.append("Match policy of " + endpointReference.toString() + " to " + endpoint.toString() + " ");
        if (!endpoint.getSpecVersion().equals("http://docs.oasis-open.org/ns/opencsa/sca/200912")) {
            if (endpointReference.isAsyncInvocation()) {
                matchAudit.append("No match because the endpoint reference is configured for asyncInvocation and the target endpoint is not an OASIS endpoint, specVersion = " + endpoint.getSpecVersion());
                matchAudit.appendSeperator();
                return false;
            }
            matchAudit.append("Match because the target endpoint is not an OASIS endpoint, specVersion = " + endpoint.getSpecVersion());
            matchAudit.appendSeperator();
            return true;
        }
        ArrayList<PolicySet> referencePolicySets = new ArrayList<PolicySet>();
        Binding binding = null;
        binding = endpointReference.getBinding() == null ? endpoint.getBinding() : endpointReference.getBinding();
        for (Intent eprIntent : endpointReference.getRequiredIntents()) {
            for (Intent epIntent : endpoint.getRequiredIntents()) {
                if (!eprIntent.getExcludedIntents().contains(epIntent) && !epIntent.getExcludedIntents().contains(eprIntent) && !this.checkQualifiedMutualExclusion(eprIntent.getExcludedIntents(), epIntent) && !this.checkQualifiedMutualExclusion(epIntent.getExcludedIntents(), eprIntent)) continue;
                matchAudit.append("No match because the following intents are mutually exclusive " + eprIntent.toString() + " " + epIntent.toString() + " ");
                matchAudit.appendSeperator();
                return false;
            }
        }
        for (PolicySet policySet : endpointReference.getPolicySets()) {
            policyBuilder = null;
            if (policySet.getPolicies().size() > 0) {
                policyType = ((PolicyExpression)policySet.getPolicies().get(0)).getName();
                policyBuilder = this.builders.getPolicyBuilder(policyType);
            }
            if (policyBuilder != null && (policyBuilder == null || policyBuilder.getSupportedBindings() != null) && (policyBuilder == null || !policyBuilder.getSupportedBindings().contains(binding.getType()))) continue;
            referencePolicySets.add(policySet);
        }
        if (referencePolicySets.isEmpty()) {
            for (PolicySet policySet : endpoint.getPolicySets()) {
                policyBuilder = null;
                if (policySet.getPolicies().size() > 0) {
                    policyType = ((PolicyExpression)policySet.getPolicies().get(0)).getName();
                    policyBuilder = this.builders.getPolicyBuilder(policyType);
                }
                if (policyBuilder != null && (policyBuilder == null || policyBuilder.getSupportedBindings() != null) && (policyBuilder == null || !policyBuilder.getSupportedBindings().contains(binding.getType()))) continue;
                referencePolicySets.add(policySet);
            }
        }
        boolean noEndpointReferencePolicies = true;
        for (PolicySet policySet : referencePolicySets) {
            if (policySet.getPolicies().size() <= 0) continue;
            noEndpointReferencePolicies = false;
            break;
        }
        boolean noEndpointPolicies = true;
        for (PolicySet policySet : endpoint.getPolicySets()) {
            if (policySet.getPolicies().size() <= 0) continue;
            noEndpointPolicies = false;
            break;
        }
        if (endpointReference.getRequiredIntents().size() == 0 && endpoint.getRequiredIntents().size() == 0 && noEndpointReferencePolicies && noEndpointPolicies) {
            matchAudit.append("Match because there are no intents or policies ");
            matchAudit.appendSeperator();
            return true;
        }
        BindingType bindingType = null;
        Definitions systemDefinitions = null;
        systemDefinitions = builderContext != null ? builderContext.getDefinitions() : ((RuntimeEndpoint)endpoint).getCompositeContext().getSystemDefinitions();
        bindingType = systemDefinitions.getBindingType(binding.getType());
        this.removeConstrainedIntents(endpointReference, bindingType);
        ArrayList eprIntents = new ArrayList();
        ArrayList<Intent> eprMayProvideInterationIntents = new ArrayList<Intent>();
        eprIntents.addAll(endpointReference.getRequiredIntents());
        block6: for (Intent intent : endpointReference.getRequiredIntents()) {
            if (bindingType != null && bindingType.getAlwaysProvidedIntents().contains(intent)) {
                eprIntents.remove(intent);
                continue;
            }
            if (bindingType != null && bindingType.getMayProvidedIntents().contains(intent)) {
                eprIntents.remove(intent);
                if (!intent.getType().equals((Object)Intent.Type.interaction)) continue;
                eprMayProvideInterationIntents.add(intent);
                continue;
            }
            for (PolicySet policySet : referencePolicySets) {
                if (policySet.getProvidedIntents().contains(intent)) {
                    eprIntents.remove(intent);
                    continue block6;
                }
                for (Intent psProvidedIntent : policySet.getProvidedIntents()) {
                    if (!this.isQualifiedBy(psProvidedIntent, intent)) continue;
                    eprIntents.remove(intent);
                    continue block6;
                }
                for (IntentMap map : policySet.getIntentMaps()) {
                    for (Qualifier q : map.getQualifiers()) {
                        if (!intent.equals(q.getIntent())) continue;
                        eprIntents.remove(intent);
                        continue block6;
                    }
                }
            }
        }
        if (eprIntents.size() > 0) {
            matchAudit.append("No match because there are unresolved intents " + ((Object)eprIntents).toString() + " ");
            matchAudit.appendSeperator();
            return false;
        }
        if (eprMayProvideInterationIntents.size() > 0) {
            for (Intent eprIntent : eprMayProvideInterationIntents) {
                boolean match = false;
                for (Intent epIntent : endpoint.getRequiredIntents()) {
                    if (!epIntent.equals(eprIntent)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                matchAudit.append("No match because the reference has a mayProvide intent that the service doesn't have " + eprIntent.getName());
                matchAudit.appendSeperator();
                return false;
            }
        }
        if (noEndpointPolicies && noEndpointReferencePolicies) {
            matchAudit.append("Match because the intents are resolved and there are no policy sets ");
            matchAudit.appendSeperator();
            return true;
        }
        if (noEndpointPolicies && !noEndpointReferencePolicies) {
            matchAudit.append("No match because there are policy sets at the endpoint reference but not at the endpoint ");
            matchAudit.appendSeperator();
            return false;
        }
        if (!noEndpointPolicies && noEndpointReferencePolicies) {
            matchAudit.append("No match because there are policy sets at the endpoint but not at the endpoint reference ");
            matchAudit.appendSeperator();
            return false;
        }
        HashSet referencePolicySet = new HashSet(referencePolicySets);
        HashSet servicePolicySet = new HashSet(endpoint.getPolicySets());
        if (((Object)referencePolicySet).equals(servicePolicySet)) {
            matchAudit.append("Match because the policy sets on both sides are eactly the same ");
            matchAudit.appendSeperator();
            return true;
        }
        QName eprLanguage = null;
        for (PolicySet policySet : referencePolicySets) {
            if (policySet.getPolicies().size() <= 0) continue;
            eprLanguage = ((PolicyExpression)policySet.getPolicies().get(0)).getName();
            break;
        }
        QName epLanguage = null;
        for (PolicySet policySet : endpoint.getPolicySets()) {
            if (policySet.getPolicies().size() <= 0) continue;
            epLanguage = ((PolicyExpression)policySet.getPolicies().get(0)).getName();
            break;
        }
        if (!eprLanguage.getNamespaceURI().equals(epLanguage.getNamespaceURI())) {
            matchAudit.append("No match because the policy sets on either side have policies in differnt languages " + eprLanguage + " and " + epLanguage + " ");
            matchAudit.appendSeperator();
            return false;
        }
        PolicyBuilder builder = this.builders.getPolicyBuilder(eprLanguage);
        boolean match = false;
        List originalPolicySets = endpointReference.getPolicySets();
        endpointReference.getPolicySets().clear();
        endpointReference.getPolicySets().addAll(referencePolicySets);
        if (builder != null) {
            if (builderContext == null) {
                builderContext = new BuilderContext(this.monitor);
            }
            match = builder.build(endpointReference, endpoint, builderContext);
        }
        if (!match) {
            matchAudit.append("No match because the language specific matching failed ");
            matchAudit.appendSeperator();
            endpointReference.getPolicySets().clear();
            endpointReference.getPolicySets().addAll(originalPolicySets);
        } else {
            matchAudit.append("Match because the language specific matching succeeded ");
            matchAudit.appendSeperator();
        }
        return match;
    }

    protected void removeConstrainedIntents(EndpointReference subject, BindingType bindingType) {
        List intents = subject.getRequiredIntents();
        if (bindingType != null) {
            ArrayList copy = new ArrayList(intents);
            for (Intent i : copy) {
                List constrainedTypes = i.getConstrainedTypes();
                if (constrainedTypes.size() == 0 && i.getQualifiableIntent() != null) {
                    constrainedTypes = i.getQualifiableIntent().getConstrainedTypes();
                }
                if (constrainedTypes.size() <= 0) continue;
                boolean constraintFound = false;
                for (ExtensionType constrainedType : constrainedTypes) {
                    if (!constrainedType.getType().equals(bindingType.getType()) && !constrainedType.getType().equals(bindingType.getBaseType())) continue;
                    constraintFound = true;
                    break;
                }
                if (constraintFound) continue;
                intents.remove(i);
            }
        }
    }

    protected boolean isQualifiedBy(Intent qualifiableIntent, Intent qualifiedIntent) {
        return qualifiedIntent.getQualifiableIntent() == qualifiableIntent;
    }

    protected boolean checkQualifiedMutualExclusion(List<Intent> excludedIntentList, Intent intent) {
        for (Intent excludedIntent : excludedIntentList) {
            if (intent.getQualifiableIntent() == null || excludedIntent == null || !intent.getQualifiableIntent().equals(excludedIntent)) continue;
            return true;
        }
        return false;
    }

    private boolean haveMatchingInterfaceContracts(EndpointReference endpointReference, Endpoint endpoint, Audit matchAudit) {
        matchAudit.append("Match interface of " + endpointReference.toString() + " to " + endpoint.toString() + " ");
        InterfaceContract endpointReferenceContract = endpointReference.getReference().getInterfaceContract();
        InterfaceContract endpointContract = endpoint.getComponentServiceInterfaceContract();
        if (endpointReferenceContract == null) {
            matchAudit.append("Match because there is no interface contract on the reference ");
            matchAudit.appendSeperator();
            return true;
        }
        if (!endpoint.getSpecVersion().equals("http://docs.oasis-open.org/ns/opencsa/sca/200912")) {
            matchAudit.append("Match because the target endpoint is not an OASIS endpoint, specVersion = " + endpoint.getSpecVersion());
            matchAudit.appendSeperator();
            return true;
        }
        if (endpointContract.getInterface().getOperations().size() == 0 && endpointContract.getNormalizedWSDLContract() == null || endpointContract.getNormalizedWSDLContract() != null && endpointContract.getNormalizedWSDLContract().getInterface().getOperations().size() == 0) {
            matchAudit.append("Match because the endpoint is remote and we don't have a copy of it's interface contract ");
            matchAudit.appendSeperator();
            return true;
        }
        if (endpointReferenceContract.getClass() == endpointContract.getClass() && endpointReferenceContract instanceof JavaInterfaceContract && endpointContract.getNormalizedWSDLContract() != null && endpointContract.getNormalizedWSDLContract() instanceof TuscanyInterfaceContractImpl) {
            endpointContract = endpointContract.getNormalizedWSDLContract();
        } else if (endpointReferenceContract.getClass() != endpointContract.getClass() || endpointReferenceContract.getNormalizedWSDLContract() != null || endpointContract.getNormalizedWSDLContract() != null) {
            endpointReferenceContract = ((RuntimeEndpointReference)endpointReference).getGeneratedWSDLContract(endpointReferenceContract);
            endpointContract = ((RuntimeEndpoint)endpoint).getGeneratedWSDLContract(endpointContract);
        }
        boolean match = false;
        match = this.interfaceContractMapper.isCompatibleSubset(endpointReferenceContract, endpointContract, matchAudit);
        if (!match) {
            matchAudit.append("Match failed because the interface contract mapper failed ");
        } else {
            matchAudit.append("Match because the interface contract mapper succeeded ");
        }
        matchAudit.appendSeperator();
        return match;
    }

    public boolean isOutOfDate(DomainRegistry domainRegistry, EndpointReference endpointReference) {
        Endpoint te = endpointReference.getTargetEndpoint();
        if (te != null && !te.isUnresolved() && te.getURI() != null && endpointReference.getStatus() != EndpointReference.Status.RESOLVED_BINDING) {
            return domainRegistry.isOutOfDate(endpointReference);
        }
        return false;
    }

    private void setSingleAutoWireTarget(ComponentReference reference) {
        String uri;
        if (reference.getEndpointReferences().size() > 1 && reference.getBindings() != null && reference.getBindings().size() == 1 && (uri = ((Binding)reference.getBindings().get(0)).getURI()) != null) {
            if (uri.indexOf(47) > -1) {
                int i = uri.indexOf(47);
                String c = uri.substring(0, i);
                String s = uri.substring(i + 1);
                uri = c + "#service(" + s + ")";
            }
            for (EndpointReference er : reference.getEndpointReferences()) {
                if (er.getTargetEndpoint() == null || !uri.equals(er.getTargetEndpoint().getURI())) continue;
                reference.getEndpointReferences().clear();
                reference.getEndpointReferences().add(er);
                return;
            }
        }
    }
}

