/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.impl.PhaseSorter;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.invocation.Phase;
import org.oasisopen.sca.ServiceRuntimeException;

public class PhaseManager {
    private static final Logger log = Logger.getLogger(PhaseManager.class.getName());
    public static final String STAGE_REFERENCE = "reference";
    public static final String STAGE_REFERENCE_BINDING = "reference.binding";
    public static final String STAGE_SERVICE_BINDING = "service.binding";
    public static final String STAGE_SERVICE = "service";
    public static final String STAGE_IMPLEMENTATION = "implementation";
    private static final String[] SYSTEM_REFERENCE_PHASES = new String[]{"component.reference", "reference.policy", "reference.interface", "reference.binding"};
    private static final String[] SYSTEM_REFERENCE_BINDING_PHASES = new String[]{"reference.binding.wireformat", "reference.binding.policy", "reference.binding.transport"};
    private static final String[] SYSTEM_SERVICE_BINDING_PHASES = new String[]{"service.binding.transport", "service.binding.operationselector", "service.binding.wireformat", "service.binding.policy"};
    private static final String[] SYSTEM_SERVICE_PHASES = new String[]{"service.binding", "service.interface", "service.policy", "component.service"};
    private static final String[] SYSTEM_IMPLEMENTATION_PHASES = new String[]{"implementation.policy", "component.implementation"};
    private ExtensionPointRegistry registry;
    private String pattern = Phase.class.getName();
    private Map<String, Stage> stages;
    private List<String> phases;

    public PhaseManager(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    public static PhaseManager getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilityExtensionPoint = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        return (PhaseManager)utilityExtensionPoint.getUtility(PhaseManager.class);
    }

    PhaseManager(String pattern) {
        this.pattern = pattern;
        this.registry = new DefaultExtensionPointRegistry();
    }

    private List<String> getPhases(String stage) {
        Stage s = this.getStages().get(stage);
        return s == null ? null : s.getPhases();
    }

    public List<String> getReferencePhases() {
        return this.getPhases(STAGE_REFERENCE);
    }

    public List<String> getServicePhases() {
        return this.getPhases(STAGE_SERVICE);
    }

    public List<String> getReferenceBindingPhases() {
        return this.getPhases(STAGE_REFERENCE_BINDING);
    }

    public List<String> getServiceBindingPhases() {
        return this.getPhases(STAGE_SERVICE_BINDING);
    }

    public List<String> getImplementationPhases() {
        return this.getPhases(STAGE_IMPLEMENTATION);
    }

    public synchronized List<String> getAllPhases() {
        if (this.phases == null) {
            this.phases = new ArrayList<String>();
            this.phases.addAll(this.getReferencePhases());
            this.phases.addAll(this.getReferenceBindingPhases());
            this.phases.addAll(this.getServiceBindingPhases());
            this.phases.addAll(this.getServicePhases());
            this.phases.addAll(this.getImplementationPhases());
        }
        return this.phases;
    }

    public synchronized Map<String, Stage> getStages() {
        Collection services;
        if (this.stages != null) {
            return this.stages;
        }
        this.init();
        try {
            services = this.registry.getServiceDiscovery().getServiceDeclarations(this.pattern);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        for (ServiceDeclaration d : services) {
            String p;
            StringTokenizer tokenizer;
            String name;
            if (log.isLoggable(Level.FINE)) {
                log.fine(d.getLocation() + ": " + d.getAttributes());
            }
            if ((name = (String)d.getAttributes().get("name")) == null) {
                throw new ServiceRuntimeException("Required attribute 'name' is missing.");
            }
            String stageName = (String)d.getAttributes().get("stage");
            if (stageName == null) {
                throw new ServiceRuntimeException("Required attribute 'stage' is missing.");
            }
            Stage stage = this.stages.get(stageName);
            if (stage == null) {
                throw new ServiceRuntimeException("Invalid stage: " + stageName);
            }
            PhaseSorter<String> graph = stage.getSorter();
            Set<String> firstSet = stage.getFirstSet();
            Set<String> lastSet = stage.getLastSet();
            String before = (String)d.getAttributes().get("before");
            String after = (String)d.getAttributes().get("after");
            if (before != null) {
                tokenizer = new StringTokenizer(before);
                while (tokenizer.hasMoreTokens()) {
                    p = tokenizer.nextToken();
                    if (!"*".equals(p)) {
                        graph.addEdge(name, p);
                        continue;
                    }
                    firstSet.add(name);
                }
            }
            if (after != null) {
                tokenizer = new StringTokenizer(after);
                while (tokenizer.hasMoreTokens()) {
                    p = tokenizer.nextToken();
                    if (!"*".equals(p)) {
                        graph.addEdge(p, name);
                        continue;
                    }
                    lastSet.add(name);
                }
            }
            graph.addVertext(name);
            if (firstSet.size() > 1) {
                log.warning("More than one phases are declared to be first: " + firstSet);
            }
            for (String s : firstSet) {
                for (String v : new HashSet<String>(graph.getVertices().keySet())) {
                    if (firstSet.contains(v)) continue;
                    graph.addEdge(s, v);
                }
            }
            if (lastSet.size() > 1) {
                log.warning("More than one phases are declared to be the last: " + lastSet);
            }
            for (String s : lastSet) {
                for (String v : new HashSet<String>(graph.getVertices().keySet())) {
                    if (lastSet.contains(v)) continue;
                    graph.addEdge(v, s);
                }
            }
        }
        for (Stage s : this.stages.values()) {
            List<String> phases = s.getSorter().topologicalSort(false);
            s.getPhases().clear();
            s.getPhases().addAll(phases);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stages: " + this.stages);
        }
        return this.stages;
    }

    private void init() {
        this.stages = new HashMap<String, Stage>();
        Stage referenceStage = new Stage(STAGE_REFERENCE);
        for (int i = 1; i < SYSTEM_REFERENCE_PHASES.length; ++i) {
            referenceStage.getSorter().addEdge(SYSTEM_REFERENCE_PHASES[i - 1], SYSTEM_REFERENCE_PHASES[i]);
        }
        referenceStage.getLastSet().add(STAGE_REFERENCE_BINDING);
        this.stages.put(referenceStage.getName(), referenceStage);
        Stage referenceBindingStage = new Stage(STAGE_REFERENCE_BINDING);
        for (int i = 1; i < SYSTEM_REFERENCE_BINDING_PHASES.length; ++i) {
            referenceBindingStage.getSorter().addEdge(SYSTEM_REFERENCE_BINDING_PHASES[i - 1], SYSTEM_REFERENCE_BINDING_PHASES[i]);
        }
        this.stages.put(referenceBindingStage.getName(), referenceBindingStage);
        Stage serviceBindingStage = new Stage(STAGE_SERVICE_BINDING);
        for (int i = 1; i < SYSTEM_SERVICE_BINDING_PHASES.length; ++i) {
            serviceBindingStage.getSorter().addEdge(SYSTEM_SERVICE_BINDING_PHASES[i - 1], SYSTEM_SERVICE_BINDING_PHASES[i]);
        }
        this.stages.put(serviceBindingStage.getName(), serviceBindingStage);
        Stage serviceStage = new Stage(STAGE_SERVICE);
        for (int i = 1; i < SYSTEM_SERVICE_PHASES.length; ++i) {
            serviceStage.getSorter().addEdge(SYSTEM_SERVICE_PHASES[i - 1], SYSTEM_SERVICE_PHASES[i]);
        }
        this.stages.put(serviceStage.getName(), serviceStage);
        Stage implementationStage = new Stage(STAGE_IMPLEMENTATION);
        for (int i = 1; i < SYSTEM_IMPLEMENTATION_PHASES.length; ++i) {
            implementationStage.getSorter().addEdge(SYSTEM_IMPLEMENTATION_PHASES[i - 1], SYSTEM_IMPLEMENTATION_PHASES[i]);
        }
        implementationStage.getLastSet().add("component.implementation");
        this.stages.put(implementationStage.getName(), implementationStage);
    }

    public class Stage {
        private String name;
        private PhaseSorter<String> sorter = new PhaseSorter();
        private Set<String> firstSet = new HashSet<String>();
        private Set<String> lastSet = new HashSet<String>();
        private List<String> phases = new ArrayList<String>();

        public Stage(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public PhaseSorter<String> getSorter() {
            return this.sorter;
        }

        public Set<String> getFirstSet() {
            return this.firstSet;
        }

        public Set<String> getLastSet() {
            return this.lastSet;
        }

        public List<String> getPhases() {
            return this.phases;
        }

        public String toString() {
            return this.name + this.phases;
        }
    }
}

