/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceRuntimeException;

public class NonBlockingInterceptor
extends InterceptorAsyncImpl {
    private static final Message RESPONSE = new ImmutableMessage();
    private static final Logger LOGGER = Logger.getLogger(NonBlockingInterceptor.class.getName());
    private WorkScheduler workScheduler;

    public NonBlockingInterceptor(WorkScheduler workScheduler) {
        this.workScheduler = workScheduler;
    }

    public NonBlockingInterceptor(WorkScheduler workScheduler, Interceptor next) {
        this.workScheduler = workScheduler;
        this.next = next;
    }

    public void setWorkScheduler(WorkScheduler workScheduler) {
        this.workScheduler = workScheduler;
    }

    @Override
    public Message invoke(final Message msg) {
        try {
            this.workScheduler.scheduleWork(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Message context = ThreadMessageContext.setMessageContext((Message)msg);
                    try {
                        Message response = null;
                        Throwable ex = null;
                        try {
                            response = NonBlockingInterceptor.this.next.invoke(msg);
                        }
                        catch (Throwable t) {
                            ex = t;
                        }
                        if (response != null && response.isFault()) {
                            ex = (Throwable)response.getBody();
                        }
                        if (ex != null) {
                            LOGGER.log(Level.SEVERE, "Exception from @OneWay invocation", ex);
                            throw new ServiceRuntimeException("Exception from @OneWay invocation", ex);
                        }
                    }
                    finally {
                        ThreadMessageContext.setMessageContext((Message)context);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        return RESPONSE;
    }

    public Message processRequest(Message msg) {
        return msg;
    }

    public Message processResponse(Message msg) {
        return null;
    }

    private static class ImmutableMessage
    implements Message {
        private ImmutableMessage() {
        }

        public <T> T getBody() {
            return null;
        }

        public void setBody(Object body) {
            if (body != null) {
                throw new UnsupportedOperationException();
            }
        }

        public Object getMessageID() {
            return null;
        }

        public void setMessageID(Object messageId) {
            throw new UnsupportedOperationException();
        }

        public boolean isFault() {
            return false;
        }

        public void setFaultBody(Object fault) {
            throw new UnsupportedOperationException();
        }

        public EndpointReference getFrom() {
            return null;
        }

        public Endpoint getTo() {
            return null;
        }

        public void setFrom(EndpointReference from) {
            throw new UnsupportedOperationException();
        }

        public void setTo(Endpoint to) {
            throw new UnsupportedOperationException();
        }

        public Operation getOperation() {
            return null;
        }

        public void setOperation(Operation op) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getHeaders() {
            return null;
        }

        public <T> T getBindingContext() {
            return null;
        }

        public <T> void setBindingContext(T bindingContext) {
        }
    }
}

