/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import org.apache.tuscany.sca.invocation.InterceptorAsync;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncRequest;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;

public abstract class InterceptorAsyncImpl
implements InterceptorAsync {
    protected Invoker next;
    protected InvokerAsyncResponse previous;

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public InvokerAsyncResponse getPrevious() {
        return this.previous;
    }

    public void setPrevious(InvokerAsyncResponse previous) {
        this.previous = previous;
    }

    public Message invoke(Message msg) {
        msg = this.processRequest(msg);
        Message resultMsg = this.getNext().invoke(msg);
        resultMsg = this.processResponse(resultMsg);
        return resultMsg;
    }

    public void invokeAsyncRequest(Message msg) throws Throwable {
        try {
            msg = this.processRequest(msg);
            InvokerAsyncRequest theNext = (InvokerAsyncRequest)this.getNext();
            if (theNext != null) {
                theNext.invokeAsyncRequest(msg);
            }
            this.postProcessRequest(msg);
        }
        catch (Throwable e) {
            this.postProcessRequest(msg, e);
        }
    }

    public void invokeAsyncResponse(Message msg) {
        msg = this.processResponse(msg);
        InvokerAsyncResponse thePrevious = this.getPrevious();
        if (thePrevious != null) {
            thePrevious.invokeAsyncResponse(msg);
        }
    }

    public Message postProcessRequest(Message msg) {
        return msg;
    }

    public Message postProcessRequest(Message msg, Throwable e) throws Throwable {
        throw e;
    }

    public boolean isLocalSCABIndingInvoker() {
        return false;
    }
}

