/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.assembly.impl.RuntimeEndpointReferenceImpl;
import org.apache.tuscany.sca.core.context.ServiceReferenceExt;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class ServiceReferenceImpl<B>
implements ServiceReferenceExt<B> {
    private static final long serialVersionUID = 6763709434194361540L;
    protected transient ProxyFactory proxyFactory;
    protected transient Class<B> businessInterface;
    protected transient B proxy;
    protected Object callbackID;
    protected transient RuntimeEndpointReference endpointReference;
    protected transient CompositeContext compositeContext;
    protected ExtensionPointRegistry registry;
    protected FactoryExtensionPoint modelFactories;
    protected RuntimeAssemblyFactory assemblyFactory;
    protected StAXArtifactProcessorExtensionPoint staxProcessors;
    protected StAXArtifactProcessor<EndpointReference> staxProcessor;
    protected XMLInputFactory xmlInputFactory;
    protected XMLOutputFactory xmlOutputFactory;
    protected BuilderExtensionPoint builders;

    public ServiceReferenceImpl() {
    }

    public ServiceReferenceImpl(Class<B> businessInterface, Invocable endpointReference, CompositeContext compositeContext) {
        this.businessInterface = businessInterface;
        this.endpointReference = (RuntimeEndpointReference)endpointReference;
        if (compositeContext == null) {
            compositeContext = endpointReference.getCompositeContext();
        }
        this.bind(compositeContext);
    }

    public ServiceReferenceImpl(Class<B> businessInterface, Invocable endpointReference) {
        this(businessInterface, endpointReference, null);
    }

    protected void bind(CompositeContext context) {
        this.compositeContext = context;
        this.registry = this.compositeContext.getExtensionPointRegistry();
        this.modelFactories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (RuntimeAssemblyFactory)((Object)this.modelFactories.getFactory(AssemblyFactory.class));
        this.xmlInputFactory = (XMLInputFactory)this.modelFactories.getFactory(XMLInputFactory.class);
        this.xmlOutputFactory = (XMLOutputFactory)this.modelFactories.getFactory(XMLOutputFactory.class);
        this.staxProcessors = (StAXArtifactProcessorExtensionPoint)this.registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.staxProcessor = this.staxProcessors.getProcessor(EndpointReference.class);
        this.builders = (BuilderExtensionPoint)this.registry.getExtensionPoint(BuilderExtensionPoint.class);
        this.proxyFactory = ExtensibleProxyFactory.getInstance(this.registry);
    }

    @Override
    public RuntimeEndpointReference getEndpointReference() {
        return this.endpointReference;
    }

    @Override
    public B getProxy() throws ObjectCreationException {
        try {
            if (this.proxy == null) {
                this.proxy = this.createProxy();
            }
            return this.proxy;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
    }

    @Override
    public void setProxy(B proxy) {
        this.proxy = proxy;
    }

    protected B createProxy() throws Exception {
        return (B)this.proxyFactory.createProxy(this);
    }

    public B getService() {
        try {
            this.resolve();
            return this.getProxy();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Class<B> getBusinessInterface() {
        try {
            this.resolve();
            return this.businessInterface;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    private ComponentService getPromotedComponentService(CompositeService compositeService) {
        ComponentService componentService = compositeService.getPromotedService();
        if (componentService != null) {
            Service service = componentService.getService();
            if (componentService.getName() != null && service instanceof CompositeService) {
                return this.getPromotedComponentService((CompositeService)service);
            }
            return componentService;
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.endpointReference);
    }

    public String toXMLString() throws IOException, XMLStreamException, ContributionWriteException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter streamWriter = this.xmlOutputFactory.createXMLStreamWriter(writer);
        this.staxProcessor.write((Object)this.endpointReference, streamWriter, new ProcessorContext(this.registry));
        return writer.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        BindingBuilder bindingBuilder;
        Binding binding;
        this.endpointReference = (RuntimeEndpointReference)in.readObject();
        this.endpointReference.getComponent();
        this.bind(this.endpointReference.getCompositeContext());
        RuntimeComponentReference reference = (RuntimeComponentReference)this.endpointReference.getReference();
        reference.setComponent((RuntimeComponent)this.endpointReference.getComponent());
        Interface i = reference.getInterfaceContract().getInterface();
        if (i instanceof JavaInterface) {
            JavaInterface javaInterface = (JavaInterface)i;
            if (javaInterface.isUnresolved()) {
                ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                javaInterface.setJavaClass(classLoader.loadClass(javaInterface.getName()));
                JavaInterfaceFactory javaInterfaceFactory = this.getJavaInterfaceFactory(this.compositeContext);
                try {
                    javaInterfaceFactory.createJavaInterface(javaInterface, javaInterface.getJavaClass());
                }
                catch (InvalidInterfaceException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
            }
            this.businessInterface = javaInterface.getJavaClass();
        }
        if ((binding = this.endpointReference.getBinding()) != null && (bindingBuilder = this.builders.getBindingBuilder(binding.getType())) != null) {
            BuilderContext context = new BuilderContext(this.registry);
            bindingBuilder.build(this.endpointReference.getComponent(), (Contract)reference, this.endpointReference.getBinding(), context, false);
        }
        this.proxyFactory = this.getProxyFactory(this.compositeContext);
    }

    private synchronized void resolve() throws Exception {
    }

    private JavaInterfaceFactory getJavaInterfaceFactory(CompositeContext compositeContext) {
        ExtensionPointRegistry extensionPointRegistry = compositeContext.getExtensionPointRegistry();
        FactoryExtensionPoint factories = (FactoryExtensionPoint)extensionPointRegistry.getExtensionPoint(FactoryExtensionPoint.class);
        JavaInterfaceFactory javaInterfaceFactory = (JavaInterfaceFactory)factories.getFactory(JavaInterfaceFactory.class);
        return javaInterfaceFactory;
    }

    private ProxyFactory getProxyFactory(CompositeContext compositeContext) {
        ExtensionPointRegistry extensionPointRegistry = compositeContext.getExtensionPointRegistry();
        return ExtensibleProxyFactory.getInstance(extensionPointRegistry);
    }

    public void setBindingURI(String uri) {
        ((RuntimeEndpointReferenceImpl)this.endpointReference).setBindingURI(uri);
    }
}

