/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context.impl;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.context.impl.ServiceReferenceImpl;
import org.apache.tuscany.sca.core.invocation.CallbackHandler;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class CallbackServiceReferenceImpl<B>
extends ServiceReferenceImpl<B> {
    private static final Logger logger = Logger.getLogger(CallbackServiceReferenceImpl.class.getName());
    private RuntimeEndpointReference callbackEPR;
    private List<? extends EndpointReference> callbackEPRs;
    private Endpoint resolvedEndpoint;
    private String msgID;
    private CallbackHandler callbackHandler;

    public CallbackServiceReferenceImpl() {
    }

    public CallbackServiceReferenceImpl(Class<B> interfaze, List<? extends EndpointReference> callbackEPRs) {
        super(interfaze, null, CallbackServiceReferenceImpl.getCompositeContext(callbackEPRs));
        this.callbackEPRs = callbackEPRs;
        Message msgContext = ThreadMessageContext.getMessageContext();
        this.msgID = (String)msgContext.getHeaders().get("MESSAGE_ID");
        this.resolvedEndpoint = null;
        if (msgContext.getFrom() != null) {
            this.resolvedEndpoint = msgContext.getFrom().getCallbackEndpoint();
        }
        if (this.resolvedEndpoint != null) {
            this.callbackHandler = this.resolvedEndpoint.getBinding() == null ? new CallbackHandler(this.resolvedEndpoint.getURI()) : (this.resolvedEndpoint.getBinding().getType().equals(SCABinding.TYPE) ? new CallbackHandler(this.resolvedEndpoint.getURI()) : new CallbackHandler(this.resolvedEndpoint.getBinding().getURI()));
        } else {
            this.callbackHandler = (CallbackHandler)msgContext.getHeaders().get("CALLBACK");
            if (this.callbackHandler == null) {
                this.callbackHandler = new CallbackHandler(null);
            }
        }
        if (this.callbackHandler.getCallbackTargetURI() != null) {
            logger.log(Level.FINE, "Selecting callback EPR using address from forward message: " + this.callbackHandler.getCallbackTargetURI());
        } else {
            logger.log(Level.FINE, "Selecting callback EPR using address but callback URI is null");
        }
        this.callbackEPR = this.selectCallbackEPR(msgContext);
        if (this.callbackEPR == null) {
            throw new ServiceRuntimeException("No callback binding found for " + msgContext.getTo().toString());
        }
        if (this.callbackHandler.getCallbackTargetURI() != null) {
            this.callbackEPR = this.setCallbackAddress(this.callbackEPR);
        }
        this.resolvedEndpoint = this.callbackEPR.getTargetEndpoint();
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public String getMsgID() {
        return this.msgID;
    }

    private static CompositeContext getCompositeContext(List<? extends EndpointReference> callbackEPRs) {
        if (!callbackEPRs.isEmpty()) {
            RuntimeEndpointReference epr = (RuntimeEndpointReference)callbackEPRs.get(0);
            return epr.getCompositeContext();
        }
        return null;
    }

    @Override
    protected B createProxy() throws Exception {
        return (B)this.proxyFactory.createCallbackProxy(this);
    }

    public RuntimeEndpointReference getCallbackEPR() {
        return this.callbackEPR;
    }

    public Endpoint getResolvedEndpoint() {
        return this.resolvedEndpoint;
    }

    private RuntimeEndpointReference selectCallbackEPR(Message msgContext) {
        Endpoint to = msgContext.getTo();
        if (to == null) {
            throw new ServiceRuntimeException("Destination for forward call is not available");
        }
        for (EndpointReference endpointReference : this.callbackEPRs) {
            if (!endpointReference.getBinding().getName().equals(to.getBinding().getName())) continue;
            return (RuntimeEndpointReference)endpointReference;
        }
        for (EndpointReference endpointReference : this.callbackEPRs) {
            if (!endpointReference.getBinding().getType().equals(to.getBinding().getType())) continue;
            return (RuntimeEndpointReference)endpointReference;
        }
        return null;
    }

    private RuntimeEndpointReference setCallbackAddress(RuntimeEndpointReference endpointReference) {
        try {
            RuntimeEndpointReference epr = endpointReference;
            if (this.callbackHandler.getCloneCallbackWire()) {
                epr = (RuntimeEndpointReference)endpointReference.clone();
            }
            if (epr.getBinding().getType().equals(SCABinding.TYPE)) {
                epr.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                if (this.resolvedEndpoint == null) {
                    RuntimeEndpoint callbackEndpoint = (RuntimeEndpoint)this.assemblyFactory.createEndpoint();
                    callbackEndpoint.setURI(this.callbackHandler.getCallbackTargetURI());
                    callbackEndpoint.setUnresolved(true);
                    epr.setTargetEndpoint((Endpoint)callbackEndpoint);
                } else {
                    epr.setTargetEndpoint(this.resolvedEndpoint);
                }
            } else {
                epr.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                if (this.callbackHandler.getCallbackTargetURI() != null) {
                    epr.getBinding().setURI(this.callbackHandler.getCallbackTargetURI());
                }
            }
            return epr;
        }
        catch (CloneNotSupportedException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

