/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context;

import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.context.RequestContextFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.context.impl.ComponentContextImpl;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.EndpointReferenceBinder;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.oasisopen.sca.ComponentContext;

public class DefaultComponentContextFactory
implements ComponentContextFactory {
    private final ExtensionPointRegistry registry;
    private AssemblyFactory assemblyFactory;
    private JavaInterfaceFactory javaInterfaceFactory;
    private CompositeActivator compositeActivator;
    private RequestContextFactory requestContextFactory;
    private PropertyValueFactory propertyFactory;
    private EndpointReferenceBinder eprBinder;
    private ExtensibleProxyFactory proxyFactory;

    public DefaultComponentContextFactory(ExtensionPointRegistry registry) {
        this.registry = registry;
        FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)factories.getFactory(AssemblyFactory.class);
        this.javaInterfaceFactory = (JavaInterfaceFactory)factories.getFactory(JavaInterfaceFactory.class);
        this.compositeActivator = (CompositeActivator)utilities.getUtility(CompositeActivator.class);
        this.requestContextFactory = (RequestContextFactory)((ContextFactoryExtensionPoint)registry.getExtensionPoint(ContextFactoryExtensionPoint.class)).getFactory(RequestContextFactory.class);
        this.propertyFactory = (PropertyValueFactory)factories.getFactory(PropertyValueFactory.class);
        this.eprBinder = (EndpointReferenceBinder)utilities.getUtility(EndpointReferenceBinder.class);
        this.proxyFactory = ExtensibleProxyFactory.getInstance(registry);
    }

    public ComponentContext createComponentContext(CompositeContext compositeContext, RuntimeComponent component) {
        return new ComponentContextImpl(this.registry, this.assemblyFactory, this.javaInterfaceFactory, this.compositeActivator, this.requestContextFactory, this.propertyFactory, this.eprBinder, this.proxyFactory, compositeContext, component);
    }
}

