/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.tuscany.sca.xsd.xml.XSDModelResolver;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLHelper {
    public static WSDLInterfaceContract createWSDLInterfaceContract(ExtensionPointRegistry registry, String wsdl, String wsdlCallback) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory wsdlFactory = (org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory)modelFactories.getFactory(org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory.class);
        WSDLInterfaceContract wsdlInterfaceContract = wsdlFactory.createWSDLInterfaceContract();
        wsdlInterfaceContract.setInterface((Interface)WSDLHelper.createWSDLInterface(registry, wsdl));
        if (wsdlCallback != null && wsdlCallback.length() > 0) {
            wsdlInterfaceContract.setCallbackInterface((Interface)WSDLHelper.createWSDLInterface(registry, wsdlCallback));
        }
        return wsdlInterfaceContract;
    }

    public static WSDLInterface createWSDLInterface(ExtensionPointRegistry registry, String wsdl) {
        try {
            String[] xmlArray = wsdl.split("_X_");
            String topWSDLLocation = null;
            HashMap<String, XMLString> xmlMap = new HashMap<String, XMLString>();
            for (int i = 0; i < xmlArray.length; i += 2) {
                String location = xmlArray[i];
                String xml = xmlArray[i + 1];
                if ((location = location.substring(location.lastIndexOf("/") + 1)).endsWith(".wsdl")) {
                    xmlMap.put(location, new WSDLInfo(xmlArray[i], xml));
                    if (topWSDLLocation != null) continue;
                    topWSDLLocation = location;
                    continue;
                }
                xmlMap.put(location, new XSDInfo(xmlArray[i], xml));
            }
            FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
            org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory wsdlFactory = (org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory)modelFactories.getFactory(org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory.class);
            XSDFactory xsdFactory = (XSDFactory)modelFactories.getFactory(XSDFactory.class);
            XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
            schemaCollection.setSchemaResolver((URIResolver)new XSDURIResolverImpl(xmlMap));
            ContributionFactory contributionFactory = (ContributionFactory)modelFactories.getFactory(ContributionFactory.class);
            Contribution contribution = contributionFactory.createContribution();
            ProcessorContext processorContext = new ProcessorContext();
            ExtensibleModelResolver extensibleResolver = new ExtensibleModelResolver(contribution, (ModelResolverExtensionPoint)registry.getExtensionPoint(ModelResolverExtensionPoint.class), modelFactories);
            ModelResolver wsdlResolver = extensibleResolver.getModelResolverInstance(WSDLDefinition.class);
            XSDModelResolver xsdResolver = (XSDModelResolver)extensibleResolver.getModelResolverInstance(XSDefinition.class);
            contribution.setURI("temp");
            contribution.setLocation(topWSDLLocation);
            contribution.setModelResolver((ModelResolver)extensibleResolver);
            for (XMLString xmlString : xmlMap.values()) {
                if (xmlString instanceof WSDLInfo) {
                    Definition readDefinition;
                    WSDLReader reader;
                    try {
                        reader = AccessController.doPrivileged(new PrivilegedExceptionAction<WSDLReader>(){

                            @Override
                            public WSDLReader run() throws WSDLException {
                                return WSDLFactory.newInstance().newWSDLReader();
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (WSDLException)e.getException();
                    }
                    reader.setFeature("javax.wsdl.verbose", false);
                    reader.setFeature("javax.wsdl.importDocuments", true);
                    final WSDLLocatorImpl locator = new WSDLLocatorImpl(xmlString.getBaseURI(), xmlMap);
                    final WSDLReader freader = reader;
                    try {
                        readDefinition = AccessController.doPrivileged(new PrivilegedExceptionAction<Definition>(){

                            @Override
                            public Definition run() throws WSDLException {
                                return freader.readWSDL((WSDLLocator)locator);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (WSDLException)e.getException();
                    }
                    WSDLDefinition wsdlDefinition = wsdlFactory.createWSDLDefinition();
                    wsdlDefinition.setDefinition(readDefinition);
                    wsdlDefinition.setLocation(new URI(xmlString.getBaseURI()));
                    ((WSDLInfo)xmlString).setWsdlDefintion(wsdlDefinition);
                    wsdlResolver.addModel((Object)wsdlDefinition, processorContext);
                    continue;
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getXmlString().getBytes());
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(xmlString.getBaseURI());
                XmlSchema schema = schemaCollection.read(inputSource, null);
                ((InputStream)inputStream).close();
                XSDefinition xsdDefinition = xsdFactory.createXSDefinition();
                xsdDefinition.setSchema(schema);
                ((XSDInfo)xmlString).setXsdDefinition(xsdDefinition);
                xsdResolver.addModel((Object)xsdDefinition, processorContext);
            }
            for (XMLString xmlString : xmlMap.values()) {
                if (!(xmlString instanceof WSDLInfo)) continue;
                WSDLDefinition wsdlDefinition = ((WSDLInfo)xmlString).getWsdlDefintion();
                for (Map.Entry entry : wsdlDefinition.getDefinition().getImports().entrySet()) {
                    for (Import imp : (List)entry.getValue()) {
                        String wsdlName = imp.getDefinition().getDocumentBaseURI();
                        WSDLInfo wsdlInfo = (WSDLInfo)xmlMap.get(WSDLHelper.getFilenameWithoutPath(wsdlName));
                        wsdlDefinition.getImportedDefinitions().add(wsdlInfo.getWsdlDefintion());
                    }
                }
                Types types = wsdlDefinition.getDefinition().getTypes();
                if (types == null) continue;
                int index = 0;
                for (Object ext : types.getExtensibilityElements()) {
                    ExtensibilityElement extElement = (ExtensibilityElement)ext;
                    Element element = null;
                    if (extElement instanceof Schema) {
                        element = ((Schema)extElement).getElement();
                    }
                    if (element == null) continue;
                    XSDefinition xsDefinition = xsdFactory.createXSDefinition();
                    xsDefinition.setUnresolved(true);
                    xsDefinition.setNamespace(element.getAttribute("targetNamespace"));
                    xsDefinition.setDocument(element.getOwnerDocument());
                    XmlSchema schema = schemaCollection.read(element, null);
                    xsDefinition.setSchema(schema);
                    xsDefinition.setLocation(URI.create(xmlString.getBaseURI() + "#" + index));
                    wsdlDefinition.getXmlSchemas().add(xsDefinition);
                    ++index;
                }
            }
            WSDLInfo topWSDL = (WSDLInfo)xmlMap.get(topWSDLLocation);
            WSDLDefinition topWSDLDefinition = topWSDL.getWsdlDefintion();
            PortType portType = (PortType)topWSDLDefinition.getDefinition().getAllPortTypes().values().iterator().next();
            WSDLInterface readWSDLInterface = wsdlFactory.createWSDLInterface(portType, topWSDLDefinition, (ModelResolver)extensibleResolver, null);
            return readWSDLInterface;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static InputSource getInputSource(String uri, Map<String, XMLString> xmlMap) {
        String xmlString = xmlMap.get(uri).getXmlString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes());
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uri);
        return inputSource;
    }

    private static String getFilenameWithoutPath(String filename) {
        int xsdIndex = filename.lastIndexOf("?xsd=");
        int wsdlIndex = filename.lastIndexOf("/");
        if (xsdIndex >= 0) {
            return filename.substring(xsdIndex + 5);
        }
        return filename.substring(wsdlIndex + 1);
    }

    private static class XSDURIResolverImpl
    extends DefaultURIResolver {
        private Map<String, XMLString> xmlMap;

        public XSDURIResolverImpl(Map<String, XMLString> xmlMap) {
            this.xmlMap = xmlMap;
        }

        protected URL getURL(URL contextURL, String spec) throws IOException {
            return super.getURL(contextURL, spec);
        }

        public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
            return WSDLHelper.getInputSource(WSDLHelper.getFilenameWithoutPath(schemaLocation), this.xmlMap);
        }
    }

    private static class WSDLLocatorImpl
    implements WSDLLocator {
        private Map<String, XMLString> xmlMap;
        private String baseURI;
        private String latestImportURI;

        public WSDLLocatorImpl(String baseURI, Map<String, XMLString> xmlMap) {
            this.baseURI = baseURI;
            this.xmlMap = xmlMap;
        }

        public void close() {
        }

        public InputSource getBaseInputSource() {
            return WSDLHelper.getInputSource(WSDLHelper.getFilenameWithoutPath(this.baseURI), this.xmlMap);
        }

        public String getBaseURI() {
            return this.baseURI;
        }

        public InputSource getImportInputSource(String parentLocation, String importLocation) {
            this.latestImportURI = importLocation;
            return WSDLHelper.getInputSource(WSDLHelper.getFilenameWithoutPath(importLocation), this.xmlMap);
        }

        public String getLatestImportURI() {
            return this.latestImportURI;
        }
    }

    private static class WSDLInfo
    extends XMLString {
        WSDLDefinition wsdlDefintion;

        public WSDLInfo(String baseURI, String xmlString) {
            super(baseURI, xmlString);
        }

        public void setWsdlDefintion(WSDLDefinition wsdlDefintion) {
            this.wsdlDefintion = wsdlDefintion;
        }

        public WSDLDefinition getWsdlDefintion() {
            return this.wsdlDefintion;
        }
    }

    private static class XSDInfo
    extends XMLString {
        XSDefinition xsdDefinition;

        public XSDInfo(String baseURI, String xmlString) {
            super(baseURI, xmlString);
        }

        public void setXsdDefinition(XSDefinition xsdDefinition) {
            this.xsdDefinition = xsdDefinition;
        }

        public XSDefinition getXsdDefinition() {
            return this.xsdDefinition;
        }
    }

    private static class XMLString {
        private String baseURI;
        private String xmlString;

        public XMLString(String baseURI, String xmlString) {
            this.baseURI = baseURI;
            this.xmlString = xmlString;
        }

        public String getBaseURI() {
            return this.baseURI;
        }

        public String getXmlString() {
            return this.xmlString;
        }
    }
}

