/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.impl.EndpointReferenceImpl;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistryLocator;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.AsyncResponseService;
import org.apache.tuscany.sca.core.invocation.ExtensibleWireProcessor;
import org.apache.tuscany.sca.core.invocation.NonBlockingInterceptor;
import org.apache.tuscany.sca.core.invocation.RuntimeInvoker;
import org.apache.tuscany.sca.core.invocation.impl.InvocationChainImpl;
import org.apache.tuscany.sca.core.invocation.impl.PhaseManager;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InterceptorAsync;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.EndpointReferenceProvider;
import org.apache.tuscany.sca.provider.ImplementationAsyncProvider;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.PolicyProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.EndpointReferenceBinder;
import org.apache.tuscany.sca.runtime.EndpointSerializer;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessorExtensionPoint;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceRuntimeException;

public class RuntimeEndpointReferenceImpl
extends EndpointReferenceImpl
implements RuntimeEndpointReference,
Externalizable {
    private transient CompositeContext compositeContext;
    private transient RuntimeWireProcessor wireProcessor;
    private transient InterfaceContractMapper interfaceContractMapper;
    private transient WorkScheduler workScheduler;
    private transient PhaseManager phaseManager;
    private transient MessageFactory messageFactory;
    private transient RuntimeInvoker invoker;
    private transient DomainRegistry domainRegistry;
    private transient List<InvocationChain> chains;
    private transient Map<Operation, InvocationChain> invocationChainMap = new ConcurrentHashMap<Operation, InvocationChain>();
    private transient InvocationChain bindingInvocationChain;
    private transient EndpointReferenceBinder eprBinder;
    private transient ReferenceBindingProvider bindingProvider;
    private transient ProviderFactoryExtensionPoint providerFactories;
    private transient List<PolicyProvider> policyProviders;
    private transient EndpointSerializer serializer;
    protected InterfaceContract bindingInterfaceContract;
    protected InterfaceContract referenceInterfaceContract;
    private String xml;
    private boolean started;
    private RuntimeEndpointReference delegateEndpointReference;
    private boolean bindingURIaltered;

    public RuntimeEndpointReferenceImpl() {
        super(null);
    }

    public RuntimeEndpointReferenceImpl(ExtensionPointRegistry registry) {
        super(registry);
    }

    protected void copyFrom(RuntimeEndpointReferenceImpl copy) {
        this.xml = copy.xml;
        this.component = copy.component;
        this.reference = copy.reference;
        this.interfaceContract = copy.interfaceContract;
        this.referenceInterfaceContract = copy.referenceInterfaceContract;
        this.callbackEndpoint = copy.callbackEndpoint;
        this.targetEndpoint = copy.targetEndpoint;
        this.binding = copy.binding;
        this.bindingInterfaceContract = copy.interfaceContract;
        this.bindingInvocationChain = copy.bindingInvocationChain;
        this.requiredIntents = copy.requiredIntents;
        this.policySets = copy.policySets;
        this.uri = copy.uri;
        this.unresolved = copy.unresolved;
        this.status = copy.status;
        this.chains = copy.chains;
        this.invocationChainMap = copy.invocationChainMap;
        this.bindingProvider = copy.bindingProvider;
        this.policyProviders = copy.policyProviders;
        if (this.compositeContext == null && copy.compositeContext != null) {
            this.bind(copy.compositeContext);
        }
    }

    public void bind(CompositeContext compositeContext) {
        this.compositeContext = compositeContext;
        this.bind(compositeContext.getExtensionPointRegistry(), compositeContext.getEndpointRegistry());
    }

    public void bind(ExtensionPointRegistry registry, DomainRegistry domainRegistry) {
        if (this.compositeContext == null) {
            this.compositeContext = new CompositeContext(registry, domainRegistry);
        }
        this.registry = registry;
        this.domainRegistry = domainRegistry;
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.eprBinder = (EndpointReferenceBinder)utilities.getUtility(EndpointReferenceBinder.class);
        this.interfaceContractMapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
        this.workScheduler = (WorkScheduler)utilities.getUtility(WorkScheduler.class);
        this.wireProcessor = new ExtensibleWireProcessor((RuntimeWireProcessorExtensionPoint)registry.getExtensionPoint(RuntimeWireProcessorExtensionPoint.class));
        this.messageFactory = (MessageFactory)((FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class)).getFactory(MessageFactory.class);
        this.invoker = new RuntimeInvoker(registry, (Invocable)this);
        this.phaseManager = (PhaseManager)utilities.getUtility(PhaseManager.class);
        this.serializer = (EndpointSerializer)utilities.getUtility(EndpointSerializer.class);
        this.providerFactories = (ProviderFactoryExtensionPoint)registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.builders = (BuilderExtensionPoint)registry.getExtensionPoint(BuilderExtensionPoint.class);
        this.contractBuilder = this.builders.getContractBuilder();
    }

    public synchronized List<InvocationChain> getInvocationChains() {
        if (this.chains == null) {
            this.initInvocationChains();
        }
        return this.chains;
    }

    public synchronized InvocationChain getBindingInvocationChain() {
        if (this.bindingInvocationChain == null) {
            this.bindingInvocationChain = new InvocationChainImpl(null, null, true, this.phaseManager, this.isAsyncInvocation());
            this.initReferenceBindingInvocationChains();
        }
        return this.bindingInvocationChain;
    }

    public InvocationChain getInvocationChain(Operation operation) {
        InvocationChain cached = this.invocationChainMap.get(operation);
        if (cached == null) {
            for (InvocationChain chain : this.getInvocationChains()) {
                Operation op = chain.getSourceOperation();
                if (!operation.getName().equals(op.getName())) continue;
                this.invocationChainMap.put(operation, chain);
                return chain;
            }
            this.invocationChainMap.put(operation, null);
            return null;
        }
        return cached;
    }

    public Message invoke(Message msg) {
        return this.invoker.invoke(msg);
    }

    public Object invoke(Operation operation, Object[] args) throws InvocationTargetException {
        return this.invoker.invoke(operation, args);
    }

    public Message invoke(Operation operation, Message msg) {
        return this.invoker.invoke(operation, msg);
    }

    public void invokeAsync(Operation operation, Message msg) {
        msg.setOperation(operation);
        this.invoker.invokeAsync(msg);
    }

    public void invokeAsync(Message msg) {
        this.invoker.invokeAsync(msg);
    }

    public void invokeAsyncResponse(Message msg) {
        Invoker tailInvoker;
        InvocationChain chain = this.getBindingInvocationChain();
        if (chain != null && (tailInvoker = chain.getTailInvoker()) != null) {
            ((InvokerAsyncResponse)tailInvoker).invokeAsyncResponse(msg);
        }
        chain = this.getInvocationChain(msg.getOperation());
        tailInvoker = chain.getTailInvoker();
        ((InvokerAsyncResponse)tailInvoker).invokeAsyncResponse(msg);
    }

    private Contract getLeafContract(Contract contract) {
        Contract prev = null;
        Contract current = contract;
        while (current != null) {
            prev = current;
            if (current instanceof ComponentReference) {
                current = ((ComponentReference)current).getReference();
            } else if (current instanceof CompositeReference) {
                current = (Contract)((CompositeReference)current).getPromotedReferences().get(0);
            } else if (current instanceof ComponentService) {
                current = ((ComponentService)current).getService();
            } else {
                if (!(current instanceof CompositeService)) break;
                current = ((CompositeService)current).getPromotedService();
            }
            if (current != null) continue;
            return prev;
        }
        return current;
    }

    private void initInvocationChains() {
        RuntimeComponentReference theReference;
        RuntimeComponent theComponent;
        ImplementationProvider implementationProvider;
        InterfaceContract sourceContract = this.getComponentTypeReferenceInterfaceContract();
        this.resolveEndpointReference();
        InterfaceContract targetContract = this.getBindingInterfaceContract();
        if (sourceContract == null && targetContract != null) {
            try {
                sourceContract = (InterfaceContract)targetContract.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }
        this.validateReferenceInterfaceCompatibility();
        ArrayList<InvocationChain> chainList = new ArrayList<InvocationChain>();
        if (sourceContract != null && targetContract != null) {
            RuntimeComponentReference reference = (RuntimeComponentReference)this.getReference();
            for (Operation operation : sourceContract.getInterface().getOperations()) {
                Operation targetOperation = this.interfaceContractMapper.map(targetContract.getInterface(), operation);
                if (targetOperation == null) {
                    throw new ServiceRuntimeException("No matching operation for " + operation.getName() + " is found in reference " + this.getComponent().getURI() + "#" + reference.getName());
                }
                InvocationChain chain = new InvocationChainImpl(operation, targetOperation, true, this.phaseManager, this.isAsyncInvocation());
                if (operation.isNonBlocking()) {
                    this.addNonBlockingInterceptor(chain);
                }
                chainList.add(chain);
                this.addReferenceBindingInterceptor(chain, operation);
            }
        }
        this.chains = chainList;
        this.wireProcessor.process((RuntimeEndpointReference)this);
        this.bindingURIaltered = false;
        if (this.isAsyncInvocation() && (implementationProvider = (theComponent = (theReference = (RuntimeComponentReference)this.getReference()).getComponent()).getImplementationProvider()) instanceof ImplementationAsyncProvider) {
            for (InvocationChain chain : this.getInvocationChains()) {
                InvokerAsyncResponse asyncResponseInvoker = ((ImplementationAsyncProvider)implementationProvider).createAsyncResponseInvoker(chain.getSourceOperation());
                if (!(chain.getHeadInvoker() instanceof InterceptorAsync)) continue;
                ((InterceptorAsync)chain.getHeadInvoker()).setPrevious(asyncResponseInvoker);
            }
        }
    }

    public void validateReferenceInterfaceCompatibility() {
        InterfaceContract referenceContract = this.getComponentReferenceInterfaceContract();
        InterfaceContract bindingContract = this.getBindingInterfaceContract();
        if (referenceContract != null && bindingContract != null) {
            boolean bindingHasCallback = bindingContract.getCallbackInterface() != null;
            try {
                if (referenceContract.getClass() != bindingContract.getClass() || referenceContract.getNormalizedWSDLContract() != null || bindingContract.getNormalizedWSDLContract() != null) {
                    this.interfaceContractMapper.checkCompatibility(this.getGeneratedWSDLContract(referenceContract), this.getGeneratedWSDLContract(bindingContract), Compatibility.SUBSET, !bindingHasCallback, false);
                } else {
                    this.interfaceContractMapper.checkCompatibility(referenceContract, bindingContract, Compatibility.SUBSET, !bindingHasCallback, false);
                }
            }
            catch (Exception ex) {
                throw new ServiceRuntimeException("Component " + this.getComponent().getName() + " Reference " + this.getReference().getName() + " interface is incompatible with the interface of the reference binding " + this.getBinding().getName() + " - " + ex.getMessage() + " - [" + this.toString() + "]");
            }
        }
    }

    private void resolveEndpointReference() {
        this.resolve();
        this.eprBinder.bindRunTime(this.domainRegistry, (EndpointReference)this);
        final ReferenceBindingProvider bindingProvider = this.getBindingProvider();
        if (bindingProvider != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    bindingProvider.start();
                    return null;
                }
            });
        }
        for (PolicyProvider policyProvider : this.getPolicyProviders()) {
            policyProvider.start();
        }
        this.started = true;
        ComponentReference ref = this.getReference();
        String refName = ref.getName();
        if (!(refName.startsWith("$self$.") || refName.startsWith("$sca.client$.") || ref.isForCallback())) {
            this.compositeContext.getEndpointRegistry().addEndpointReference((EndpointReference)this);
        }
    }

    private void initReferenceBindingInvocationChains() {
        ReferenceBindingProvider provider = this.getBindingProvider();
        if (provider != null && provider instanceof EndpointReferenceProvider) {
            ((EndpointReferenceProvider)provider).configure();
        }
        for (PolicyProvider p : this.getPolicyProviders()) {
            PhasedInterceptor interceptor = p.createBindingInterceptor();
            if (interceptor == null) continue;
            this.bindingInvocationChain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void rebuild() {
        this.chains = null;
        this.invocationChainMap.clear();
        if (this.getStatus() == EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED) {
            this.setStatus(EndpointReference.Status.NOT_CONFIGURED);
        }
    }

    private void addReferenceBindingInterceptor(InvocationChain chain, Operation operation) {
        List<PolicyProvider> pps;
        Invoker invoker;
        ReferenceBindingProvider provider = this.getBindingProvider();
        if (provider != null && (invoker = provider.createInvoker(operation)) != null) {
            chain.addInvoker(invoker);
        }
        if ((pps = this.getPolicyProviders()) != null) {
            for (PolicyProvider p : pps) {
                PhasedInterceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor((Interceptor)interceptor);
            }
        }
    }

    private void addNonBlockingInterceptor(InvocationChain chain) {
        boolean supportsOneWayInvocation;
        ReferenceBindingProvider provider = this.getBindingProvider();
        if (provider != null && !(supportsOneWayInvocation = provider.supportsOneWayInvocation())) {
            chain.addInterceptor("component.reference", (Interceptor)new NonBlockingInterceptor(this.workScheduler));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RuntimeEndpointReferenceImpl copy = (RuntimeEndpointReferenceImpl)super.clone();
        copy.invoker = new RuntimeInvoker(this.registry, (Invocable)copy);
        return copy;
    }

    public boolean isOutOfDate() {
        this.resolve();
        return this.bindingURIaltered || this.eprBinder.isOutOfDate(this.domainRegistry, (EndpointReference)this);
    }

    public synchronized ReferenceBindingProvider getBindingProvider() {
        this.resolve();
        if (this.binding == null) {
            return null;
        }
        if (this.bindingProvider == null) {
            BindingProviderFactory factory = (BindingProviderFactory)this.providerFactories.getProviderFactory(this.getBinding().getClass());
            if (factory == null) {
                throw new ServiceRuntimeException("No provider factory is registered for binding " + this.getBinding().getType());
            }
            this.bindingProvider = factory.createReferenceBindingProvider((RuntimeEndpointReference)this);
        }
        return this.bindingProvider;
    }

    public void setBindingProvider(ReferenceBindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public synchronized List<PolicyProvider> getPolicyProviders() {
        this.resolve();
        if (this.policyProviders == null) {
            this.policyProviders = new ArrayList<PolicyProvider>();
            for (PolicyProviderFactory factory : this.providerFactories.getPolicyProviderFactories()) {
                PolicyProvider provider = factory.createReferencePolicyProvider((EndpointReference)this);
                if (provider == null) continue;
                this.policyProviders.add(provider);
            }
        }
        return this.policyProviders;
    }

    public void unbind() {
        this.bindingInvocationChain = null;
        this.chains = null;
        this.bindingProvider = null;
        this.policyProviders = null;
        this.invocationChainMap.clear();
    }

    public Contract getContract() {
        return this.getReference();
    }

    public CompositeContext getCompositeContext() {
        return this.compositeContext;
    }

    public InterfaceContract getBindingInterfaceContract() {
        this.resolve();
        if (this.bindingInterfaceContract != null) {
            return this.bindingInterfaceContract;
        }
        ReferenceBindingProvider provider = this.getBindingProvider();
        if (provider != null) {
            this.bindingInterfaceContract = provider.getBindingInterfaceContract();
        }
        if (this.bindingInterfaceContract == null) {
            this.bindingInterfaceContract = this.getComponentReferenceInterfaceContract();
        }
        if (this.bindingInterfaceContract == null) {
            this.bindingInterfaceContract = this.getComponentTypeReferenceInterfaceContract();
        }
        return this.bindingInterfaceContract;
    }

    public InterfaceContract getComponentTypeReferenceInterfaceContract() {
        this.resolve();
        if (this.referenceInterfaceContract != null) {
            return this.referenceInterfaceContract;
        }
        if (this.reference == null) {
            return this.getComponentReferenceInterfaceContract();
        }
        this.referenceInterfaceContract = this.getLeafContract((Contract)this.reference).getInterfaceContract();
        if (this.referenceInterfaceContract == null) {
            this.referenceInterfaceContract = this.getComponentReferenceInterfaceContract();
        }
        return this.referenceInterfaceContract;
    }

    protected synchronized void resolve() {
        if (this.xml != null && this.component == null) {
            if (this.compositeContext == null) {
                this.compositeContext = CompositeContext.getCurrentCompositeContext();
                if (this.compositeContext != null) {
                    this.bind(this.compositeContext);
                }
            }
            if (this.serializer != null) {
                RuntimeEndpointReferenceImpl epr = (RuntimeEndpointReferenceImpl)this.serializer.readEndpointReference(this.xml);
                this.copyFrom(epr);
            } else {
                ExtensionPointRegistry registry = ExtensionPointRegistryLocator.getExtensionPointRegistry();
                if (registry != null) {
                    this.registry = registry;
                    UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
                    this.serializer = (EndpointSerializer)utilities.getUtility(EndpointSerializer.class);
                    RuntimeEndpointReferenceImpl epr = (RuntimeEndpointReferenceImpl)this.serializer.readEndpointReference(this.xml);
                    if ((epr = this.findActualEPR(epr, registry)) != null) {
                        this.copyFrom(epr);
                    }
                }
            }
        }
        super.resolve();
    }

    private RuntimeEndpointReferenceImpl findActualEPR(RuntimeEndpointReferenceImpl epr, ExtensionPointRegistry registry) {
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance((ExtensionPointRegistry)registry);
        if (domainRegistryFactory == null) {
            return null;
        }
        DomainRegistry domainRegistry = (DomainRegistry)domainRegistryFactory.getEndpointRegistries().toArray()[0];
        if (domainRegistry == null) {
            return null;
        }
        for (EndpointReference epReference : domainRegistry.getEndpointReferences()) {
            if (!epReference.getURI().equals(epr.getURI())) continue;
            return (RuntimeEndpointReferenceImpl)epReference;
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uri = in.readUTF();
        this.xml = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getURI());
        if (this.serializer == null && this.xml != null) {
            out.writeUTF(this.xml);
        } else if (this.serializer != null) {
            out.writeUTF(this.serializer.write((EndpointReference)this));
        } else {
            throw new IllegalStateException("No serializer is configured");
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public InterfaceContract getGeneratedWSDLContract(InterfaceContract interfaceContract) {
        if (interfaceContract.getNormalizedWSDLContract() == null && this.getComponentReferenceInterfaceContract() instanceof JavaInterfaceContract) {
            if (this.contractBuilder == null) {
                throw new ServiceRuntimeException("Contract builder not found while calculating WSDL contract for " + this.toString());
            }
            this.contractBuilder.build(interfaceContract, null);
        }
        return interfaceContract.getNormalizedWSDLContract();
    }

    public void createAsyncCallbackEndpoint() {
        CompositeContext compositeContext = this.getCompositeContext();
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        RuntimeAssemblyFactory assemblyFactory = (RuntimeAssemblyFactory)((Object)modelFactories.getFactory(AssemblyFactory.class));
        RuntimeEndpoint endpoint = (RuntimeEndpoint)assemblyFactory.createEndpoint();
        endpoint.bind(compositeContext);
        endpoint.setComponent(this.getComponent());
        ComponentService service = assemblyFactory.createComponentService();
        JavaInterfaceFactory javaInterfaceFactory = (JavaInterfaceFactory)modelFactories.getFactory(JavaInterfaceFactory.class);
        JavaInterfaceContract interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
        try {
            interfaceContract.setInterface((Interface)javaInterfaceFactory.createJavaInterface(AsyncResponseService.class));
        }
        catch (InvalidInterfaceException e1) {
            // empty catch block
        }
        service.setInterfaceContract((InterfaceContract)interfaceContract);
        String serviceName = this.getReference().getName() + "_asyncCallback";
        service.setName(serviceName);
        service.getEndpoints().add(endpoint);
        service.setForCallback(true);
        endpoint.setService(service);
        this.getComponent().getServices().add(service);
        InterfaceContract referenceInterfaceContract = this.getComponentTypeReferenceInterfaceContract();
        if (referenceInterfaceContract instanceof WSDLInterfaceContract) {
            WSDLInterfaceContract wsdlInterfaceContract = (WSDLInterfaceContract)endpoint.getGeneratedWSDLContract((InterfaceContract)interfaceContract);
            service.setInterfaceContract((InterfaceContract)wsdlInterfaceContract);
        }
        Binding binding = null;
        try {
            binding = (Binding)this.getBinding().clone();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String callbackURI = "/" + this.component.getName() + "/" + service.getName();
        binding.setURI(callbackURI);
        BuilderExtensionPoint builders = (BuilderExtensionPoint)this.registry.getExtensionPoint(BuilderExtensionPoint.class);
        BindingBuilder builder = builders.getBindingBuilder(binding.getType());
        if (builder != null) {
            BuilderContext builderContext = new BuilderContext(this.registry);
            builder.build(this.component, (Contract)service, binding, builderContext, true);
        }
        endpoint.setBinding(binding);
        endpoint.getRequiredIntents().addAll(this.getRequiredIntents());
        endpoint.getPolicySets().addAll(this.getPolicySets());
        String epURI = this.getComponent().getName() + "#service-binding(" + serviceName + "/" + serviceName + ")";
        endpoint.setURI(epURI);
        endpoint.setUnresolved(false);
        this.setCallbackEndpoint((Endpoint)endpoint);
    }

    public RuntimeEndpointReference getDelegateEndpointReference() {
        return this.delegateEndpointReference;
    }

    public void setDelegateEndpointReference(RuntimeEndpointReference delegateEndpointReference) {
        this.delegateEndpointReference = delegateEndpointReference;
    }

    public InvokerAsyncResponse getAsyncResponseInvoker(Operation op) {
        InvocationChain chain = this.getInvocationChain(op);
        Invoker headInvoker = chain.getHeadInvoker();
        if (headInvoker instanceof InterceptorAsync) {
            InvokerAsyncResponse responseInvoker = ((InterceptorAsync)headInvoker).getPrevious();
            return responseInvoker;
        }
        return null;
    }

    public void setBindingURI(String uri) {
        this.binding.setURI(uri);
        this.bindingURIaltered = true;
        BindingBuilder builder = this.builders.getBindingBuilder(this.binding.getType());
        if (builder != null) {
            BuilderContext builderContext = new BuilderContext(null, null, null);
            builder.build(this.component, (Contract)this.reference, this.binding, builderContext, true);
        }
    }
}

