/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.impl.EndpointImpl;
import org.apache.tuscany.sca.assembly.xml.InterfaceContractProcessor;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistryLocator;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.core.invocation.AsyncResponseService;
import org.apache.tuscany.sca.core.invocation.ExtensibleWireProcessor;
import org.apache.tuscany.sca.core.invocation.NonBlockingInterceptor;
import org.apache.tuscany.sca.core.invocation.RuntimeInvoker;
import org.apache.tuscany.sca.core.invocation.impl.InvocationChainImpl;
import org.apache.tuscany.sca.core.invocation.impl.PhaseManager;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InterceptorAsync;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.invocation.PhasedInterceptor;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.ImplementationAsyncProvider;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.OptimisingBindingProvider;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.PolicyProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.EndpointSerializer;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessorExtensionPoint;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.oasisopen.sca.ServiceRuntimeException;

public class RuntimeEndpointImpl
extends EndpointImpl
implements RuntimeEndpoint,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte[] separator = new byte[]{95, 88, 95};
    private transient CompositeContext compositeContext;
    private transient RuntimeWireProcessor wireProcessor;
    private transient ProviderFactoryExtensionPoint providerFactories;
    private transient InterfaceContractMapper interfaceContractMapper;
    private transient WorkScheduler workScheduler;
    private transient PhaseManager phaseManager;
    private transient MessageFactory messageFactory;
    private transient RuntimeInvoker invoker;
    private transient EndpointSerializer serializer;
    private transient List<InvocationChain> chains;
    private transient Map<Operation, InvocationChain> invocationChainMap = new ConcurrentHashMap<Operation, InvocationChain>();
    private transient InvocationChain bindingInvocationChain;
    private transient ServiceBindingProvider bindingProvider;
    private transient List<PolicyProvider> policyProviders;
    private String xml;
    private String interfaceContractXML;
    protected InterfaceContract bindingInterfaceContract;
    protected InterfaceContract serviceInterfaceContract;
    private RuntimeEndpoint delegateEndpoint;
    private static final InvocationChain NULL_CHAIN = new InvocationChainImpl(null, null, false, null, false);

    public RuntimeEndpointImpl() {
        super(null);
    }

    public RuntimeEndpointImpl(ExtensionPointRegistry registry) {
        super(registry);
    }

    protected void copyFrom(RuntimeEndpointImpl copy) {
        this.xml = copy.xml;
        this.component = copy.component;
        this.service = copy.service;
        this.interfaceContract = copy.interfaceContract;
        this.serviceInterfaceContract = copy.serviceInterfaceContract;
        this.binding = copy.binding;
        this.bindingInterfaceContract = copy.interfaceContract;
        this.bindingInvocationChain = copy.bindingInvocationChain;
        this.callbackEndpointReferences = copy.callbackEndpointReferences;
        this.requiredIntents = copy.requiredIntents;
        this.policySets = copy.policySets;
        this.uri = copy.uri;
        this.remote = copy.remote;
        this.unresolved = copy.unresolved;
        this.chains = copy.chains;
        this.invocationChainMap = copy.invocationChainMap;
        this.bindingProvider = copy.bindingProvider;
        this.policyProviders = copy.policyProviders;
        if (this.compositeContext == null && copy.compositeContext != null) {
            this.bind(copy.compositeContext);
        }
    }

    public void bind(CompositeContext compositeContext) {
        this.compositeContext = compositeContext;
        this.bind(compositeContext.getExtensionPointRegistry(), compositeContext.getEndpointRegistry());
    }

    public void bind(ExtensionPointRegistry registry, DomainRegistry domainRegistry) {
        if (this.compositeContext == null) {
            this.compositeContext = new CompositeContext(registry, domainRegistry);
        }
        if (this.interfaceContractMapper != null) {
            return;
        }
        this.registry = registry;
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
        this.workScheduler = (WorkScheduler)utilities.getUtility(WorkScheduler.class);
        this.wireProcessor = new ExtensibleWireProcessor((RuntimeWireProcessorExtensionPoint)registry.getExtensionPoint(RuntimeWireProcessorExtensionPoint.class));
        this.messageFactory = (MessageFactory)((FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class)).getFactory(MessageFactory.class);
        this.invoker = new RuntimeInvoker(registry, (Invocable)this);
        this.phaseManager = (PhaseManager)utilities.getUtility(PhaseManager.class);
        this.serializer = (EndpointSerializer)utilities.getUtility(EndpointSerializer.class);
        this.providerFactories = (ProviderFactoryExtensionPoint)registry.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.builders = (BuilderExtensionPoint)registry.getExtensionPoint(BuilderExtensionPoint.class);
        this.contractBuilder = this.builders.getContractBuilder();
    }

    public void unbind() {
        this.compositeContext = null;
        this.bindingInvocationChain = null;
        this.chains = null;
        this.bindingProvider = null;
        this.policyProviders = null;
        this.invocationChainMap.clear();
    }

    public synchronized List<InvocationChain> getInvocationChains() {
        if (this.chains == null) {
            this.initInvocationChains();
        }
        return this.chains;
    }

    public synchronized InvocationChain getBindingInvocationChain() {
        if (this.bindingInvocationChain == null) {
            this.bindingInvocationChain = new InvocationChainImpl(null, null, false, this.phaseManager, this.isAsyncInvocation());
            this.initServiceBindingInvocationChains();
        }
        this.getInvocationChains();
        return this.bindingInvocationChain;
    }

    public InvocationChain getInvocationChain(Operation operation) {
        InvocationChain cached = this.invocationChainMap.get(operation);
        if (cached == null) {
            for (InvocationChain chain : this.getInvocationChains()) {
                Operation op = chain.getTargetOperation();
                if (operation.getInterface().isRemotable()) {
                    if (operation.getName().equals(op.getName())) {
                        this.invocationChainMap.put(operation, chain);
                        return chain;
                    }
                    if (!this.interfaceContractMapper.isCompatible(operation, op, Compatibility.SUBSET)) continue;
                    this.invocationChainMap.put(operation, chain);
                    return chain;
                }
                if (!this.interfaceContractMapper.isCompatible(operation, op, Compatibility.SUBSET)) continue;
                this.invocationChainMap.put(operation, chain);
                return chain;
            }
            this.invocationChainMap.put(operation, NULL_CHAIN);
            return null;
        }
        if (cached == NULL_CHAIN) {
            cached = null;
        }
        return cached;
    }

    public Message invoke(Message msg) {
        this.getInvocationChains();
        if (this.isAsyncInvocation() && !this.getCallbackEndpointReferences().isEmpty()) {
            RuntimeEndpointReference asyncEPR = (RuntimeEndpointReference)this.getCallbackEndpointReferences().get(0);
            msg.getHeaders().put("ASYNC_CALLBACK", asyncEPR);
        }
        return this.invoker.invokeBinding(msg);
    }

    public Object invoke(Operation operation, Object[] args) throws InvocationTargetException {
        return this.invoker.invoke(operation, args);
    }

    public Message invoke(Operation operation, Message msg) {
        return this.invoker.invoke(operation, msg);
    }

    public void invokeAsync(Message msg) {
        this.invoker.invokeBindingAsync(msg);
    }

    public void invokeAsync(Operation operation, Message msg) {
        msg.setOperation(operation);
        this.invoker.invokeAsync(msg);
    }

    public void invokeAsyncResponse(Message msg) {
        this.resolve();
        this.invoker.invokeAsyncResponse(msg);
    }

    private Contract getLeafContract(Contract contract) {
        Contract prev = null;
        Contract current = contract;
        while (current != null) {
            prev = current;
            if (current instanceof ComponentReference) {
                current = ((ComponentReference)current).getReference();
            } else if (current instanceof CompositeReference) {
                current = (Contract)((CompositeReference)current).getPromotedReferences().get(0);
            } else if (current instanceof ComponentService) {
                current = ((ComponentService)current).getService();
            } else {
                if (!(current instanceof CompositeService)) break;
                current = ((CompositeService)current).getPromotedService();
            }
            if (current != null) continue;
            return prev;
        }
        return current;
    }

    private void initInvocationChains() {
        ServiceBindingProvider provider;
        ServiceBindingProvider serviceBindingProvider;
        this.chains = new ArrayList<InvocationChain>();
        InterfaceContract sourceContract = this.getBindingInterfaceContract();
        RuntimeComponentService service = (RuntimeComponentService)this.getService();
        RuntimeComponent serviceComponent = (RuntimeComponent)this.getComponent();
        InterfaceContract targetContract = this.getComponentTypeServiceInterfaceContract();
        this.validateServiceInterfaceCompatibility();
        for (Operation operation : sourceContract.getInterface().getOperations()) {
            Operation targetOperation = this.interfaceContractMapper.map(targetContract.getInterface(), operation);
            if (targetOperation == null) {
                throw new ServiceRuntimeException("No matching operation for " + operation.getName() + " is found in service " + serviceComponent.getURI() + "#" + service.getName());
            }
            InvocationChainImpl chain = new InvocationChainImpl(operation, targetOperation, false, this.phaseManager, this.isAsyncInvocation());
            if (operation.isNonBlocking()) {
                this.addNonBlockingInterceptor(chain);
            }
            this.addServiceBindingInterceptor(chain, operation);
            this.addImplementationInterceptor((Component)serviceComponent, (ComponentService)service, chain, targetOperation);
            this.chains.add(chain);
            if (!targetOperation.isAsyncServer()) continue;
            this.createAsyncServerCallback();
        }
        this.wireProcessor.process((RuntimeEndpoint)this);
        if (this.isAsyncInvocation() && this.bindingInvocationChain == null && (serviceBindingProvider = this.getBindingProvider()) instanceof EndpointAsyncProvider) {
            EndpointAsyncProvider asyncEndpointProvider = (EndpointAsyncProvider)serviceBindingProvider;
            InvokerAsyncResponse asyncResponseInvoker = asyncEndpointProvider.createAsyncResponseInvoker();
            for (InvocationChain chain : this.getInvocationChains()) {
                Invoker invoker = chain.getHeadInvoker();
                if (!(invoker instanceof InterceptorAsync)) continue;
                ((InterceptorAsync)invoker).setPrevious(asyncResponseInvoker);
            }
        }
        if ((provider = this.getBindingProvider()) != null && provider instanceof OptimisingBindingProvider) {
            ((OptimisingBindingProvider)provider).optimiseBinding((RuntimeEndpoint)this);
        }
    }

    public void createAsyncServerCallback() {
        if (this.hasNativeAsyncBinding(this)) {
            return;
        }
        if (this.asyncCallbackExists(this)) {
            return;
        }
        RuntimeEndpointReference asyncEPR = this.createAsyncEPR(this);
        this.getCallbackEndpointReferences().add(asyncEPR);
        DomainRegistry epReg = this.getEndpointRegistry(this.registry);
        if (epReg != null) {
            epReg.addEndpointReference((EndpointReference)asyncEPR);
        }
    }

    public RuntimeEndpointReference getAsyncServerCallback() {
        return (RuntimeEndpointReference)this.getCallbackEndpointReferences().get(0);
    }

    private boolean hasNativeAsyncBinding(RuntimeEndpoint endpoint) {
        EndpointAsyncProvider asyncProvider;
        ServiceBindingProvider provider = endpoint.getBindingProvider();
        return provider instanceof EndpointAsyncProvider && (asyncProvider = (EndpointAsyncProvider)provider).supportsNativeAsync();
    }

    private RuntimeEndpointReference createAsyncEPR(RuntimeEndpoint endpoint) {
        CompositeContext compositeContext = endpoint.getCompositeContext();
        RuntimeAssemblyFactory assemblyFactory = this.getAssemblyFactory(compositeContext);
        RuntimeEndpointReference epr = (RuntimeEndpointReference)assemblyFactory.createEndpointReference();
        epr.bind(compositeContext);
        epr.setComponent(this.component);
        ComponentReference reference = assemblyFactory.createComponentReference();
        ExtensionPointRegistry registry = compositeContext.getExtensionPointRegistry();
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        JavaInterfaceFactory javaInterfaceFactory = (JavaInterfaceFactory)modelFactories.getFactory(JavaInterfaceFactory.class);
        JavaInterfaceContract interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
        try {
            interfaceContract.setInterface((Interface)javaInterfaceFactory.createJavaInterface(AsyncResponseService.class));
        }
        catch (InvalidInterfaceException e1) {
            // empty catch block
        }
        reference.setInterfaceContract((InterfaceContract)interfaceContract);
        String referenceName = endpoint.getService().getName() + "_asyncCallback";
        reference.setName(referenceName);
        reference.setForCallback(true);
        Reference implReference = assemblyFactory.createReference();
        implReference.setInterfaceContract((InterfaceContract)interfaceContract);
        implReference.setName(referenceName);
        implReference.setForCallback(true);
        reference.setReference(implReference);
        epr.setReference(reference);
        Binding binding = this.createMatchingBinding(endpoint.getBinding(), (RuntimeComponent)endpoint.getComponent(), reference, registry);
        epr.setBinding(binding);
        epr.getRequiredIntents().addAll(endpoint.getRequiredIntents());
        epr.getPolicySets().addAll(endpoint.getPolicySets());
        RuntimeEndpoint ep = (RuntimeEndpoint)assemblyFactory.createEndpoint();
        ep.setUnresolved(false);
        epr.setTargetEndpoint((Endpoint)ep);
        epr.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        epr.setUnresolved(false);
        String eprURI = endpoint.getComponent().getName() + "#reference-binding(" + referenceName + "/" + referenceName + ")";
        epr.setURI(eprURI);
        return epr;
    }

    private boolean asyncCallbackExists(RuntimeEndpoint endpoint) {
        return !endpoint.getCallbackEndpointReferences().isEmpty();
    }

    private Binding createMatchingBinding(Binding matchBinding, RuntimeComponent component, ComponentReference reference, ExtensionPointRegistry registry) {
        QName bindingName = matchBinding.getType();
        String bindingXML = "<ns1:" + bindingName.getLocalPart() + " xmlns:ns1='" + bindingName.getNamespaceURI() + "'/>";
        StAXArtifactProcessorExtensionPoint processors = (StAXArtifactProcessorExtensionPoint)registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        StAXArtifactProcessor processor = processors.getProcessor((Object)bindingName);
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        ValidatingXMLInputFactory inputFactory = (ValidatingXMLInputFactory)modelFactories.getFactory(ValidatingXMLInputFactory.class);
        StreamSource source = new StreamSource(new StringReader(bindingXML));
        ProcessorContext context = new ProcessorContext();
        try {
            XMLStreamReader reader = inputFactory.createXMLStreamReader((Source)source);
            reader.next();
            Binding newBinding = (Binding)processor.read(reader, context);
            newBinding.setName(reference.getName());
            BuilderExtensionPoint builders = (BuilderExtensionPoint)registry.getExtensionPoint(BuilderExtensionPoint.class);
            BindingBuilder builder = builders.getBindingBuilder(newBinding.getType());
            if (builder != null) {
                BuilderContext builderContext = new BuilderContext(registry);
                builder.build((Component)component, (Contract)reference, newBinding, builderContext, true);
            }
            return newBinding;
        }
        catch (ContributionReadException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return null;
    }

    private RuntimeAssemblyFactory getAssemblyFactory(CompositeContext compositeContext) {
        ExtensionPointRegistry registry = compositeContext.getExtensionPointRegistry();
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        return (RuntimeAssemblyFactory)((Object)modelFactories.getFactory(AssemblyFactory.class));
    }

    public void validateServiceInterfaceCompatibility() {
        InterfaceContract bindingContract;
        InterfaceContract serviceContract = this.getComponentServiceInterfaceContract();
        if (serviceContract != (bindingContract = this.getBindingInterfaceContract()) && serviceContract != null && bindingContract != null) {
            boolean bindingHasCallback = bindingContract.getCallbackInterface() != null;
            try {
                if (serviceContract.getClass() != bindingContract.getClass() || serviceContract.getNormalizedWSDLContract() != null || bindingContract.getNormalizedWSDLContract() != null) {
                    this.interfaceContractMapper.checkCompatibility(this.getGeneratedWSDLContract(serviceContract), this.getGeneratedWSDLContract(bindingContract), Compatibility.SUBSET, !bindingHasCallback, false);
                } else {
                    this.interfaceContractMapper.checkCompatibility(serviceContract, bindingContract, Compatibility.SUBSET, !bindingHasCallback, false);
                }
            }
            catch (Exception ex) {
                throw new ServiceRuntimeException("Component " + this.getComponent().getName() + " Service " + this.getService().getName() + " interface is incompatible with the interface of the service binding  - " + this.getBinding().getName() + " - " + ex.getMessage() + " - [" + this.toString() + "]");
            }
        }
    }

    private void initServiceBindingInvocationChains() {
        List<PolicyProvider> pps;
        ServiceBindingProvider provider = this.getBindingProvider();
        if (provider != null && provider instanceof EndpointProvider) {
            ((EndpointProvider)provider).configure();
        }
        if ((pps = this.getPolicyProviders()) != null) {
            for (PolicyProvider p : pps) {
                PhasedInterceptor interceptor = p.createBindingInterceptor();
                if (interceptor == null) continue;
                this.bindingInvocationChain.addInterceptor((Interceptor)interceptor);
            }
        }
        ServiceBindingProvider serviceBindingProvider = this.getBindingProvider();
        if (this.isAsyncInvocation() && serviceBindingProvider instanceof EndpointAsyncProvider && ((EndpointAsyncProvider)serviceBindingProvider).supportsNativeAsync()) {
            for (InvocationChain chain : this.getInvocationChains()) {
                Invoker invoker = chain.getHeadInvoker();
                ((InterceptorAsync)invoker).setPrevious((InvokerAsyncResponse)this.bindingInvocationChain.getTailInvoker());
            }
            EndpointAsyncProvider asyncEndpointProvider = (EndpointAsyncProvider)serviceBindingProvider;
            InvokerAsyncResponse asyncResponseInvoker = asyncEndpointProvider.createAsyncResponseInvoker();
            ((InterceptorAsync)this.bindingInvocationChain.getHeadInvoker()).setPrevious(asyncResponseInvoker);
        }
        this.bindingInvocationChain.addInvoker((Invoker)this.invoker);
    }

    private void addServiceBindingInterceptor(InvocationChain chain, Operation operation) {
        List<PolicyProvider> pps = this.getPolicyProviders();
        if (pps != null) {
            for (PolicyProvider p : pps) {
                PhasedInterceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor((Interceptor)interceptor);
            }
        }
    }

    private void addNonBlockingInterceptor(InvocationChain chain) {
        ServiceBindingProvider provider = this.getBindingProvider();
        if (provider != null && !provider.supportsOneWayInvocation()) {
            chain.addInterceptor("component.service", (Interceptor)new NonBlockingInterceptor(this.workScheduler));
        }
    }

    private void addImplementationInterceptor(Component component, ComponentService service, InvocationChain chain, Operation operation) {
        List pps;
        ImplementationProvider provider;
        if (service.getService() instanceof CompositeService) {
            CompositeService compositeService = (CompositeService)service.getService();
            component = this.getPromotedComponent(compositeService);
            service = this.getPromotedComponentService(compositeService);
        }
        if ((provider = ((RuntimeComponent)component).getImplementationProvider()) != null) {
            Invoker invoker = null;
            RuntimeComponentService runtimeService = (RuntimeComponentService)service;
            invoker = runtimeService.getName().endsWith("_asyncCallback") ? (provider instanceof ImplementationAsyncProvider ? (Invoker)((ImplementationAsyncProvider)provider).createAsyncResponseInvoker(operation) : provider.createInvoker((RuntimeComponentService)service, operation)) : (this.isAsyncInvocation() && provider instanceof ImplementationAsyncProvider ? (Invoker)((ImplementationAsyncProvider)provider).createAsyncInvoker((RuntimeComponentService)service, operation) : provider.createInvoker((RuntimeComponentService)service, operation));
            chain.addInvoker(invoker);
        }
        if ((pps = ((RuntimeComponent)component).getPolicyProviders()) != null) {
            for (PolicyProvider p : pps) {
                PhasedInterceptor interceptor = p.createInterceptor(operation);
                if (interceptor == null) continue;
                chain.addInterceptor((Interceptor)interceptor);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RuntimeEndpointImpl copy = (RuntimeEndpointImpl)super.clone();
        copy.invoker = new RuntimeInvoker(this.registry, (Invocable)copy);
        return copy;
    }

    public ComponentService getPromotedComponentService(CompositeService compositeService) {
        ComponentService componentService = compositeService.getPromotedService();
        if (componentService != null) {
            Service service = componentService.getService();
            if (componentService.getName() != null && service instanceof CompositeService) {
                return this.getPromotedComponentService((CompositeService)service);
            }
            return componentService;
        }
        return null;
    }

    public Component getPromotedComponent(CompositeService compositeService) {
        ComponentService componentService = compositeService.getPromotedService();
        if (componentService != null) {
            Service service = componentService.getService();
            if (componentService.getName() != null && service instanceof CompositeService) {
                return this.getPromotedComponent((CompositeService)service);
            }
            return compositeService.getPromotedComponent();
        }
        return null;
    }

    public synchronized ServiceBindingProvider getBindingProvider() {
        this.resolve();
        if (this.bindingProvider == null) {
            BindingProviderFactory factory = (BindingProviderFactory)this.providerFactories.getProviderFactory(this.getBinding().getClass());
            if (factory == null) {
                throw new ServiceRuntimeException("No provider factory is registered for binding " + this.getBinding().getType());
            }
            this.bindingProvider = factory.createServiceBindingProvider((RuntimeEndpoint)this);
        }
        return this.bindingProvider;
    }

    public synchronized List<PolicyProvider> getPolicyProviders() {
        this.resolve();
        if (this.policyProviders == null) {
            this.policyProviders = new ArrayList<PolicyProvider>();
            for (PolicyProviderFactory factory : this.providerFactories.getPolicyProviderFactories()) {
                PolicyProvider provider = factory.createServicePolicyProvider((Endpoint)this);
                if (provider == null) continue;
                this.policyProviders.add(provider);
            }
        }
        return this.policyProviders;
    }

    public void setBindingProvider(ServiceBindingProvider provider) {
        this.bindingProvider = provider;
    }

    public Contract getContract() {
        return this.getService();
    }

    public CompositeContext getCompositeContext() {
        return this.compositeContext;
    }

    protected void reset() {
        super.reset();
        this.xml = null;
    }

    protected synchronized void resolve() {
        if (this.xml != null && this.component == null) {
            if (this.compositeContext == null || this.compositeContext.getSystemDefinitions() == null) {
                this.compositeContext = CompositeContext.getCurrentCompositeContext();
                if (this.compositeContext != null) {
                    this.bind(this.compositeContext);
                }
            }
            if (this.serializer != null) {
                RuntimeEndpointImpl ep = (RuntimeEndpointImpl)this.serializer.readEndpoint(this.xml);
                this.copyFrom(ep);
                this.serializer.resolveEndpoint((Endpoint)this);
            } else {
                ExtensionPointRegistry registry = ExtensionPointRegistryLocator.getExtensionPointRegistry();
                if (registry != null) {
                    this.registry = registry;
                    UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
                    this.interfaceContractMapper = (InterfaceContractMapper)utilities.getUtility(InterfaceContractMapper.class);
                    this.serializer = (EndpointSerializer)utilities.getUtility(EndpointSerializer.class);
                    RuntimeEndpointImpl ep = (RuntimeEndpointImpl)this.serializer.readEndpoint(this.xml);
                    if ((ep = this.findActualEP(ep, registry)) != null) {
                        this.copyFrom(ep);
                    }
                }
            }
            this.setNormalizedWSDLContract();
        }
        super.resolve();
    }

    private RuntimeEndpointImpl findActualEP(RuntimeEndpointImpl ep, ExtensionPointRegistry registry) {
        DomainRegistry domainRegistry = this.getEndpointRegistry(registry);
        if (domainRegistry == null) {
            return null;
        }
        Iterator i$ = domainRegistry.findEndpoint(ep.getURI()).iterator();
        if (i$.hasNext()) {
            Endpoint endpoint = (Endpoint)i$.next();
            return (RuntimeEndpointImpl)endpoint;
        }
        return null;
    }

    private DomainRegistry getEndpointRegistry(ExtensionPointRegistry registry) {
        ExtensibleDomainRegistryFactory domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance((ExtensionPointRegistry)registry);
        if (domainRegistryFactory == null) {
            return null;
        }
        DomainRegistry domainRegistry = (DomainRegistry)domainRegistryFactory.getEndpointRegistries().toArray()[0];
        return domainRegistry;
    }

    public InterfaceContract getBindingInterfaceContract() {
        this.resolve();
        if (this.bindingInterfaceContract != null) {
            return this.bindingInterfaceContract;
        }
        this.bindingInterfaceContract = this.getBindingProvider().getBindingInterfaceContract();
        if (this.bindingInterfaceContract == null) {
            this.bindingInterfaceContract = this.getComponentServiceInterfaceContract();
        }
        if (this.bindingInterfaceContract == null) {
            this.bindingInterfaceContract = this.getComponentTypeServiceInterfaceContract();
        }
        return this.bindingInterfaceContract;
    }

    public InterfaceContract getComponentTypeServiceInterfaceContract() {
        this.resolve();
        if (this.serviceInterfaceContract != null) {
            return this.serviceInterfaceContract;
        }
        if (this.service == null) {
            return this.getComponentServiceInterfaceContract();
        }
        this.serviceInterfaceContract = this.getLeafContract((Contract)this.service).getInterfaceContract();
        if (this.serviceInterfaceContract == null) {
            this.serviceInterfaceContract = this.getComponentServiceInterfaceContract();
        }
        return this.serviceInterfaceContract;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uri = in.readUTF();
        this.xml = in.readUTF();
        this.interfaceContractXML = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getURI());
        if (this.serializer == null && this.xml != null) {
            out.writeUTF(this.xml);
        } else if (this.serializer != null) {
            out.writeUTF(this.serializer.write((Endpoint)this));
        } else {
            throw new IllegalStateException("No serializer is configured");
        }
        if (this.interfaceContractXML == null) {
            this.interfaceContractXML = this.getXMLFromTuscanyInterfaceContract();
        }
        out.writeUTF(this.interfaceContractXML);
    }

    public String getAsXML() {
        if (this.xml == null) {
            this.xml = this.serializer.write((Endpoint)this);
        }
        return this.xml;
    }

    private String getXMLFromTuscanyInterfaceContract() throws IOException {
        String interfaceContract = null;
        try {
            InterfaceContractProcessor processor = new InterfaceContractProcessor(this.registry);
            ProcessorContext context = new ProcessorContext();
            FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLOutputFactory outputFactory = (XMLOutputFactory)modelFactories.getFactory(XMLOutputFactory.class);
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(bos);
            processor.write(this.getComponentServiceInterfaceContract(), writer, context);
            writer.close();
            interfaceContract = bos.toString();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return interfaceContract;
    }

    private InterfaceContract getTuscanyInterfaceContractFromXML() {
        InterfaceContract interfaceContract = null;
        if (this.interfaceContractXML != null && this.interfaceContractXML.length() > 0) {
            try {
                FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
                InterfaceContractProcessor processor = new InterfaceContractProcessor(this.registry);
                ProcessorContext context = new ProcessorContext();
                ByteArrayInputStream bis = new ByteArrayInputStream(this.interfaceContractXML.getBytes());
                XMLInputFactory inputFactory = (XMLInputFactory)modelFactories.getFactory(XMLInputFactory.class);
                XMLStreamReader reader = inputFactory.createXMLStreamReader(bis);
                interfaceContract = processor.read(reader, context);
            }
            catch (Exception ex) {
                new ServiceRuntimeException((Throwable)ex);
            }
        }
        return interfaceContract;
    }

    private String getWsdl() {
        InterfaceContract ic = this.getComponentServiceInterfaceContract();
        if (ic == null || ic.getInterface() == null || !ic.getInterface().isRemotable()) {
            return "";
        }
        WSDLInterfaceContract wsdlIC = null;
        try {
            wsdlIC = (WSDLInterfaceContract)this.getGeneratedWSDLContract(ic);
        }
        catch (Exception ex) {
            return "";
        }
        if (wsdlIC == null) {
            return "";
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            WSDLInterface wsdl = (WSDLInterface)wsdlIC.getInterface();
            WSDLDefinition wsdlDefinition = wsdl.getWsdlDefinition();
            this.writeWSDL(outStream, wsdlDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String wsdlString = outStream.toString();
        return wsdlString;
    }

    private String getWsdlCallback() {
        InterfaceContract ic = this.getComponentServiceInterfaceContract();
        if (ic == null || ic.getCallbackInterface() == null || !ic.getCallbackInterface().isRemotable()) {
            return "";
        }
        WSDLInterfaceContract wsdlIC = null;
        try {
            wsdlIC = (WSDLInterfaceContract)this.getGeneratedWSDLContract(ic);
        }
        catch (Exception ex) {
            return "";
        }
        if (wsdlIC == null) {
            return "";
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            WSDLInterface wsdl = (WSDLInterface)wsdlIC.getCallbackInterface();
            WSDLDefinition wsdlDefinition = wsdl.getWsdlDefinition();
            this.writeWSDL(outStream, wsdlDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String wsdlString = outStream.toString();
        return wsdlString;
    }

    private void writeWSDL(OutputStream outStream, WSDLDefinition wsdlDefinition) throws IOException, WSDLException {
        Definition definition = wsdlDefinition.getDefinition();
        WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
        String baseURI = null;
        baseURI = wsdlDefinition.getLocation() != null ? wsdlDefinition.getLocation().toString() : "generated.wsdl";
        outStream.write(baseURI.getBytes());
        outStream.write(separator);
        writer.writeWSDL(definition, outStream);
        for (WSDLDefinition importedWSDLDefintion : wsdlDefinition.getImportedDefinitions()) {
            outStream.write(separator);
            baseURI = importedWSDLDefintion.getLocation().toString();
            outStream.write(baseURI.getBytes());
            outStream.write(separator);
            writer.writeWSDL(importedWSDLDefintion.getDefinition(), outStream);
        }
    }

    private void writeSchema(OutputStream outStream, XmlSchema schema) throws IOException {
        if (schema != null && schema.getNamespaceContext() != null) {
            outStream.write(separator);
            String baseURI = schema.getSourceURI();
            outStream.write(baseURI.getBytes());
            outStream.write(separator);
            schema.write(outStream);
            Iterator i = schema.getIncludes().getIterator();
            while (i.hasNext()) {
                XmlSchemaObject obj = (XmlSchemaObject)i.next();
                XmlSchema ext = null;
                if (obj instanceof XmlSchemaInclude) {
                    ext = ((XmlSchemaInclude)obj).getSchema();
                }
                if (obj instanceof XmlSchemaImport) {
                    ext = ((XmlSchemaImport)obj).getSchema();
                }
                this.writeSchema(outStream, ext);
            }
        }
    }

    private void setNormalizedWSDLContract() {
        if (this.interfaceContractXML == null || this.interfaceContractXML.length() < 1) {
            return;
        }
        InterfaceContract ic = this.getComponentServiceInterfaceContract();
        if (ic != null) {
            ic.setNormalizedWSDLContract(this.getTuscanyInterfaceContractFromXML());
        }
    }

    public InterfaceContract getGeneratedWSDLContract(InterfaceContract interfaceContract) {
        if (interfaceContract.getNormalizedWSDLContract() == null && this.getComponentServiceInterfaceContract() instanceof JavaInterfaceContract) {
            if (this.contractBuilder == null) {
                throw new ServiceRuntimeException("Contract builder not found while calculating WSDL contract for " + this.toString());
            }
            this.contractBuilder.build(interfaceContract, null);
        }
        return interfaceContract.getNormalizedWSDLContract();
    }

    public RuntimeEndpoint getDelegateEndpoint() {
        return this.delegateEndpoint;
    }

    public void setDelegateEndpoint(RuntimeEndpoint delegateEndpoint) {
        this.delegateEndpoint = delegateEndpoint;
    }
}

