/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.runtime.BaseDomainRegistry;
import org.apache.tuscany.sca.runtime.ContributionDescription;
import org.apache.tuscany.sca.runtime.ContributionListener;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.RuntimeProperties;

public class DomainRegistryImpl
extends BaseDomainRegistry
implements DomainRegistry,
LifeCycleListener {
    private final Logger logger = Logger.getLogger(DomainRegistryImpl.class.getName());
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private Map<String, Map<String, Composite>> runningComposites = new HashMap<String, Map<String, Composite>>();
    private Map<String, ContributionDescription> contributionDescriptions = new HashMap<String, ContributionDescription>();
    protected boolean quietLogging;
    private static final String LOCAL_MEMBER_NAME = "LocalOnly";

    public DomainRegistryImpl(ExtensionPointRegistry extensionPoints, String endpointRegistryURI, String domainURI) {
        super(extensionPoints, null, endpointRegistryURI, domainURI);
        Properties runtimeProps = ((RuntimeProperties)((UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(RuntimeProperties.class)).getProperties();
        this.quietLogging = Boolean.parseBoolean(runtimeProps.getProperty("org.apache.tuscany.sca.quietLogging"));
    }

    public synchronized void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointAdded(endpoint);
        }
        if (this.logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            String uri = null;
            Binding b = endpoint.getBinding();
            if (b != null && (uri = b.getURI()) != null && uri.startsWith("/")) {
                uri = uri.substring(1);
            }
            String msg = "Add endpoint - " + (uri == null ? endpoint.getURI() : b.getType().getLocalPart() + " - " + uri);
            if (this.quietLogging) {
                this.logger.fine(msg);
            } else {
                this.logger.info(msg);
            }
        }
    }

    public List<Endpoint> findEndpoint(String uri) {
        ArrayList<Endpoint> foundEndpoints = new ArrayList<Endpoint>();
        for (Endpoint endpoint : this.endpoints) {
            if (!endpoint.matches(uri)) continue;
            foundEndpoints.add(endpoint);
            this.logger.fine("Found endpoint with matching service  - " + endpoint);
        }
        return foundEndpoints;
    }

    public synchronized void removeEndpoint(Endpoint endpoint) {
        this.endpoints.remove(endpoint);
        this.endpointRemoved(endpoint);
        if (this.logger.isLoggable(this.quietLogging ? Level.FINE : Level.INFO)) {
            String uri = null;
            Binding b = endpoint.getBinding();
            if (b != null && (uri = b.getURI()) != null && uri.startsWith("/")) {
                uri = uri.substring(1);
            }
            String msg = "Remove endpoint - " + (uri == null ? endpoint.getURI() : b.getType().getLocalPart() + " - " + uri);
            if (this.quietLogging) {
                this.logger.fine(msg);
            } else {
                this.logger.info(msg);
            }
        }
    }

    public synchronized List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public synchronized Endpoint getEndpoint(String uri) {
        for (Endpoint ep : this.endpoints) {
            String epURI = ep.getComponent().getURI() + "#" + ep.getService().getName() + "/" + ep.getBinding().getName();
            if (epURI.equals(uri)) {
                return ep;
            }
            if (ep.getBinding().getName() != null && !ep.getBinding().getName().equals(ep.getService().getName()) || !(epURI = ep.getComponent().getURI() + "#" + ep.getService().getName()).equals(uri)) continue;
            return ep;
        }
        return null;
    }

    public synchronized void updateEndpoint(String uri, Endpoint endpoint) {
        Endpoint oldEndpoint = this.getEndpoint(uri);
        if (oldEndpoint == null) {
            throw new IllegalArgumentException("Endpoint is not found: " + uri);
        }
        this.endpoints.remove(oldEndpoint);
        this.endpoints.add(endpoint);
        for (EndpointListener listener : this.listeners) {
            listener.endpointUpdated(oldEndpoint, endpoint);
        }
    }

    public synchronized void start() {
    }

    public synchronized void stop() {
        Iterator<Endpoint> i = this.endpoints.iterator();
        while (i.hasNext()) {
            Endpoint ep = i.next();
            i.remove();
            this.endpointRemoved(ep);
        }
        this.endpointreferences.clear();
        this.listeners.clear();
    }

    public void addRunningComposite(String curi, Composite composite) {
        Map<String, Composite> cs = this.runningComposites.get(curi);
        if (cs == null) {
            cs = new HashMap<String, Composite>();
            this.runningComposites.put(curi, cs);
        }
        cs.put(composite.getURI(), composite);
    }

    public void removeRunningComposite(String curi, String compositeURI) {
        Map<String, Composite> cs = this.runningComposites.get(curi);
        if (cs != null) {
            cs.remove(compositeURI);
        }
    }

    public Composite getRunningComposite(String curi, String compositeURI) {
        Map<String, Composite> cs = this.runningComposites.get(curi);
        if (cs != null) {
            return cs.get(compositeURI);
        }
        return null;
    }

    public Map<String, List<String>> getRunningCompositeURIs() {
        HashMap<String, List<String>> compositeURIs = new HashMap<String, List<String>>();
        for (String curi : this.runningComposites.keySet()) {
            if (this.runningComposites.get(curi).size() <= 0) continue;
            ArrayList<String> uris = new ArrayList<String>();
            compositeURIs.put(curi, uris);
            for (String uri : this.runningComposites.get(curi).keySet()) {
                uris.add(uri);
            }
        }
        return compositeURIs;
    }

    public void installContribution(ContributionDescription cd) {
        this.contributionDescriptions.put(cd.getURI(), cd);
        for (ContributionListener listener : this.contributionlisteners) {
            listener.contributionInstalled(cd.getURI());
        }
    }

    public void uninstallContribution(String uri) {
        ListIterator listenerIterator = this.contributionlisteners.listIterator(this.contributionlisteners.size());
        while (listenerIterator.hasPrevious()) {
            ContributionListener listener = (ContributionListener)listenerIterator.previous();
            listener.contributionRemoved(uri);
        }
        this.contributionDescriptions.remove(uri);
    }

    public List<String> getInstalledContributionURIs() {
        return new ArrayList<String>(this.contributionDescriptions.keySet());
    }

    public ContributionDescription getInstalledContribution(String uri) {
        return this.contributionDescriptions.get(uri);
    }

    public void updateInstalledContribution(ContributionDescription cd) {
        this.contributionDescriptions.put(cd.getURI(), cd);
        for (ContributionListener listener : this.contributionlisteners) {
            listener.contributionUpdated(cd.getURI());
        }
    }

    public List<String> getNodeNames() {
        return Arrays.asList(LOCAL_MEMBER_NAME);
    }

    public String getLocalNodeName() {
        return LOCAL_MEMBER_NAME;
    }

    public String getRunningNodeName(String contributionURI, String compositeURI) {
        if (this.getRunningComposite(contributionURI, compositeURI) != null) {
            return LOCAL_MEMBER_NAME;
        }
        return null;
    }

    public String remoteCommand(String memberName, Callable<String> command) {
        throw new IllegalStateException("not supportted for LocalOnly");
    }

    public String getContainingCompositesContributionURI(String componentName) {
        for (Map<String, Composite> cs : this.runningComposites.values()) {
            for (Composite c : cs.values()) {
                if (c.getComponent(componentName) == null) continue;
                return c.getContributionURI();
            }
        }
        return null;
    }

    public boolean isDistributed() {
        return false;
    }
}

