/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.work;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.rmi.server.UID;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.apache.tuscany.sca.core.work.WorkEventImpl;
import org.apache.tuscany.sca.core.work.WorkItemImpl;
import org.osoa.sca.annotations.Destroy;

public class ThreadPoolWorkManager
implements WorkManager {
    private Map<WorkItemImpl, WorkListener> workItems = new ConcurrentHashMap<WorkItemImpl, WorkListener>();
    private ExecutorService executor;

    public ThreadPoolWorkManager(int threadPoolSize) {
        if (threadPoolSize < 1) {
            throw new IllegalArgumentException("Invalid threadPoolSize of " + threadPoolSize + ". It must be >= 1");
        }
        this.executor = Executors.newFixedThreadPool(threadPoolSize, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public WorkItem schedule(Work work) throws IllegalArgumentException {
        return this.schedule(work, null);
    }

    public WorkItem schedule(Work work, WorkListener workListener) throws IllegalArgumentException {
        WorkItemImpl workItem = new WorkItemImpl(new UID().toString(), work);
        if (workListener != null) {
            this.workItems.put(workItem, workListener);
        }
        this.workAccepted(workItem, work);
        if (this.scheduleWork(work, workItem)) {
            return workItem;
        }
        workItem.setStatus(2);
        if (workListener != null) {
            workListener.workRejected((WorkEvent)new WorkEventImpl(workItem));
        }
        throw new IllegalArgumentException("Unable to schedule work");
    }

    public boolean waitForAll(Collection works, long timeout) {
        throw new UnsupportedOperationException("waitForAll not supported");
    }

    public Collection waitForAny(Collection works, long timeout) {
        throw new UnsupportedOperationException("waitForAny not supported");
    }

    private void workAccepted(WorkItemImpl workItem, Work work) {
        WorkListener listener = this.workItems.get(workItem);
        if (listener != null) {
            workItem.setStatus(1);
            WorkEventImpl event = new WorkEventImpl(workItem);
            listener.workAccepted((WorkEvent)event);
        }
    }

    private void workStarted(WorkItemImpl workItem, Work work) {
        WorkListener listener = this.workItems.get(workItem);
        if (listener != null) {
            workItem.setStatus(3);
            WorkEventImpl event = new WorkEventImpl(workItem);
            listener.workStarted((WorkEvent)event);
        }
    }

    private void workCompleted(WorkItemImpl workItem, Work work) {
        this.workCompleted(workItem, work, null);
    }

    private void workCompleted(WorkItemImpl workItem, Work work, WorkException exception) {
        WorkListener listener = this.workItems.get(workItem);
        if (listener != null) {
            workItem.setStatus(4);
            workItem.setResult(work);
            workItem.setException(exception);
            WorkEventImpl event = new WorkEventImpl(workItem);
            listener.workCompleted((WorkEvent)event);
            this.workItems.remove(workItem);
        }
    }

    private boolean scheduleWork(Work work, WorkItemImpl workItem) {
        try {
            this.executor.execute(new DecoratingWork(workItem, work));
            return true;
        }
        catch (RejectedExecutionException ex) {
            return false;
        }
    }

    @Destroy
    public void destroy() {
        this.executor.shutdown();
    }

    private final class DecoratingWork
    implements Runnable {
        private WorkItemImpl workItem;
        private Work decoratedWork;

        private DecoratingWork(WorkItemImpl workItem, Work decoratedWork) {
            this.workItem = workItem;
            this.decoratedWork = decoratedWork;
        }

        public void run() {
            ThreadPoolWorkManager.this.workStarted(this.workItem, this.decoratedWork);
            try {
                this.decoratedWork.run();
                ThreadPoolWorkManager.this.workCompleted(this.workItem, this.decoratedWork);
            }
            catch (Throwable th) {
                ThreadPoolWorkManager.this.workCompleted(this.workItem, this.decoratedWork, new WorkException(th.getMessage(), th));
            }
        }
    }
}

