/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.work;

import commonj.work.WorkEvent;
import commonj.work.WorkException;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.tuscany.sca.core.work.Jsr237Work;
import org.apache.tuscany.sca.core.work.ThreadPoolWorkManager;
import org.apache.tuscany.sca.work.NotificationListener;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.apache.tuscany.sca.work.WorkSchedulerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr237WorkScheduler
implements WorkScheduler {
    private WorkManager jsr237WorkManager;

    public Jsr237WorkScheduler() {
        try {
            InitialContext ctx = new InitialContext();
            this.jsr237WorkManager = (WorkManager)ctx.lookup("java:comp/env/wm/TuscanyWorkManager");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (this.jsr237WorkManager == null) {
            this.jsr237WorkManager = new ThreadPoolWorkManager(10);
        }
    }

    public <T extends Runnable> void scheduleWork(T work) {
        this.scheduleWork(work, null);
    }

    public <T extends Runnable> void scheduleWork(T work, NotificationListener<T> listener) {
        if (work == null) {
            throw new IllegalArgumentException("Work cannot be null");
        }
        Jsr237Work<T> jsr237Work = new Jsr237Work<T>(work);
        try {
            if (listener == null) {
                this.jsr237WorkManager.schedule(jsr237Work);
            } else {
                Jsr237WorkListener jsr237WorkListener = new Jsr237WorkListener(this, listener, work);
                this.jsr237WorkManager.schedule(jsr237Work, (WorkListener)jsr237WorkListener);
            }
        }
        catch (IllegalArgumentException ex) {
            if (listener != null) {
                listener.workRejected(work);
            }
            throw new WorkSchedulerException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new WorkSchedulerException((Throwable)ex);
        }
    }

    public void destroy() {
        if (this.jsr237WorkManager instanceof ThreadPoolWorkManager) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ((ThreadPoolWorkManager)Jsr237WorkScheduler.this.jsr237WorkManager).destroy();
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jsr237WorkListener<T extends Runnable>
    implements WorkListener {
        private NotificationListener<T> listener;
        private T work;
        final /* synthetic */ Jsr237WorkScheduler this$0;

        public Jsr237WorkListener(NotificationListener<T> listener, T work) {
            this.this$0 = var1_1;
            this.listener = listener;
            this.work = work;
        }

        public void workAccepted(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workAccepted(work);
        }

        public void workRejected(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workRejected(work);
        }

        public void workStarted(WorkEvent workEvent) {
            T work = this.getWork();
            this.listener.workStarted(work);
        }

        public void workCompleted(WorkEvent workEvent) {
            T work = this.getWork();
            WorkException exception = workEvent.getException();
            if (exception != null) {
                this.listener.workFailed(work, (Throwable)exception);
            } else {
                this.listener.workCompleted(work);
            }
        }

        private T getWork() {
            return this.work;
        }
    }
}

