/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.scope;

import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.event.HttpSessionEnd;
import org.apache.tuscany.sca.core.scope.AbstractScopeContainer;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.event.Event;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionScopeContainer
extends AbstractScopeContainer<Object> {
    public HttpSessionScopeContainer(RuntimeComponent component) {
        super(Scope.SESSION, component);
    }

    @Override
    public void onEvent(Event event) {
        this.checkInit();
        if (event instanceof HttpSessionEnd) {
            // empty if block
        }
    }

    @Override
    public synchronized void start() {
        if (this.lifecycleState != 0 && this.lifecycleState != 6) {
            throw new IllegalStateException("Scope must be in UNINITIALIZED or STOPPED state [" + this.lifecycleState + "]");
        }
        this.lifecycleState = 4;
    }

    @Override
    public synchronized void stop() {
        this.lifecycleState = 6;
    }

    protected InstanceWrapper getInstanceWrapper(boolean create) throws TargetResolutionException {
        String key = "http-session-id";
        assert (key != null) : "HTTP session key not bound in work context";
        InstanceWrapper ctx = (InstanceWrapper)this.wrappers.get(key);
        if (ctx == null && !create) {
            return null;
        }
        if (ctx == null) {
            ctx = super.createInstanceWrapper();
            ctx.start();
            this.wrappers.put(key, ctx);
        }
        return ctx;
    }

    @Override
    public InstanceWrapper getWrapper(Object contextId) throws TargetResolutionException {
        return this.getInstanceWrapper(true);
    }
}

