/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.scope;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopedImplementationProvider;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.event.Event;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopeContainer<KEY>
implements ScopeContainer<KEY> {
    protected Map<KEY, InstanceWrapper<?>> wrappers = new ConcurrentHashMap();
    protected final Scope scope;
    protected RuntimeComponent component;
    protected volatile int lifecycleState = 0;

    public AbstractScopeContainer(Scope scope, RuntimeComponent component) {
        this.scope = scope;
        this.component = component;
    }

    protected void checkInit() {
        if (this.getLifecycleState() != 4) {
            throw new IllegalStateException("Scope container not running [" + this.getLifecycleState() + "]");
        }
    }

    protected InstanceWrapper createInstanceWrapper() throws TargetResolutionException {
        ImplementationProvider implementationProvider = this.component.getImplementationProvider();
        if (implementationProvider instanceof ScopedImplementationProvider) {
            return ((ScopedImplementationProvider)implementationProvider).createInstanceWrapper();
        }
        return null;
    }

    @Override
    public InstanceWrapper getAssociatedWrapper(KEY contextId) throws TargetResolutionException {
        return this.getWrapper(contextId);
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public InstanceWrapper getWrapper(KEY contextId) throws TargetResolutionException {
        return this.wrappers.get(contextId);
    }

    @Override
    public void addWrapperReference(KEY existingContextId, KEY newContextId) throws TargetResolutionException {
    }

    @Override
    public void registerWrapper(InstanceWrapper wrapper, KEY contextId) throws TargetResolutionException {
    }

    public void onEvent(Event event) {
    }

    protected boolean isEagerInit() {
        ImplementationProvider implementationProvider = this.component.getImplementationProvider();
        if (implementationProvider instanceof ScopedImplementationProvider) {
            return ((ScopedImplementationProvider)implementationProvider).isEagerInit();
        }
        return false;
    }

    @Override
    public void returnWrapper(InstanceWrapper wrapper, KEY contextId) throws TargetDestructionException {
    }

    @Override
    public void remove(KEY contextId) throws TargetDestructionException {
    }

    @Override
    public synchronized void start() {
        int lifecycleState = this.getLifecycleState();
        if (lifecycleState != 0 && lifecycleState != 6) {
            throw new IllegalStateException("Scope must be in UNINITIALIZED or STOPPED state [" + lifecycleState + "]");
        }
        this.setLifecycleState(4);
    }

    @Override
    public void startContext(KEY contextId) {
        if (this.isEagerInit()) {
            try {
                this.getWrapper(contextId);
            }
            catch (TargetResolutionException targetResolutionException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void stop() {
        int lifecycleState = this.getLifecycleState();
        if (lifecycleState != 4) {
            throw new IllegalStateException("Scope in wrong state [" + lifecycleState + "]");
        }
        this.setLifecycleState(6);
    }

    @Override
    public void stopContext(KEY contextId) {
        this.wrappers.remove(contextId);
    }

    public String toString() {
        String s;
        switch (this.lifecycleState) {
            case -1: {
                s = "CONFIG_ERROR";
                break;
            }
            case 7: {
                s = "ERROR";
                break;
            }
            case 1: {
                s = "INITIALIZING";
                break;
            }
            case 2: {
                s = "INITIALIZED";
                break;
            }
            case 4: {
                s = "RUNNING";
                break;
            }
            case 5: {
                s = "STOPPING";
                break;
            }
            case 6: {
                s = "STOPPED";
                break;
            }
            case 0: {
                s = "UNINITIALIZED";
                break;
            }
            default: {
                s = "UNKNOWN";
            }
        }
        return "In state [" + s + ']';
    }

    public RuntimeComponent getComponent() {
        return this.component;
    }

    public void setComponent(RuntimeComponent component) {
        this.component = component;
    }

    @Override
    public int getLifecycleState() {
        return this.lifecycleState;
    }

    protected void setLifecycleState(int lifecycleState) {
        this.lifecycleState = lifecycleState;
    }
}

