/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.tuscany.sca.core.assembly.RuntimeWireImpl;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.context.InstanceWrapper;
import org.apache.tuscany.sca.core.conversation.ConversationManager;
import org.apache.tuscany.sca.core.conversation.ConversationState;
import org.apache.tuscany.sca.core.conversation.ExtendedConversation;
import org.apache.tuscany.sca.core.invocation.ThreadMessageContext;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.core.scope.TargetResolutionException;
import org.apache.tuscany.sca.interfacedef.ConversationSequence;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.CallableReference;
import org.osoa.sca.ConversationEndedException;
import org.osoa.sca.ServiceReference;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -3366410500152201371L;
    protected boolean conversational;
    protected ExtendedConversation conversation;
    protected MessageFactory messageFactory;
    protected EndpointReference source;
    protected EndpointReference target;
    protected RuntimeWire wire;
    protected CallableReference<?> callableReference;
    protected Class<?> businessInterface;
    protected boolean fixedWire = true;
    protected transient Map<Method, InvocationChain> chains = new HashMap<Method, InvocationChain>();

    public JDKInvocationHandler(MessageFactory messageFactory, Class<?> businessInterface, RuntimeWire wire) {
        this.messageFactory = messageFactory;
        this.wire = wire;
        this.businessInterface = businessInterface;
        this.init(this.wire);
    }

    public JDKInvocationHandler(MessageFactory messageFactory, CallableReference<?> callableReference) {
        this.messageFactory = messageFactory;
        this.callableReference = callableReference;
        if (callableReference != null) {
            this.businessInterface = callableReference.getBusinessInterface();
            this.conversation = (ExtendedConversation)callableReference.getConversation();
            this.wire = ((CallableReferenceImpl)callableReference).getRuntimeWire();
            if (this.wire != null) {
                this.init(this.wire);
            }
        }
    }

    protected void init(RuntimeWire wire) {
        if (wire != null) {
            try {
                this.source = (EndpointReference)wire.getSource().clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
            this.initConversational(wire);
        }
    }

    protected void initConversational(RuntimeWire wire) {
        InterfaceContract contract = wire.getSource().getInterfaceContract();
        this.conversational = contract.getInterface().isConversational();
    }

    protected Object getCallbackID() {
        if (this.callableReference != null) {
            return this.callableReference.getCallbackID();
        }
        return null;
    }

    protected Object getConversationID() {
        if (this.callableReference != null && this.callableReference instanceof ServiceReference) {
            return ((ServiceReference)this.callableReference).getConversationID();
        }
        return null;
    }

    protected Object getCallbackObject() {
        if (this.callableReference != null && this.callableReference instanceof ServiceReference) {
            return ((ServiceReference)this.callableReference).getCallback();
        }
        return null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class == method.getDeclaringClass()) {
            return this.invokeObjectMethod(method, args);
        }
        if (this.wire == null) {
            throw new ServiceRuntimeException("No runtime wire is available");
        }
        InvocationChain chain = this.getInvocationChain(method, this.wire);
        if (chain == null) {
            throw new IllegalArgumentException("No matching operation is found: " + method);
        }
        Object result = this.invoke(chain, args, this.wire, this.source);
        return result;
    }

    protected Object invokeObjectMethod(Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("toString".equals(name)) {
            return "[Proxy - " + this.toString() + "]";
        }
        if ("equals".equals(name)) {
            Object obj = args[0];
            if (obj == null) {
                return false;
            }
            if (!Proxy.isProxyClass(obj.getClass())) {
                return false;
            }
            return this.equals(Proxy.getInvocationHandler(obj));
        }
        if ("hashCode".equals(name)) {
            return this.hashCode();
        }
        return method.invoke((Object)this, new Object[0]);
    }

    private static boolean match(Operation operation, Method method) {
        if (operation instanceof JavaOperation) {
            JavaOperation javaOp = (JavaOperation)operation;
            Method m = javaOp.getJavaMethod();
            if (!method.getName().equals(m.getName())) {
                return false;
            }
            if (method.equals(m)) {
                return true;
            }
        } else if (!method.getName().equals(operation.getName())) {
            return false;
        }
        if (operation.getInterface().isRemotable()) {
            return true;
        }
        Class<?>[] params = method.getParameterTypes();
        DataType inputType = null;
        inputType = operation.isWrapperStyle() ? operation.getWrapper().getUnwrappedInputType() : operation.getInputType();
        List types = (List)inputType.getLogical();
        boolean matched = true;
        if (types.size() == params.length && method.getName().equals(operation.getName())) {
            for (int i = 0; i < params.length; ++i) {
                Class<?> clazz = params[i];
                Class type = ((DataType)types.get(i)).getPhysical();
                if (type == Object.class || type.isAssignableFrom(clazz)) continue;
                matched = false;
            }
        } else {
            matched = false;
        }
        return matched;
    }

    protected synchronized InvocationChain getInvocationChain(Method method, RuntimeWire wire) {
        if (this.fixedWire && this.chains.containsKey(method)) {
            return this.chains.get(method);
        }
        InvocationChain found = null;
        for (InvocationChain chain : wire.getInvocationChains()) {
            Operation operation = chain.getSourceOperation();
            if (operation.isDynamic()) {
                operation.setName(method.getName());
                found = chain;
                break;
            }
            if (!JDKInvocationHandler.match(operation, method)) continue;
            found = chain;
            break;
        }
        if (this.fixedWire) {
            this.chains.put(method, found);
        }
        return found;
    }

    protected void setEndpoint(EndpointReference endpoint) {
        this.target = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(InvocationChain chain, Object[] args, RuntimeWire wire, EndpointReference source) throws Throwable {
        Message msg = this.messageFactory.createMessage();
        msg.setFrom(source);
        if (this.target != null) {
            msg.setTo(this.target);
        } else {
            msg.setTo(wire.getTarget());
        }
        Invoker headInvoker = chain.getHeadInvoker();
        Operation operation = chain.getTargetOperation();
        msg.setOperation(operation);
        msg.setBody((Object)args);
        Message msgContext = ThreadMessageContext.getMessageContext();
        Object currentConversationID = msgContext.getFrom().getReferenceParameters().getConversationID();
        this.conversationPreinvoke(msg, wire);
        this.handleCallback(msg, wire, currentConversationID);
        ThreadMessageContext.setMessageContext(msg);
        boolean abnormalEndConversation = false;
        try {
            Message resp = headInvoker.invoke(msg);
            Object body = resp.getBody();
            if (resp.isFault()) {
                if (currentConversationID != null) {
                    try {
                        boolean businessException = false;
                        for (DataType dataType : operation.getFaultTypes()) {
                            if (dataType.getPhysical() != ((Throwable)body).getClass()) continue;
                            businessException = true;
                            break;
                        }
                        if (!businessException) {
                            abnormalEndConversation = true;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw (Throwable)body;
            }
            Object object = body;
            return object;
        }
        finally {
            this.conversationPostInvoke(msg, wire, abnormalEndConversation);
            ThreadMessageContext.setMessageContext(msgContext);
        }
    }

    private void handleCallback(Message msg, RuntimeWire wire, Object currentConversationID) throws TargetResolutionException {
        ScopeContainer<Object> scopeContainer;
        ReferenceParameters parameters = msg.getFrom().getReferenceParameters();
        parameters.setCallbackID(this.getCallbackID());
        if (msg.getFrom() == null || msg.getFrom().getCallbackEndpoint() == null) {
            return;
        }
        parameters.setCallbackReference(msg.getFrom().getCallbackEndpoint());
        Object callbackObject = this.getCallbackObject();
        if (this.conversational && callbackObject == null && (scopeContainer = this.getConversationalScopeContainer(wire)) != null && currentConversationID != null) {
            scopeContainer.addWrapperReference(currentConversationID, this.conversation.getConversationID());
        }
        Interface interfaze = msg.getFrom().getCallbackEndpoint().getInterfaceContract().getInterface();
        if (callbackObject != null) {
            if (callbackObject instanceof ServiceReference) {
                EndpointReference callbackRef = ((CallableReferenceImpl)callbackObject).getEndpointReference();
                parameters.setCallbackReference(callbackRef);
            } else if (interfaze != null) {
                if (!interfaze.isConversational()) {
                    throw new IllegalArgumentException("Callback object for stateless callback is not a ServiceReference");
                }
                if (!(callbackObject instanceof Serializable)) {
                    throw new IllegalArgumentException("Callback object for stateful callback is not Serializable");
                }
                ScopeContainer<Object> scopeContainer2 = this.getConversationalScopeContainer(wire);
                if (scopeContainer2 != null) {
                    CallbackObjectWrapper wrapper = new CallbackObjectWrapper(callbackObject);
                    scopeContainer2.registerWrapper(wrapper, this.conversation.getConversationID());
                }
                parameters.setCallbackObjectID(callbackObject);
            }
        }
    }

    private void conversationPreinvoke(Message msg, RuntimeWire wire) {
        if (!this.conversational) {
            return;
        }
        ConversationManager conversationManager = ((RuntimeWireImpl)wire).getConversationManager();
        if (this.conversation == null || this.conversation.getState() == ConversationState.ENDED) {
            this.conversation = conversationManager.startConversation(this.getConversationID());
            if (wire.getTarget().getComponent() != null) {
                this.conversation.initializeConversationAttributes(wire.getTarget().getComponent());
            }
            if (this.callableReference != null) {
                ((CallableReferenceImpl)this.callableReference).attachConversation(this.conversation);
            }
        } else if (this.conversation.isExpired()) {
            throw new ConversationEndedException("Conversation " + this.conversation.getConversationID() + " has expired.");
        }
        if (wire.getTarget().getComponent() != null) {
            this.conversation.updateLastReferencedTime();
        }
        msg.getFrom().getReferenceParameters().setConversationID(this.conversation.getConversationID());
    }

    private void conversationPostInvoke(Message msg, RuntimeWire wire, boolean abnormalEndConversation) throws TargetDestructionException {
        Operation operation = msg.getOperation();
        ConversationSequence sequence = operation.getConversationSequence();
        if ((sequence == ConversationSequence.CONVERSATION_END || abnormalEndConversation) && this.conversation.getState() != ConversationState.ENDED) {
            ScopeContainer<Object> scopeContainer = this.getConversationalScopeContainer(wire);
            if (scopeContainer != null) {
                scopeContainer.remove(this.conversation.getConversationID());
            }
            this.conversation.end();
        }
    }

    private ScopeContainer<Object> getConversationalScopeContainer(RuntimeWire wire) {
        ScopedRuntimeComponent scopedRuntimeComponent;
        ScopeContainer tmpScopeContainer;
        ScopeContainer scopeContainer = null;
        RuntimeComponent runtimeComponent = wire.getSource().getComponent();
        if (runtimeComponent instanceof ScopedRuntimeComponent && (tmpScopeContainer = (scopedRuntimeComponent = (ScopedRuntimeComponent)runtimeComponent).getScopeContainer()) != null && tmpScopeContainer.getScope() == Scope.CONVERSATION) {
            scopeContainer = tmpScopeContainer;
        }
        return scopeContainer;
    }

    private Object createConversationID() {
        if (this.getConversationID() != null) {
            return this.getConversationID();
        }
        return UUID.randomUUID().toString();
    }

    public CallableReference<?> getCallableReference() {
        return this.callableReference;
    }

    public void setCallableReference(CallableReference<?> callableReference) {
        this.callableReference = callableReference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallbackObjectWrapper<T>
    implements InstanceWrapper<T> {
        private T instance;

        private CallbackObjectWrapper(T instance) {
            this.instance = instance;
        }

        @Override
        public T getInstance() {
            return this.instance;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }
    }
}

