/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.tuscany.sca.core.invocation.PhaseManager;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;

public class InvocationChainImpl
implements InvocationChain {
    private Operation sourceOperation;
    private Operation targetOperation;
    private List<Node> nodes = new ArrayList<Node>();
    private static final PhaseManager phaseManager = new PhaseManager();
    private boolean forReference;
    private boolean allowsPassByReference;

    public InvocationChainImpl(Operation sourceOperation, Operation targetOperation, boolean forReference) {
        assert (sourceOperation != null);
        assert (targetOperation != null);
        this.targetOperation = targetOperation;
        this.sourceOperation = sourceOperation;
        this.forReference = forReference;
    }

    public Operation getTargetOperation() {
        return this.targetOperation;
    }

    public void setTargetOperation(Operation operation) {
        this.targetOperation = operation;
    }

    public void addInterceptor(Interceptor interceptor) {
        String phase = this.forReference ? "component.reference" : "component.service";
        this.addInterceptor(phase, interceptor);
    }

    public void addInvoker(Invoker invoker) {
        String phase = this.forReference ? "reference.binding" : "component.implementation";
        this.addInvoker(phase, invoker);
    }

    public Invoker getHeadInvoker() {
        return this.nodes.isEmpty() ? null : this.nodes.get(0).getInvoker();
    }

    public Invoker getTailInvoker() {
        return this.nodes.isEmpty() ? null : this.nodes.get(this.nodes.size() - 1).getInvoker();
    }

    public Operation getSourceOperation() {
        return this.sourceOperation;
    }

    public void setSourceOperation(Operation sourceOperation) {
        this.sourceOperation = sourceOperation;
    }

    public void addInterceptor(int index, Interceptor interceptor) {
        this.addInterceptor(interceptor);
    }

    public void addInterceptor(String phase, Interceptor interceptor) {
        this.addInvoker(phase, (Invoker)interceptor);
    }

    private void addInvoker(String phase, Invoker invoker) {
        int index = phaseManager.getAllPhases().indexOf(phase);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid phase name: " + phase);
        }
        Node node = new Node(index, invoker);
        ListIterator<Node> li = this.nodes.listIterator();
        Node before = null;
        Node after = null;
        boolean found = false;
        while (li.hasNext()) {
            before = after;
            after = li.next();
            if (after.getPhaseIndex() <= index) continue;
            li.previous();
            li.add(node);
            found = true;
            break;
        }
        if (!found) {
            this.nodes.add(node);
            before = after;
            after = null;
        }
        if (before != null && before.getInvoker() instanceof Interceptor) {
            ((Interceptor)before.getInvoker()).setNext(invoker);
        }
        if (after != null && invoker instanceof Interceptor) {
            ((Interceptor)invoker).setNext(after.getInvoker());
        }
    }

    public boolean allowsPassByReference() {
        if (this.allowsPassByReference) {
            return true;
        }
        boolean allowsPBR = false;
        for (Node i : this.nodes) {
            if (!(i.getInvoker() instanceof DataExchangeSemantics) || !((DataExchangeSemantics)i.getInvoker()).allowsPassByReference()) continue;
            allowsPBR = true;
            break;
        }
        return allowsPBR;
    }

    public void setAllowsPassByReference(boolean allowsPBR) {
        this.allowsPassByReference = allowsPBR;
    }

    private static class Node {
        private int phaseIndex;
        private Invoker invoker;

        public Node(int phaseIndex, Invoker invoker) {
            this.phaseIndex = phaseIndex;
            this.invoker = invoker;
        }

        public int getPhaseIndex() {
            return this.phaseIndex;
        }

        public Invoker getInvoker() {
            return this.invoker;
        }

        public String toString() {
            return "(" + this.phaseIndex + ")" + this.invoker;
        }
    }
}

