/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.core.assembly.RuntimeComponentReferenceImpl;
import org.apache.tuscany.sca.core.assembly.RuntimeWireImpl;
import org.apache.tuscany.sca.core.context.CallableReferenceImpl;
import org.apache.tuscany.sca.core.context.ComponentContextHelper;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ThreadMessageContext;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackReferenceImpl<B>
extends CallableReferenceImpl<B> {
    private RuntimeWire wire;
    private List<RuntimeWire> wires;
    private EndpointReference resolvedEndpoint;
    private Object convID;

    public static CallbackReferenceImpl newInstance(Class interfaze, ProxyFactory proxyFactory, List<RuntimeWire> wires) {
        if (CallbackReferenceImpl.getCallbackEndpoint(ThreadMessageContext.getMessageContext()) != null) {
            return new CallbackReferenceImpl(interfaze, proxyFactory, wires);
        }
        return null;
    }

    public CallbackReferenceImpl() {
    }

    private CallbackReferenceImpl(Class<B> interfaze, ProxyFactory proxyFactory, List<RuntimeWire> wires) {
        super(interfaze, null, proxyFactory);
        this.wires = wires;
        this.init();
    }

    public void init() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        this.wire = this.selectCallbackWire(msgContext);
        if (this.wire == null) {
            throw new RuntimeException("No callback binding found for " + msgContext.getTo().getURI());
        }
        this.resolvedEndpoint = CallbackReferenceImpl.getCallbackEndpoint(msgContext);
        this.convID = msgContext.getFrom().getReferenceParameters().getConversationID();
        this.callbackID = msgContext.getFrom().getReferenceParameters().getCallbackID();
    }

    @Override
    protected Object createProxy() throws Exception {
        return this.proxyFactory.createCallbackProxy(this);
    }

    protected RuntimeWire getCallbackWire() {
        if (this.resolvedEndpoint == null) {
            return null;
        }
        return this.cloneAndBind(this.wire);
    }

    protected Object getConvID() {
        return this.convID;
    }

    protected EndpointReference getResolvedEndpoint() {
        return this.resolvedEndpoint;
    }

    private RuntimeWire selectCallbackWire(Message msgContext) {
        EndpointReference to = msgContext.getTo();
        if (to == null) {
            throw new RuntimeException("Destination for forward call is not available");
        }
        for (RuntimeWire wire : this.wires) {
            if (!wire.getSource().getBinding().getName().equals(to.getBinding().getName())) continue;
            return wire;
        }
        for (RuntimeWire wire : this.wires) {
            if (wire.getSource().getBinding().getClass() != to.getBinding().getClass()) continue;
            return wire;
        }
        return null;
    }

    private static EndpointReference getCallbackEndpoint(Message msgContext) {
        EndpointReference from = msgContext.getFrom();
        if (from == null) {
            return null;
        }
        return from.getReferenceParameters().getCallbackReference();
    }

    private RuntimeWire cloneAndBind(RuntimeWire wire) {
        RuntimeWire boundWire = null;
        if (this.resolvedEndpoint != null) {
            boundWire = ((RuntimeWireImpl)wire).lookupCache(this.resolvedEndpoint);
            if (boundWire != null) {
                return boundWire;
            }
            try {
                Contract contract = this.resolvedEndpoint.getContract();
                RuntimeComponentReference ref = null;
                if (contract == null) {
                    boundWire = (RuntimeWire)wire.clone();
                } else if (contract instanceof RuntimeComponentReference) {
                    ref = (RuntimeComponentReference)contract;
                    boundWire = ref.getRuntimeWire(this.resolvedEndpoint.getBinding());
                } else {
                    ref = CallbackReferenceImpl.bind((RuntimeComponentReference)wire.getSource().getContract(), this.resolvedEndpoint.getComponent(), (RuntimeComponentService)contract);
                    boundWire = (RuntimeWire)ref.getRuntimeWires().get(0);
                }
                this.configureWire(boundWire);
                ((RuntimeWireImpl)wire).addToCache(this.resolvedEndpoint, boundWire);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return boundWire;
    }

    private static RuntimeComponentReference bind(RuntimeComponentReference reference, RuntimeComponent component, RuntimeComponentService service) throws CloneNotSupportedException {
        RuntimeComponentReference ref = (RuntimeComponentReference)reference.clone();
        ref.getTargets().add(service);
        ref.getBindings().clear();
        for (Binding binding : service.getBindings()) {
            if (binding instanceof OptimizableBinding) {
                OptimizableBinding optimizableBinding = (OptimizableBinding)((OptimizableBinding)binding).clone();
                optimizableBinding.setTargetBinding(binding);
                optimizableBinding.setTargetComponent((Component)component);
                optimizableBinding.setTargetComponentService((ComponentService)service);
                ref.getBindings().add(optimizableBinding);
                continue;
            }
            ref.getBindings().add(binding);
        }
        return ref;
    }

    private void configureWire(RuntimeWire wire) {
        Binding binding = wire.getSource().getBinding();
        binding.setURI(this.resolvedEndpoint.getURI());
        RuntimeComponentReference ref = (RuntimeComponentReference)wire.getSource().getContract();
        wire.getTarget().setInterfaceContract(ref.getBindingProvider(binding).getBindingInterfaceContract());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.callbackID = in.readObject();
        this.convID = in.readObject();
        this.compositeActivator = ComponentContextHelper.getCurrentCompositeActivator();
        String uri = in.readUTF();
        String[] splitURI = super.splitComponentURI(uri);
        String componentURI = splitURI[0];
        String serviceName = splitURI[1];
        Component targetComponent = super.resolveComponentURI(componentURI);
        ComponentService targetService = super.resolveService(serviceName, targetComponent);
        InterfaceContract targetServiceIfaceContract = targetService.getInterfaceContract();
        this.resolvedEndpoint = new EndpointReferenceImpl((RuntimeComponent)targetComponent, (Contract)targetService, null, targetServiceIfaceContract);
        JavaInterface ji = (JavaInterface)targetServiceIfaceContract.getInterface();
        this.businessInterface = ji.getJavaClass();
        RuntimeWire cbWire = (RuntimeWire)((RuntimeComponentService)targetService).getRuntimeWires().get(0);
        try {
            this.wire = (RuntimeWireImpl)cbWire.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IOException(e.toString());
        }
        RuntimeComponentReferenceImpl ref = new RuntimeComponentReferenceImpl();
        ref.setComponent((RuntimeComponent)targetComponent);
        ref.setInterfaceContract(targetServiceIfaceContract);
        ((EndpointReferenceImpl)this.wire.getSource()).setContract((Contract)ref);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.callbackID);
        out.writeObject(this.convID);
        out.writeUTF(this.resolvedEndpoint.getURI());
    }
}

