/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.UUID;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.BindingBuilderExtension;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.core.assembly.CompositeActivatorImpl;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.core.assembly.EndpointWireImpl;
import org.apache.tuscany.sca.core.assembly.ReferenceParametersImpl;
import org.apache.tuscany.sca.core.context.ComponentContextHelper;
import org.apache.tuscany.sca.core.context.ComponentContextImpl;
import org.apache.tuscany.sca.core.conversation.ConversationManager;
import org.apache.tuscany.sca.core.conversation.ConversationState;
import org.apache.tuscany.sca.core.conversation.ExtendedConversation;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.runtime.EndpointReference;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.CallableReference;
import org.osoa.sca.Conversation;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallableReferenceImpl<B>
implements CallableReference<B>,
Externalizable {
    static final long serialVersionUID = -521548304761848325L;
    protected transient CompositeActivator compositeActivator;
    protected transient ProxyFactory proxyFactory;
    protected transient Class<B> businessInterface;
    protected transient Object proxy;
    protected transient ConversationManager conversationManager;
    protected transient ExtendedConversation conversation;
    protected transient Object conversationID;
    protected Object callbackID;
    protected transient RuntimeComponent component;
    protected transient RuntimeComponentReference reference;
    protected transient Binding binding;
    protected String scdl;
    private transient RuntimeComponentReference clonedRef;
    private transient ReferenceParameters refParams;
    private transient XMLStreamReader xmlReader;
    private transient RuntimeWire endpointWire;

    public CallableReferenceImpl() {
    }

    public CallableReferenceImpl(XMLStreamReader xmlReader) throws Exception {
        this.xmlReader = xmlReader;
        this.resolve();
    }

    protected CallableReferenceImpl(Class<B> businessInterface, RuntimeComponent component, RuntimeComponentReference reference, Binding binding, ProxyFactory proxyFactory, CompositeActivator compositeActivator) {
        this.proxyFactory = proxyFactory;
        this.businessInterface = businessInterface;
        this.component = component;
        this.reference = reference;
        this.binding = binding;
        if (this.binding == null) {
            this.binding = (Binding)this.reference.getBinding(SCABinding.class);
            if (this.binding == null) {
                this.binding = (Binding)this.reference.getBindings().get(0);
            }
        }
        this.compositeActivator = compositeActivator;
        this.conversationManager = this.compositeActivator.getConversationManager();
        this.initCallbackID();
    }

    public CallableReferenceImpl(Class<B> businessInterface, RuntimeWire wire, ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
        this.businessInterface = businessInterface;
        this.bind(wire);
    }

    public RuntimeWire getRuntimeWire() {
        try {
            this.resolve();
            if (this.endpointWire != null) {
                return this.endpointWire;
            }
            if (this.reference != null) {
                return this.reference.getRuntimeWire(this.binding);
            }
            return null;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    protected void bind(RuntimeWire wire) {
        if (wire != null) {
            if (wire instanceof EndpointWireImpl) {
                this.endpointWire = wire;
            }
            this.component = wire.getSource().getComponent();
            this.reference = (RuntimeComponentReference)wire.getSource().getContract();
            this.binding = wire.getSource().getBinding();
            this.compositeActivator = ((ComponentContextImpl)this.component.getComponentContext()).getCompositeActivator();
            this.conversationManager = this.compositeActivator.getConversationManager();
            this.initCallbackID();
        }
    }

    protected void initCallbackID() {
        if (this.reference.getInterfaceContract().getCallbackInterface() != null) {
            this.callbackID = this.createCallbackID();
        }
    }

    public B getProxy() throws ObjectCreationException {
        try {
            if (this.proxy == null) {
                this.proxy = this.createProxy();
            }
            return this.businessInterface.cast(this.proxy);
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
    }

    public void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    protected Object createProxy() throws Exception {
        return this.proxyFactory.createProxy(this);
    }

    public B getService() {
        try {
            this.resolve();
            return this.getProxy();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Class<B> getBusinessInterface() {
        try {
            this.resolve();
            return this.businessInterface;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public boolean isConversational() {
        try {
            this.resolve();
            return this.reference == null ? false : this.reference.getInterfaceContract().getInterface().isConversational();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Conversation getConversation() {
        try {
            this.resolve();
            if (this.conversation == null || this.conversation.getState() == ConversationState.ENDED) {
                this.conversation = null;
            }
            return this.conversation;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Object getCallbackID() {
        try {
            this.resolve();
            return this.callbackID;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasSCDL = in.readBoolean();
        this.scdl = hasSCDL ? in.readUTF() : null;
    }

    private synchronized void resolve() throws Exception {
        if ((this.scdl != null || this.xmlReader != null) && this.component == null && this.reference == null) {
            ComponentContextHelper componentContextHelper = ComponentContextHelper.getCurrentComponentContextHelper();
            if (componentContextHelper != null) {
                Interface i;
                Component c;
                this.compositeActivator = ComponentContextHelper.getCurrentCompositeActivator();
                this.conversationManager = this.compositeActivator.getConversationManager();
                if (this.xmlReader != null) {
                    c = componentContextHelper.fromXML(this.xmlReader);
                    this.xmlReader = null;
                } else {
                    c = componentContextHelper.fromXML(this.scdl);
                    this.scdl = null;
                }
                this.component = (RuntimeComponent)c;
                this.compositeActivator.configureComponentContext(this.component);
                this.reference = (RuntimeComponentReference)c.getReferences().get(0);
                this.reference.setComponent(this.component);
                this.clonedRef = this.reference;
                ReferenceParameters parameters = null;
                for (Object ext : this.reference.getExtensions()) {
                    if (!(ext instanceof ReferenceParameters)) continue;
                    parameters = (ReferenceParameters)ext;
                    break;
                }
                if (parameters != null) {
                    this.refParams = parameters;
                    this.callbackID = parameters.getCallbackID();
                    this.attachConversation(parameters.getConversationID());
                }
                block1: for (Binding binding : this.reference.getBindings()) {
                    if (!(binding instanceof OptimizableBinding)) continue;
                    String[] splitURI = this.splitComponentURI(binding.getURI());
                    String componentURI = splitURI[0];
                    String serviceName = splitURI[1];
                    Component targetComponent = this.resolveComponentURI(componentURI);
                    ComponentService targetService = this.resolveService(serviceName, targetComponent);
                    OptimizableBinding optimizableBinding = (OptimizableBinding)binding;
                    optimizableBinding.setTargetComponent(targetComponent);
                    optimizableBinding.setTargetComponentService(targetService);
                    if (targetService == null) continue;
                    for (Binding serviceBinding : targetService.getBindings()) {
                        if (serviceBinding.getClass() != binding.getClass()) continue;
                        optimizableBinding.setTargetBinding(serviceBinding);
                        continue block1;
                    }
                }
                if (this.binding == null) {
                    this.binding = (Binding)this.reference.getBinding(SCABinding.class);
                    if (this.binding == null) {
                        this.binding = (Binding)this.reference.getBindings().get(0);
                    }
                }
                if ((i = this.reference.getInterfaceContract().getInterface()) instanceof JavaInterface) {
                    JavaInterface javaInterface = (JavaInterface)i;
                    if (javaInterface.isUnresolved()) {
                        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                            @Override
                            public ClassLoader run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        javaInterface.setJavaClass(classLoader.loadClass(javaInterface.getName()));
                        this.compositeActivator.getJavaInterfaceFactory().createJavaInterface(javaInterface, javaInterface.getJavaClass());
                    }
                    this.businessInterface = javaInterface.getJavaClass();
                }
                if (this.binding instanceof BindingBuilderExtension) {
                    ((BindingBuilderExtension)this.binding).getBuilder().build((Component)this.component, (AbstractContract)this.reference, this.binding, null);
                }
                this.proxyFactory = this.compositeActivator.getProxyFactory();
            }
        } else {
            this.compositeActivator = ComponentContextHelper.getCurrentCompositeActivator();
            if (this.compositeActivator != null) {
                this.proxyFactory = this.compositeActivator.getProxyFactory();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            String xml = this.toXMLString();
            if (xml == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.toXMLString());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public String toXMLString() throws IOException {
        if (this.reference != null) {
            if (this.clonedRef == null) {
                try {
                    this.clonedRef = (RuntimeComponentReference)this.reference.clone();
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
            }
            if (this.refParams == null) {
                this.refParams = new ReferenceParametersImpl();
                Object toRemove = null;
                for (Object extension : this.clonedRef.getExtensions()) {
                    if (!(extension instanceof ReferenceParameters)) continue;
                    toRemove = extension;
                }
                if (toRemove != null) {
                    this.clonedRef.getExtensions().remove(toRemove);
                }
                this.clonedRef.getExtensions().add(this.refParams);
            }
            this.refParams.setCallbackID(this.callbackID);
            if (this.conversation != null) {
                this.refParams.setConversationID(this.conversation.getConversationID());
            }
            return ((CompositeActivatorImpl)this.compositeActivator).getComponentContextHelper().toXML((Component)this.component, (ComponentReference)this.clonedRef);
        }
        return this.scdl;
    }

    private String createCallbackID() {
        return UUID.randomUUID().toString();
    }

    public void attachCallbackID(Object callbackID) {
        this.callbackID = callbackID;
    }

    public void attachConversationID(Object conversationID) {
        this.conversationID = conversationID;
    }

    public void attachConversation(ExtendedConversation conversation) {
        this.conversation = conversation;
    }

    public void attachConversation(Object conversationID) {
        if (conversationID != null) {
            ExtendedConversation conversation = this.conversationManager.getConversation(conversationID);
            if (conversation == null) {
                conversation = this.conversationManager.startConversation(conversationID);
            }
            this.conversation = conversation;
        } else {
            this.conversation = null;
        }
    }

    protected ReferenceParameters getReferenceParameters() {
        ReferenceParametersImpl parameters = new ReferenceParametersImpl();
        parameters.setCallbackID(this.callbackID);
        if (this.getConversation() != null) {
            parameters.setConversationID(this.conversation.getConversationID());
        }
        return parameters;
    }

    public EndpointReference getEndpointReference() {
        try {
            this.resolve();
            Reference componentTypeRef = this.reference.getReference();
            InterfaceContract sourceContract = componentTypeRef == null ? this.reference.getInterfaceContract() : componentTypeRef.getInterfaceContract();
            sourceContract = sourceContract.makeUnidirectional(false);
            EndpointReferenceImpl epr = new EndpointReferenceImpl(this.component, (Contract)this.reference, this.binding, sourceContract);
            ReferenceParameters parameters = this.getReferenceParameters();
            epr.setReferenceParameters(parameters);
            return epr;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public XMLStreamReader getXMLReader() {
        return this.xmlReader;
    }

    protected Component resolveComponentURI(String componentURI) {
        String[] splitUri = this.splitComponentURI(componentURI);
        return this.compositeActivator.resolve(splitUri[0]);
    }

    protected String[] splitComponentURI(String componentURI) {
        String[] result = new String[2];
        if (componentURI.startsWith("/")) {
            componentURI = componentURI.substring(1);
        }
        int index = componentURI.lastIndexOf(47);
        String serviceName = "";
        if (index > -1) {
            serviceName = componentURI.substring(index + 1);
            componentURI = componentURI.substring(0, index);
        }
        result[0] = componentURI;
        result[1] = serviceName;
        return result;
    }

    protected ComponentService resolveService(String serviceName, Component targetComponent) {
        ComponentService targetService = null;
        if (targetComponent != null) {
            if ("".equals(serviceName)) {
                targetService = ComponentContextHelper.getSingleService(targetComponent);
            } else {
                for (ComponentService service : targetComponent.getServices()) {
                    if (!service.getName().equals(serviceName)) continue;
                    targetService = service;
                    break;
                }
            }
        }
        return targetService;
    }
}

