/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.impl.ComponentServiceImpl;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeComponentServiceImpl
extends ComponentServiceImpl
implements RuntimeComponentService {
    private ArrayList<RuntimeWire> wires = new ArrayList();
    private ArrayList<RuntimeWire> callbackWires = new ArrayList();
    private HashMap<Binding, ServiceBindingProvider> bindingProviders = new HashMap();
    private HashMap<Binding, List<PolicyProvider>> policyProviders = new HashMap();

    public List<RuntimeWire> getRuntimeWires() {
        return this.wires;
    }

    public RuntimeWire getRuntimeWire(Binding binding) {
        for (RuntimeWire wire : this.wires) {
            if (wire.getTarget().getBinding() != binding) continue;
            return wire;
        }
        return null;
    }

    public RuntimeWire getRuntimeWire(Binding binding, InterfaceContract interfaceContract) {
        RuntimeWire wire = this.getRuntimeWire(binding);
        if (wire == null) {
            return null;
        }
        if (interfaceContract != null && interfaceContract != wire.getSource().getInterfaceContract()) {
            try {
                wire = (RuntimeWire)wire.clone();
                wire.getSource().setInterfaceContract(interfaceContract);
                wire.rebuild();
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        }
        return wire;
    }

    public List<RuntimeWire> getCallbackWires() {
        return this.callbackWires;
    }

    public ServiceBindingProvider getBindingProvider(Binding binding) {
        return this.bindingProviders.get(binding);
    }

    public void setBindingProvider(Binding binding, ServiceBindingProvider bindingProvider) {
        this.bindingProviders.put(binding, bindingProvider);
    }

    public Invoker getInvoker(Binding binding, Operation operation) {
        return this.getInvoker(binding, null, operation);
    }

    public Invoker getInvoker(Binding binding, InterfaceContract interfaceContract, Operation operation) {
        InvocationChain chain = this.getInvocationChain(binding, interfaceContract, operation);
        if (chain != null) {
            return chain.getHeadInvoker();
        }
        return null;
    }

    public InvocationChain getInvocationChain(Binding binding, InterfaceContract interfaceContract, Operation operation) {
        RuntimeWire wire = this.getRuntimeWire(binding);
        if (wire == null) {
            return null;
        }
        if (interfaceContract != null && interfaceContract != wire.getSource().getInterfaceContract()) {
            try {
                wire = (RuntimeWire)wire.clone();
                wire.getSource().setInterfaceContract(interfaceContract);
                wire.rebuild();
            }
            catch (CloneNotSupportedException e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        }
        return wire.getInvocationChain(operation);
    }

    public InvocationChain getInvocationChain(Binding binding, Operation operation) {
        return this.getInvocationChain(binding, null, operation);
    }

    public Object clone() throws CloneNotSupportedException {
        RuntimeComponentServiceImpl clone = (RuntimeComponentServiceImpl)((Object)super.clone());
        clone.bindingProviders = (HashMap)this.bindingProviders.clone();
        clone.wires = (ArrayList)this.wires.clone();
        clone.callbackWires = (ArrayList)this.callbackWires.clone();
        clone.policyProviders = (HashMap)this.policyProviders.clone();
        return clone;
    }

    public void addPolicyProvider(Binding binding, PolicyProvider policyProvider) {
        List<PolicyProvider> providers = this.policyProviders.get(binding);
        if (providers == null) {
            providers = new ArrayList<PolicyProvider>();
            this.policyProviders.put(binding, providers);
        }
        providers.add(policyProvider);
    }

    public List<PolicyProvider> getPolicyProviders(Binding binding) {
        return this.policyProviders.get(binding);
    }
}

