/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.namespace.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImportExportFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceImportProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NamespaceImport> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName IMPORT = new QName("http://www.osoa.org/xmlns/sca/1.0", "import");
    private static final String NAMESPACE = "namespace";
    private static final String LOCATION = "location";
    private final NamespaceImportExportFactory factory;
    private final ExtensionFactory extensionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private final StAXAttributeProcessor<Object> attributeProcessor;
    private final Monitor monitor;

    public NamespaceImportProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> attributeProcessor, Monitor monitor) {
        this.factory = (NamespaceImportExportFactory)modelFactories.getFactory(NamespaceImportExportFactory.class);
        this.monitor = monitor;
        this.extensionFactory = (ExtensionFactory)modelFactories.getFactory(ExtensionFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.attributeProcessor = attributeProcessor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(((Object)((Object)this)).getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(((Object)((Object)this)).getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public QName getArtifactType() {
        return IMPORT;
    }

    public Class<NamespaceImport> getModelType() {
        return NamespaceImport.class;
    }

    public NamespaceImport read(XMLStreamReader reader) throws ContributionReadException {
        NamespaceImport namespaceImport = this.factory.createNamespaceImport();
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        QName element = reader.getName();
                        if (IMPORT.equals(element)) {
                            String ns = reader.getAttributeValue(null, NAMESPACE);
                            if (ns == null) {
                                this.error("AttributeNameSpaceMissing", (Object)reader, new Object[0]);
                            } else {
                                namespaceImport.setNamespace(ns);
                            }
                            String location = NamespaceImportProcessor.getURIString((XMLStreamReader)reader, (String)LOCATION);
                            if (location != null) {
                                namespaceImport.setLocation(location);
                            }
                            this.readExtendedAttributes(reader, (Extensible)namespaceImport, this.attributeProcessor, this.extensionFactory);
                            break;
                        }
                        this.readExtendedElement(reader, (Extensible)namespaceImport, this.extensionProcessor);
                        break;
                    }
                    case 2: {
                        if (!IMPORT.equals(reader.getName())) break;
                        return namespaceImport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", (Object)reader, (Exception)ex);
        }
        return namespaceImport;
    }

    public void write(NamespaceImport namespaceImport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(IMPORT.getNamespaceURI(), IMPORT.getLocalPart());
        if (namespaceImport.getNamespace() != null) {
            writer.writeAttribute(NAMESPACE, namespaceImport.getNamespace());
        }
        if (namespaceImport.getLocation() != null) {
            writer.writeAttribute(LOCATION, namespaceImport.getLocation());
        }
        this.writeExtendedAttributes(writer, (Extensible)namespaceImport, this.attributeProcessor);
        this.writeExtendedElements(writer, (Extensible)namespaceImport, this.extensionProcessor);
        writer.writeEndElement();
    }

    public void resolve(NamespaceImport model, ModelResolver resolver) throws ContributionResolveException {
    }
}

