/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.namespace.impl;

import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.namespace.NamespaceExport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.resolver.DefaultImportAllModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionListener;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;

public class NamespaceImportExportListener
implements ContributionListener {
    public void contributionAdded(ContributionRepository repository, Contribution contribution) {
        for (Export export : contribution.getExports()) {
            export.setModelResolver(contribution.getModelResolver());
        }
        for (Import import_ : contribution.getImports()) {
            Contribution targetContribution;
            boolean initialized = false;
            if (!(import_ instanceof NamespaceImport)) continue;
            NamespaceImport namespaceImport = (NamespaceImport)import_;
            if (namespaceImport.getLocation() != null && (targetContribution = repository.getContribution(namespaceImport.getLocation())) != null) {
                for (Export export : targetContribution.getExports()) {
                    if (!(export instanceof NamespaceExport)) continue;
                    NamespaceExport namespaceExport = (NamespaceExport)export;
                    if (!namespaceImport.getNamespace().equals(namespaceExport.getNamespace())) continue;
                    namespaceImport.setModelResolver(namespaceExport.getModelResolver());
                    initialized = true;
                    break;
                }
            }
            if (initialized) continue;
            import_.setModelResolver((ModelResolver)new DefaultImportAllModelResolver(import_, repository.getContributions()));
        }
    }

    public void contributionRemoved(ContributionRepository repository, Contribution contribution) {
    }

    public void contributionUpdated(ContributionRepository repository, Contribution oldContribution, Contribution contribution) {
    }
}

