/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.namespace.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.namespace.NamespaceExport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImportExportFactory;
import org.apache.tuscany.sca.contribution.namespace.impl.NamespaceExportModelResolver;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceExportProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NamespaceExport> {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final QName EXPORT = new QName("http://www.osoa.org/xmlns/sca/1.0", "export");
    private static final String NAMESPACE = "namespace";
    private final NamespaceImportExportFactory factory;
    private final Monitor monitor;
    private final ExtensionFactory extensionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private final StAXAttributeProcessor<Object> attributeProcessor;

    public NamespaceExportProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> attributeProcessor, Monitor monitor) {
        this.factory = (NamespaceImportExportFactory)modelFactories.getFactory(NamespaceImportExportFactory.class);
        this.extensionFactory = (ExtensionFactory)modelFactories.getFactory(ExtensionFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.attributeProcessor = attributeProcessor;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(((Object)((Object)this)).getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(((Object)((Object)this)).getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public QName getArtifactType() {
        return EXPORT;
    }

    public Class<NamespaceExport> getModelType() {
        return NamespaceExport.class;
    }

    public NamespaceExport read(XMLStreamReader reader) throws ContributionReadException {
        NamespaceExport namespaceExport = this.factory.createNamespaceExport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (EXPORT.equals(element)) {
                            String ns = reader.getAttributeValue(null, NAMESPACE);
                            if (ns == null) {
                                this.error("AttributeNameSpaceMissing", (Object)reader, new Object[0]);
                            } else {
                                namespaceExport.setNamespace(ns);
                            }
                            this.readExtendedAttributes(reader, (Extensible)namespaceExport, this.attributeProcessor, this.extensionFactory);
                            break;
                        }
                        this.readExtendedElement(reader, (Extensible)namespaceExport, this.extensionProcessor);
                        break;
                    }
                    case 2: {
                        if (!EXPORT.equals(reader.getName())) break;
                        return namespaceExport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", (Object)reader, (Exception)ex);
        }
        return namespaceExport;
    }

    public void write(NamespaceExport namespaceExport, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(EXPORT.getNamespaceURI(), EXPORT.getLocalPart());
        if (namespaceExport.getNamespace() != null) {
            writer.writeAttribute(NAMESPACE, namespaceExport.getNamespace());
        }
        this.writeExtendedAttributes(writer, (Extensible)namespaceExport, this.attributeProcessor);
        this.writeExtendedElements(writer, (Extensible)namespaceExport, this.extensionProcessor);
        writer.writeEndElement();
    }

    public void resolve(NamespaceExport namespaceExport, ModelResolver resolver) throws ContributionResolveException {
        if (namespaceExport.getNamespace() != null) {
            namespaceExport.setModelResolver(new NamespaceExportModelResolver(resolver));
        }
    }
}

