/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.service.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;

public class IOHelper {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static InputStream getInputStream(URL url) throws IOException {
        return new SafeURLInputStream(url);
    }

    public static class SafeURLInputStream
    extends InputStream {
        private JarFile jarFile;
        private InputStream is;

        public SafeURLInputStream(URL url) throws IOException {
            String protocol = url.getProtocol();
            if (protocol != null && protocol.equals("jar")) {
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                connection.setUseCaches(false);
                this.is = connection.getInputStream();
                this.jarFile = connection.getJarFile();
            } else {
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                this.is = connection.getInputStream();
            }
        }

        public SafeURLInputStream(JarURLConnection connection) throws IOException {
            connection.setUseCaches(false);
            this.is = connection.getInputStream();
            this.jarFile = connection.getJarFile();
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
            if (this.jarFile != null) {
                this.jarFile.close();
            }
        }

        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }
    }
}

