/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.PackageProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionException;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;
import org.apache.tuscany.sca.contribution.service.ContributionService;
import org.apache.tuscany.sca.contribution.service.ExtensibleContributionListener;
import org.apache.tuscany.sca.contribution.service.TypeDescriber;
import org.apache.tuscany.sca.contribution.service.impl.PackageTypeDescriberImpl;
import org.apache.tuscany.sca.contribution.service.util.IOHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionServiceImpl
implements ContributionService {
    private ExtensionPointRegistry extensionPoints;
    private ContributionRepository contributionRepository;
    private PackageProcessor packageProcessor;
    private URLArtifactProcessor artifactProcessor;
    private StAXArtifactProcessor staxProcessor;
    private ExtensibleContributionListener contributionListener;
    private ModelResolverExtensionPoint modelResolvers;
    private ModelFactoryExtensionPoint modelFactories;
    private XMLInputFactory xmlFactory;
    private AssemblyFactory assemblyFactory;
    private ContributionFactory contributionFactory;
    private ModelResolver policyDefinitionsResolver;
    private List policyDefinitions;
    private Monitor monitor;
    private String COMPOSITE_FILE_EXTN = ".composite";
    private TypeDescriber packageTypeDescriber;

    public ContributionServiceImpl(ContributionRepository repository, PackageProcessor packageProcessor, URLArtifactProcessor documentProcessor, StAXArtifactProcessor staxProcessor, ExtensibleContributionListener contributionListener, ModelResolver policyDefinitionsResolver, ModelResolverExtensionPoint modelResolvers, ModelFactoryExtensionPoint modelFactories, AssemblyFactory assemblyFactory, ContributionFactory contributionFactory, XMLInputFactory xmlFactory, List<SCADefinitions> policyDefinitions, ExtensionPointRegistry extensionPoints, Monitor monitor) {
        this.extensionPoints = extensionPoints;
        this.contributionRepository = repository;
        this.packageProcessor = packageProcessor;
        this.artifactProcessor = documentProcessor;
        this.staxProcessor = staxProcessor;
        this.contributionListener = contributionListener;
        this.modelResolvers = modelResolvers;
        this.modelFactories = modelFactories;
        this.xmlFactory = xmlFactory;
        this.assemblyFactory = assemblyFactory;
        this.contributionFactory = contributionFactory;
        this.policyDefinitionsResolver = policyDefinitionsResolver;
        this.policyDefinitions = policyDefinitions;
        this.monitor = monitor;
        this.packageTypeDescriber = new PackageTypeDescriberImpl();
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-impl-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public Contribution contribute(String contributionURI, URL sourceURL, boolean storeInRepository) throws ContributionException, IOException {
        if (contributionURI == null) {
            this.error("ContributionURINull", contributionURI, new Object[0]);
            throw new IllegalArgumentException("URI for the contribution is null");
        }
        if (sourceURL == null) {
            this.error("SourceURLNull", sourceURL, new Object[0]);
            throw new IllegalArgumentException("Source URL for the contribution is null");
        }
        return this.addContribution(contributionURI, sourceURL, null, null, storeInRepository);
    }

    public Contribution contribute(String contributionURI, URL sourceURL, ModelResolver modelResolver, boolean storeInRepository) throws ContributionException, IOException {
        if (contributionURI == null) {
            this.error("ContributionURINull", contributionURI, new Object[0]);
            throw new IllegalArgumentException("URI for the contribution is null");
        }
        if (sourceURL == null) {
            this.error("SourceURLNull", sourceURL, new Object[0]);
            throw new IllegalArgumentException("Source URL for the contribution is null");
        }
        return this.addContribution(contributionURI, sourceURL, null, modelResolver, storeInRepository);
    }

    public Contribution contribute(String contributionURI, URL sourceURL, InputStream input) throws ContributionException, IOException {
        return this.addContribution(contributionURI, sourceURL, input, null, true);
    }

    public Contribution contribute(String contributionURI, URL sourceURL, InputStream input, ModelResolver modelResolver) throws ContributionException, IOException {
        return this.addContribution(contributionURI, sourceURL, input, modelResolver, true);
    }

    public Contribution getContribution(String uri) {
        return this.contributionRepository.getContribution(uri);
    }

    public void remove(String uri) throws ContributionException {
        Contribution contribution = this.contributionRepository.getContribution(uri);
        this.contributionRepository.removeContribution(contribution);
        this.contributionListener.contributionRemoved(this.contributionRepository, contribution);
    }

    public void addDeploymentComposite(Contribution contribution, Composite composite) throws ContributionException {
        Artifact artifact = this.contributionFactory.createArtifact();
        artifact.setURI(composite.getURI());
        artifact.setModel((Object)composite);
        contribution.getArtifacts().add(artifact);
        contribution.getDeployables().add(composite);
    }

    private static boolean isDirectory(URL url) {
        if ("file".equals(url.getProtocol())) {
            try {
                final URI uri = url.toURI();
                return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return new File(uri).isDirectory();
                    }
                });
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Contribution addContribution(String contributionURI, URL sourceURL, InputStream contributionStream, ModelResolver modelResolver, boolean storeInRepository) throws IOException, ContributionException {
        if (contributionStream == null && sourceURL == null) {
            this.error("ContributionContentNull", contributionStream, new Object[0]);
            throw new IllegalArgumentException("The content of the contribution is null.");
        }
        URL locationURL = sourceURL;
        if (this.contributionRepository != null && storeInRepository) {
            locationURL = contributionStream == null ? this.contributionRepository.store(contributionURI, sourceURL) : this.contributionRepository.store(contributionURI, sourceURL, contributionStream);
        }
        Contribution contribution = this.contributionFactory.createContribution();
        if (modelResolver == null) {
            modelResolver = new ExtensibleModelResolver(contribution, this.extensionPoints, this.modelResolvers, this.modelFactories, this.policyDefinitionsResolver);
        }
        contribution.setURI(contributionURI);
        contribution.setLocation(locationURL.toString());
        contribution.setModelResolver(modelResolver);
        contribution.setType(this.packageTypeDescriber.getType(locationURL, null));
        List contributionArtifacts = null;
        if (storeInRepository || contributionStream == null) {
            if (ContributionServiceImpl.isDirectory(sourceURL)) {
                contributionStream = null;
            } else {
                URLConnection connection = sourceURL.openConnection();
                connection.setUseCaches(false);
                final URLConnection finalConnection = connection;
                try {
                    contributionStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            return finalConnection.getInputStream();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
            }
            try {
                contributionArtifacts = this.packageProcessor.getArtifacts(locationURL, contributionStream);
            }
            finally {
                IOHelper.closeQuietly(contributionStream);
                contributionStream = null;
            }
        }
        contributionArtifacts = this.packageProcessor.getArtifacts(locationURL, contributionStream);
        try {
            this.processReadPhase(contribution, contributionArtifacts);
        }
        catch (Exception e) {
            throw new ContributionException((Throwable)e);
        }
        this.readContributionMetadata(contribution);
        this.contributionListener.contributionAdded(this.contributionRepository, contribution);
        this.processResolvePhase(contribution);
        String prefix = "META-INF/sca-deployables/";
        for (Artifact artifact : contribution.getArtifacts()) {
            if (!(artifact.getModel() instanceof Composite) || !artifact.getURI().startsWith(prefix)) continue;
            Composite composite = (Composite)artifact.getModel();
            if (contribution.getDeployables().contains(composite)) continue;
            contribution.getDeployables().add(composite);
        }
        this.processApplicationComposite(contribution);
        this.contributionRepository.addContribution(contribution);
        return contribution;
    }

    private void readContributionMetadata(Contribution contribution) {
        ContributionMetadata m1 = null;
        ContributionMetadata m2 = null;
        for (Artifact a : contribution.getArtifacts()) {
            if ("META-INF/sca-contribution-generated.xml".equals(a.getURI())) {
                m1 = (ContributionMetadata)a.getModel();
            }
            if (!"META-INF/sca-contribution.xml".equals(a.getURI())) continue;
            m2 = (ContributionMetadata)a.getModel();
        }
        if (m1 != null) {
            contribution.getImports().addAll(m1.getImports());
            contribution.getExports().addAll(m1.getExports());
            contribution.getDeployables().addAll(m1.getDeployables());
        }
        if (m2 != null) {
            contribution.getImports().addAll(m2.getImports());
            contribution.getExports().addAll(m2.getExports());
            contribution.getDeployables().addAll(m2.getDeployables());
        }
    }

    private void processApplicationComposite(Contribution contribution) {
        Composite composite = this.findComposite("web-inf/web.composite", contribution);
        if (composite != null && !contribution.getDeployables().contains(composite)) {
            contribution.getDeployables().add(this.createDeploymentComposite(composite));
        }
    }

    private Composite createDeploymentComposite(Composite composite) {
        return composite;
    }

    private Composite findComposite(String name, Contribution contribution) {
        for (Artifact artifact : contribution.getArtifacts()) {
            if (!(artifact.getModel() instanceof Composite) || !name.equalsIgnoreCase(artifact.getURI())) continue;
            return (Composite)artifact.getModel();
        }
        return null;
    }

    private void processReadPhase(Contribution contribution, List<URI> artifacts) throws ContributionException, MalformedURLException, XMLStreamException {
        Artifact artifact;
        URL artifactURL;
        ModelResolver modelResolver = contribution.getModelResolver();
        URL contributionURL = new URL(contribution.getLocation());
        ArrayList<URI> compositeUris = new ArrayList<URI>();
        Object model = null;
        for (URI anArtifactUri : artifacts) {
            if (anArtifactUri.toString().endsWith(this.COMPOSITE_FILE_EXTN)) {
                compositeUris.add(anArtifactUri);
                continue;
            }
            artifactURL = this.packageProcessor.getArtifactURL(new URL(contribution.getLocation()), anArtifactUri);
            artifact = this.contributionFactory.createArtifact();
            artifact.setURI(anArtifactUri.toString());
            artifact.setLocation(artifactURL.toString());
            contribution.getArtifacts().add(artifact);
            modelResolver.addModel((Object)artifact);
            model = this.artifactProcessor.read(contributionURL, anArtifactUri, artifactURL);
            if (model == null) continue;
            artifact.setModel(model);
            modelResolver.addModel(model);
            if (!(model instanceof SCADefinitions)) continue;
            this.policyDefinitions.add(model);
            SCADefinitions definitions = (SCADefinitions)model;
            for (Intent intent : definitions.getPolicyIntents()) {
                this.policyDefinitionsResolver.addModel((Object)intent);
            }
            for (PolicySet policySet : definitions.getPolicySets()) {
                this.policyDefinitionsResolver.addModel((Object)policySet);
            }
            for (IntentAttachPointType attachPointType : definitions.getBindingTypes()) {
                this.policyDefinitionsResolver.addModel((Object)attachPointType);
            }
            for (IntentAttachPointType attachPointType : definitions.getImplementationTypes()) {
                this.policyDefinitionsResolver.addModel((Object)attachPointType);
            }
            for (Object binding : definitions.getBindings()) {
                this.policyDefinitionsResolver.addModel(binding);
            }
        }
        for (URI anArtifactUri : compositeUris) {
            artifactURL = this.packageProcessor.getArtifactURL(new URL(contribution.getLocation()), anArtifactUri);
            artifact = this.contributionFactory.createArtifact();
            artifact.setURI(anArtifactUri.toString());
            artifact.setLocation(artifactURL.toString());
            contribution.getArtifacts().add(artifact);
            modelResolver.addModel((Object)artifact);
            model = this.artifactProcessor.read(contributionURL, anArtifactUri, artifactURL);
            if (model == null) continue;
            artifact.setModel(model);
            modelResolver.addModel(model);
        }
    }

    private void processResolvePhase(Contribution contribution) throws ContributionException {
        ArrayList<Artifact> composites = new ArrayList<Artifact>();
        for (Artifact artifact : contribution.getArtifacts()) {
            if (artifact.getURI().endsWith(".composite")) {
                composites.add(artifact);
                continue;
            }
            if (artifact.getModel() == null) continue;
            this.artifactProcessor.resolve(artifact.getModel(), contribution.getModelResolver());
        }
        for (Artifact artifact : composites) {
            if (artifact.getModel() == null) continue;
            this.artifactProcessor.resolve(artifact.getModel(), contribution.getModelResolver());
        }
        ArrayList<Composite> resolvedDeployables = new ArrayList<Composite>();
        for (Composite deployableComposite : contribution.getDeployables()) {
            Composite resolvedDeployable = (Composite)contribution.getModelResolver().resolveModel(Composite.class, (Object)deployableComposite);
            resolvedDeployables.add(resolvedDeployable);
        }
        contribution.getDeployables().clear();
        contribution.getDeployables().addAll(resolvedDeployables);
    }
}

