/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.service.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.service.ContributionRepository;
import org.apache.tuscany.sca.contribution.service.util.FileHelper;
import org.apache.tuscany.sca.contribution.service.util.IOHelper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionRepositoryImpl
implements ContributionRepository {
    private static final String NS = "http://tuscany.apache.org/xmlns/1.0-SNAPSHOT";
    private static final String DOMAIN_INDEX_FILENAME = "sca-domain.xml";
    private boolean initialized = false;
    private String repository = null;
    private File rootFile = null;
    private Map<String, String> contributionLocations = new HashMap<String, String>();
    private Map<String, Contribution> contributionMap = new HashMap<String, Contribution>();
    private List<Contribution> contributions = new ArrayList<Contribution>();
    private URI domain;
    private XMLInputFactory factory;
    private Monitor monitor;

    protected void warning(String message, Object model, String ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-impl-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    protected void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-impl-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    protected void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-impl-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public ContributionRepositoryImpl(String repository, XMLInputFactory factory, Monitor monitor) throws IOException {
        this.monitor = monitor;
        this.repository = repository;
        this.factory = factory;
    }

    public URI getDomain() {
        return this.domain;
    }

    public URL store(final String contribution, URL sourceURL, InputStream contributionStream) throws IOException {
        URL contributionURL;
        if (!this.initialized) {
            try {
                this.initializeRepository();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        final File location = this.mapToFile(sourceURL);
        FileHelper.forceMkdir(location.getParentFile());
        ContributionRepositoryImpl.copy(contributionStream, location);
        try {
            contributionURL = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws IOException {
                    URL contributionURL = location.toURL();
                    URI relative = ContributionRepositoryImpl.this.rootFile.toURI().relativize(location.toURI());
                    ContributionRepositoryImpl.this.contributionLocations.put(contribution, relative.toString());
                    return contributionURL;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.error("PrivilegedActionException", (Object)location, (IOException)e.getException());
            throw (IOException)e.getException();
        }
        this.saveMap();
        return contributionURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL store(String contribution, URL sourceURL) throws IOException {
        if (!this.initialized) {
            try {
                this.initializeRepository();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        File location = this.mapToFile(sourceURL);
        File source = FileHelper.toFile(sourceURL);
        if (source == null || source.isFile()) {
            URLConnection connection = sourceURL.openConnection();
            connection.setUseCaches(false);
            InputStream is = connection.getInputStream();
            try {
                URL uRL = this.store(contribution, sourceURL, is);
                return uRL;
            }
            finally {
                IOHelper.closeQuietly(is);
            }
        }
        FileHelper.forceMkdir(location);
        FileHelper.copyDirectory(source, location);
        URI relative = this.rootFile.toURI().relativize(location.toURI());
        this.contributionLocations.put(contribution, relative.toString());
        this.saveMap();
        return location.toURL();
    }

    public URL find(String contribution) {
        if (!this.initialized) {
            try {
                this.initializeRepository();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (contribution == null) {
            return null;
        }
        String location = this.contributionLocations.get(contribution);
        if (location == null) {
            return null;
        }
        try {
            return new File(this.rootFile, location).toURL();
        }
        catch (MalformedURLException e) {
            this.error("MalformedURLException", (Object)location, new AssertionError((Object)e));
            throw new AssertionError((Object)e);
        }
    }

    public void remove(String contribution) {
        URL contributionURL;
        if (!this.initialized) {
            try {
                this.initializeRepository();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((contributionURL = this.find(contribution)) != null) {
            try {
                FileHelper.forceDelete(FileHelper.toFile(contributionURL));
                this.contributionLocations.remove(contribution);
                this.saveMap();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<String> list() {
        return new ArrayList<String>(this.contributionLocations.keySet());
    }

    public void addContribution(Contribution contribution) {
        this.contributionMap.put(contribution.getURI(), contribution);
        this.contributions.add(contribution);
    }

    public void removeContribution(Contribution contribution) {
        this.contributionMap.remove(contribution.getURI());
        this.contributions.remove(contribution);
    }

    public void updateContribution(Contribution contribution) {
        Contribution oldContribution = this.contributionMap.remove(contribution.getURI());
        this.contributions.remove(oldContribution);
        this.contributionMap.put(contribution.getURI(), contribution);
        this.contributions.add(contribution);
    }

    public Contribution getContribution(String uri) {
        return this.contributionMap.get(uri);
    }

    public List<Contribution> getContributions() {
        return Collections.unmodifiableList(this.contributions);
    }

    private File mapToFile(URL sourceURL) {
        String fileName = FileHelper.toFile(sourceURL).getName();
        return new File(this.rootFile, "contributions" + File.separator + fileName);
    }

    private void saveMap() {
        File domainFile = new File(this.rootFile, DOMAIN_INDEX_FILENAME);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(domainFile);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<domain uri=\"" + this.getDomain() + "\" xmlns=\"" + NS + "\">");
            for (Map.Entry<String, String> e : this.contributionLocations.entrySet()) {
                writer.println("    <contribution uri=\"" + e.getKey() + "\" location=\"" + e.getValue() + "\"/>");
            }
            writer.println("</domain>");
            writer.flush();
        }
        catch (IOException e) {
            try {
                IllegalArgumentException ae = new IllegalArgumentException(e);
                this.error("IllegalArgumentException", (Object)os, ae);
                throw ae;
            }
            catch (Throwable throwable) {
                IOHelper.closeQuietly(os);
                throw throwable;
            }
        }
        IOHelper.closeQuietly(os);
    }

    private void initializeRepository() throws IOException {
        String root = this.repository;
        if (root == null) {
            root = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String userHome = System.getProperty("user.home");
                    String slash = File.separator;
                    return userHome + slash + ".tuscany" + slash + "domains" + slash + "local" + slash;
                }
            });
        }
        final String finalRoot = root;
        this.rootFile = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                return new File(finalRoot);
            }
        });
        this.domain = AccessController.doPrivileged(new PrivilegedAction<URI>(){

            @Override
            public URI run() {
                return ContributionRepositoryImpl.this.rootFile.toURI();
            }
        });
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    FileHelper.forceMkdir(ContributionRepositoryImpl.this.rootFile);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            this.error("PrivilegedActionException", (Object)this.rootFile, (IOException)e.getException());
            throw (IOException)e.getException();
        }
        Boolean notDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return !ContributionRepositoryImpl.this.rootFile.exists() || !ContributionRepositoryImpl.this.rootFile.isDirectory() || !ContributionRepositoryImpl.this.rootFile.canRead();
            }
        });
        if (notDirectory.booleanValue()) {
            this.error("RootNotDirectory", (Object)this.rootFile, this.repository);
            throw new IOException("The root is not a directory: " + this.repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        FileInputStream is;
        File domainFile;
        if (!this.initialized) {
            try {
                this.initializeRepository();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!(domainFile = new File(this.rootFile, DOMAIN_INDEX_FILENAME)).isFile()) {
            return;
        }
        try {
            is = new FileInputStream(domainFile);
        }
        catch (FileNotFoundException e) {
            this.warning("DomainFileNotFound", domainFile, domainFile.getAbsolutePath());
            return;
        }
        try {
            XMLStreamReader reader = this.factory.createXMLStreamReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while (reader.hasNext()) {
                switch (reader.getEventType()) {
                    case 1: {
                        String uri;
                        String name = reader.getName().getLocalPart();
                        if ("domain".equals(name) && (uri = reader.getAttributeValue(null, "uri")) != null) {
                            this.domain = URI.create(uri);
                        }
                        if (!"contribution".equals(name)) break;
                        uri = reader.getAttributeValue(null, "uri");
                        String location = reader.getAttributeValue(null, "location");
                        this.contributionLocations.put(uri, location);
                        break;
                    }
                }
                reader.next();
            }
        }
        catch (Exception exception) {
        }
        finally {
            IOHelper.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream source, File target) throws IOException {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(target));
            in = new BufferedInputStream(source);
            IOHelper.copy(in, out);
        }
        catch (Throwable throwable) {
            IOHelper.closeQuietly(out);
            IOHelper.closeQuietly(in);
            throw throwable;
        }
        IOHelper.closeQuietly(out);
        IOHelper.closeQuietly(in);
    }
}

