/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.sax;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXHelper {
    private final SAXParserFactory saxParserFactory;

    public SAXHelper(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public SAXHelper(ExtensionPointRegistry registry) {
        FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.saxParserFactory = (SAXParserFactory)factories.getFactory(SAXParserFactory.class);
        this.saxParserFactory.setNamespaceAware(true);
    }

    public SAXHelper getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        return (SAXHelper)utilities.getUtility(SAXHelper.class);
    }

    public SAXParser newSAXParser() throws SAXException {
        try {
            return this.saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public XMLReader newXMLReader() throws SAXException {
        return this.newSAXParser().getXMLReader();
    }

    public void parse(String xmlString, ContentHandler handler) throws SAXException, IOException {
        XMLReader reader = this.newXMLReader();
        reader.setContentHandler(handler);
        reader.parse(new InputSource(new StringReader(xmlString)));
    }
}

