/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.http.cors.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.common.http.cors.CORSConfiguration;
import org.apache.tuscany.sca.common.http.cors.CORSConfigurationFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class CORSConfigurationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<CORSConfiguration> {
    private static final QName CORS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "corsConfiguration");
    private static final QName ALLOW_CREDENTIALS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "allowCredentials");
    private static final QName MAX_AGE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "maxAge");
    private static final QName ALLOW_ORIGINS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "allowOrigins");
    private static final QName ORIGIN_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "origin");
    private static final QName ALLOW_METHODS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "allowMethods");
    private static final QName METHOD_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "method");
    private static final QName ALLOW_HEADERS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "allowHeaders");
    private static final QName EXPOSE_HEADERS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "exposeHeaders");
    private static final QName HEADER_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "header");
    private StAXArtifactProcessor<Object> extensionProcessor;
    private CORSConfigurationFactory corsConfigurationFactory;

    public CORSConfigurationProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> extensionAttributeProcessor) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.corsConfigurationFactory = (CORSConfigurationFactory)modelFactories.getFactory(CORSConfigurationFactory.class);
        this.extensionProcessor = extensionProcessor;
    }

    public QName getArtifactType() {
        return CORS_QNAME;
    }

    public Class<CORSConfiguration> getModelType() {
        return CORSConfiguration.class;
    }

    public CORSConfiguration read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        CORSConfiguration corsConfiguration = this.corsConfigurationFactory.createCORSConfiguration();
        HeaderElementType headerType = null;
        while (reader.hasNext()) {
            QName elementName = null;
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    String value;
                    elementName = reader.getName();
                    if (ALLOW_CREDENTIALS_QNAME.equals(elementName)) {
                        value = reader.getElementText();
                        corsConfiguration.setAllowCredentials(Boolean.parseBoolean(value));
                        break;
                    }
                    if (MAX_AGE_QNAME.equals(elementName)) {
                        value = reader.getElementText();
                        corsConfiguration.setMaxAge(Integer.parseInt(value));
                        break;
                    }
                    if (ORIGIN_QNAME.equals(elementName)) {
                        value = reader.getElementText();
                        corsConfiguration.getAllowOrigins().add(value);
                        break;
                    }
                    if (METHOD_QNAME.equals(elementName)) {
                        value = reader.getElementText();
                        corsConfiguration.getAllowMethods().add(value);
                        break;
                    }
                    if (ALLOW_HEADERS_QNAME.equals(elementName)) {
                        headerType = HeaderElementType.ALLOWHEADERS;
                        break;
                    }
                    if (EXPOSE_HEADERS_QNAME.equals(elementName)) {
                        headerType = HeaderElementType.EXPOSEHEADERS;
                        break;
                    }
                    if (!HEADER_QNAME.equals(elementName) || headerType == null) break;
                    value = reader.getElementText();
                    if (headerType == HeaderElementType.ALLOWHEADERS) {
                        corsConfiguration.getAllowHeaders().add(value);
                        break;
                    }
                    corsConfiguration.getExposeHeaders().add(value);
                    break;
                }
                case 2: {
                    elementName = reader.getName();
                    if (!CORS_QNAME.equals(elementName)) break;
                    return corsConfiguration;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return corsConfiguration;
    }

    public void write(CORSConfiguration model, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, CORS_QNAME.getNamespaceURI(), CORS_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        this.writeStart(writer, ALLOW_CREDENTIALS_QNAME.getNamespaceURI(), ALLOW_CREDENTIALS_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        writer.writeCharacters(Boolean.toString(model.isAllowCredentials()));
        this.writeEnd(writer);
        this.writeStart(writer, MAX_AGE_QNAME.getNamespaceURI(), MAX_AGE_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        writer.writeCharacters(Integer.toString(model.getMaxAge()));
        this.writeEnd(writer);
        if (model.getAllowOrigins() != null && !model.getAllowOrigins().isEmpty()) {
            this.writeStart(writer, ALLOW_ORIGINS_QNAME.getNamespaceURI(), ALLOW_ORIGINS_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            for (String origin : model.getAllowOrigins()) {
                this.writeStart(writer, ORIGIN_QNAME.getNamespaceURI(), ORIGIN_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
                writer.writeCharacters(origin);
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        if (model.getAllowMethods() != null && !model.getAllowMethods().isEmpty()) {
            this.writeStart(writer, ALLOW_METHODS_QNAME.getNamespaceURI(), ALLOW_METHODS_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            for (String method : model.getAllowMethods()) {
                this.writeStart(writer, METHOD_QNAME.getNamespaceURI(), METHOD_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
                writer.writeCharacters(method);
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        if (model.getAllowHeaders() != null && !model.getAllowHeaders().isEmpty()) {
            this.writeStart(writer, ALLOW_HEADERS_QNAME.getNamespaceURI(), ALLOW_HEADERS_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            for (String header : model.getAllowHeaders()) {
                this.writeStart(writer, HEADER_QNAME.getNamespaceURI(), HEADER_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
                writer.writeCharacters(header);
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        if (model.getExposeHeaders() != null && !model.getExposeHeaders().isEmpty()) {
            this.writeStart(writer, EXPOSE_HEADERS_QNAME.getNamespaceURI(), EXPOSE_HEADERS_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
            for (String header : model.getExposeHeaders()) {
                this.writeStart(writer, HEADER_QNAME.getNamespaceURI(), HEADER_QNAME.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
                writer.writeCharacters(header);
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        this.writeEnd(writer);
    }

    public void resolve(CORSConfiguration model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }

    static enum HeaderElementType {
        ALLOWHEADERS,
        EXPOSEHEADERS;

    }
}

