/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.plugin.eclipse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseClasspathWriter
extends AbstractEclipseWriter {
    private static final String ORG_ECLIPSE_AJDT_INPATH = "org.eclipse.ajdt.inpath";
    private static final String ORG_ECLIPSE_AJDT_ASPECTPATH = "org.eclipse.ajdt.aspectpath";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATTRIBUTES = "attributes";
    protected static final String M2_REPO = "M2_REPO";
    private static final String ATTR_SOURCEPATH = "sourcepath";
    private static final String ATTR_OUTPUT = "output";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_KIND = "kind";
    private static final String ATTR_VAR = "var";
    private static final String ATTR_LIB = "lib";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_INCLUDING = "including";
    private static final String ATTR_EXCLUDING = "excluding";
    private static final String ELT_CLASSPATHENTRY = "classpathentry";
    private static final String ELT_CLASSPATH = "classpath";
    private static final String FILE_DOT_CLASSPATH = ".classpath";

    public void write() throws MojoExecutionException {
        String depId;
        IdeDependency dep;
        int j;
        EclipseSourceDir dir;
        int j2;
        OutputStreamWriter w;
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.config.getEclipseProjectDirectory(), FILE_DOT_CLASSPATH)), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement(ELT_CLASSPATH);
        String defaultOutput = IdeUtils.toRelativeAndFixSeparator((File)this.config.getProjectBaseDir(), (File)this.config.getBuildOutputDirectory(), (boolean)false);
        ArrayList<EclipseSourceDir> specialSources = new ArrayList<EclipseSourceDir>();
        HashMap<String, ArrayList<EclipseSourceDir>> byOutputDir = new HashMap<String, ArrayList<EclipseSourceDir>>();
        for (j2 = 0; j2 < this.config.getSourceDirs().length; ++j2) {
            dir = this.config.getSourceDirs()[j2];
            ArrayList<EclipseSourceDir> byOutputDirs = (ArrayList<EclipseSourceDir>)byOutputDir.get(dir.getOutput());
            if (byOutputDirs == null) {
                byOutputDirs = new ArrayList<EclipseSourceDir>();
                byOutputDir.put(dir.getOutput() == null ? defaultOutput : dir.getOutput(), byOutputDirs);
            }
            byOutputDirs.add(dir);
        }
        for (j2 = 0; j2 < this.config.getSourceDirs().length; ++j2) {
            dir = this.config.getSourceDirs()[j2];
            this.log.debug((CharSequence)("Processing " + (dir.isResource() ? "re" : "") + "source " + dir.getPath() + ": output=" + dir.getOutput() + "; default output=" + defaultOutput));
            boolean isSpecial = false;
            if (dir.isResource() && dir.getOutput() != null && !dir.getOutput().equals(defaultOutput) && dir.getOutput().startsWith(defaultOutput) && byOutputDir.get(defaultOutput) != null && !((List)byOutputDir.get(defaultOutput)).isEmpty()) {
                this.log.debug((CharSequence)("Marking as special to prevent output folder nesting: " + dir.getPath() + " (output=" + dir.getOutput() + ")"));
                isSpecial = true;
                specialSources.add(dir);
            }
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, ATTR_SRC);
            writer.addAttribute(ATTR_PATH, dir.getPath());
            if (!isSpecial && dir.getOutput() != null && !defaultOutput.equals(dir.getOutput())) {
                writer.addAttribute(ATTR_OUTPUT, dir.getOutput());
            }
            String includes = dir.getInclude();
            if (!dir.isResource()) {
                String string = includes = StringUtils.isEmpty((String)includes) ? "**/*.java" : includes + "|**/*.java";
            }
            if (StringUtils.isNotEmpty((String)includes)) {
                writer.addAttribute(ATTR_INCLUDING, includes);
            }
            String excludes = dir.getExclude();
            if (dir.isResource()) {
                String string = excludes = StringUtils.isEmpty((String)excludes) ? "**/*.java" : excludes + "|**/*.java";
            }
            if (StringUtils.isNotEmpty((String)excludes)) {
                writer.addAttribute(ATTR_EXCLUDING, excludes);
            }
            writer.endElement();
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, ATTR_OUTPUT);
        writer.addAttribute(ATTR_PATH, defaultOutput);
        writer.endElement();
        HashSet<String> addedDependencies = new HashSet<String>();
        IdeDependency[] depsToWrite = this.config.getDepsOrdered();
        for (j = 0; j < depsToWrite.length; ++j) {
            dep = depsToWrite[j];
            if (!dep.isJavaApi() || addedDependencies.contains(depId = this.getDependencyId(dep))) continue;
            this.addDependency((XMLWriter)writer, dep);
            addedDependencies.add(depId);
        }
        for (j = 0; j < depsToWrite.length; ++j) {
            dep = depsToWrite[j];
            if (!dep.isAddedToClasspath() || addedDependencies.contains(depId = this.getDependencyId(dep))) continue;
            this.addDependency((XMLWriter)writer, dep);
            addedDependencies.add(depId);
        }
        Iterator it = this.config.getClasspathContainers().iterator();
        while (it.hasNext()) {
            writer.startElement(ELT_CLASSPATHENTRY);
            writer.addAttribute(ATTR_KIND, "con");
            writer.addAttribute(ATTR_PATH, (String)it.next());
            writer.endElement();
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private String getDependencyId(IdeDependency dep) {
        String depId = dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getClassifier() + ":" + dep.getVersion();
        if (dep.isReferencedProject()) {
            depId = dep.getEclipseProjectName();
        }
        return depId;
    }

    protected void addDependency(XMLWriter writer, IdeDependency dep) throws MojoExecutionException {
        String kind;
        String path;
        String sourcepath = null;
        String javadocpath = null;
        boolean pdeMode = false;
        if (dep.isReferencedProject() && !pdeMode) {
            path = "/" + dep.getEclipseProjectName();
            kind = ATTR_SRC;
        } else {
            if (dep.isReferencedProject() && pdeMode) {
                return;
            }
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString((String)"EclipsePlugin.artifactpathisnull", (Object)dep.getId()));
                return;
            }
            if (dep.isSystemScoped()) {
                path = IdeUtils.toRelativeAndFixSeparator((File)this.config.getEclipseProjectDirectory(), (File)artifactPath, (boolean)false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)Messages.getString((String)"EclipsePlugin.artifactissystemscoped", (Object[])new Object[]{dep.getArtifactId(), path}));
                }
                kind = ATTR_LIB;
            } else {
                File localRepositoryFile = new File(this.config.getLocalRepository().getBasedir());
                if (pdeMode && (dep.isProvided() || dep.isOsgiBundle())) {
                    return;
                }
                if (pdeMode && !dep.isProvided() && !dep.isTestDependency()) {
                    path = dep.getFile().getName();
                    kind = ATTR_LIB;
                } else {
                    String fullPath = artifactPath.getPath();
                    String relativePath = IdeUtils.toRelativeAndFixSeparator((File)localRepositoryFile, (File)new File(fullPath), (boolean)false);
                    if (!new File(relativePath).isAbsolute()) {
                        path = "M2_REPO/" + relativePath;
                        kind = ATTR_VAR;
                    } else {
                        path = relativePath;
                        kind = ATTR_LIB;
                    }
                }
                if (dep.getSourceAttachment() != null) {
                    sourcepath = ATTR_VAR.equals(kind) ? "M2_REPO/" + IdeUtils.toRelativeAndFixSeparator((File)localRepositoryFile, (File)dep.getSourceAttachment(), (boolean)false) : IdeUtils.getCanonicalPath((File)dep.getSourceAttachment());
                }
                if (dep.getJavadocAttachment() != null) {
                    javadocpath = StringUtils.replace((String)IdeUtils.getCanonicalPath((File)dep.getJavadocAttachment()), (String)"\\", (String)"/");
                }
            }
        }
        if (this.config.getAjdtVersion() != 0.0f && dep.getArtifactId().toLowerCase().startsWith("aspectj")) {
            return;
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, kind);
        writer.addAttribute(ATTR_PATH, path);
        if (sourcepath != null) {
            writer.addAttribute(ATTR_SOURCEPATH, sourcepath);
        }
        boolean attributeElemOpen = false;
        if (javadocpath != null) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(VALUE, "jar:" + new File(javadocpath).toURI() + "!/");
            writer.addAttribute(NAME, "javadoc_location");
            writer.endElement();
        }
        if ("war".equals(this.config.getPackaging()) && this.config.getWtpapplicationxml() && kind.equals(ATTR_VAR) && !dep.isTestDependency() && !dep.isProvided() && !dep.isSystemScopedOutsideProject(this.config.getProject())) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(VALUE, "/WEB-INF/lib");
            writer.addAttribute(NAME, "org.eclipse.jst.component.dependency");
            writer.endElement();
        }
        if (dep.isAjdtDependency() && (double)this.config.getAjdtVersion() >= 1.5) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(NAME, ORG_ECLIPSE_AJDT_ASPECTPATH);
            writer.addAttribute(VALUE, Boolean.TRUE.toString());
            writer.endElement();
        }
        if (dep.isAjdtWeaveDependency() && (double)this.config.getAjdtVersion() >= 1.5) {
            if (!attributeElemOpen) {
                writer.startElement(ATTRIBUTES);
                attributeElemOpen = true;
            }
            writer.startElement(ATTRIBUTE);
            writer.addAttribute(NAME, ORG_ECLIPSE_AJDT_INPATH);
            writer.addAttribute(VALUE, Boolean.TRUE.toString());
            writer.endElement();
        }
        if (attributeElemOpen) {
            writer.endElement();
        }
        writer.endElement();
    }
}

