/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.plugin.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tuscany.maven.bundle.plugin.BundleUtil;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractIdeSupportMojo
extends AbstractMojo
implements LogEnabled {
    protected boolean pde;
    protected MavenProject project;
    protected MavenProject executedProject;
    protected String packaging;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactCollector artifactCollector;
    protected ArtifactMetadataSource artifactMetadataSource;
    private RuntimeInformation runtimeInformation;
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected List reactorProjects;
    private boolean skip;
    protected boolean downloadSources;
    protected boolean downloadJavadocs;
    protected boolean forceRecheck;
    protected Logger logger;
    private List missingSourceDependencies = new ArrayList();
    private List missingJavadocDependencies = new ArrayList();
    private IdeDependency[] ideDeps;
    private boolean resolveDependencies = true;

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource artifactMetadataSource) {
        this.artifactMetadataSource = artifactMetadataSource;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List getReactorProjects() {
        return this.reactorProjects;
    }

    public void setReactorProjects(List reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    public List getRemoteArtifactRepositories() {
        return this.remoteArtifactRepositories;
    }

    public void setRemoteArtifactRepositories(List remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public MavenProject getExecutedProject() {
        return this.executedProject;
    }

    public void setExecutedProject(MavenProject executedProject) {
        this.executedProject = executedProject;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public boolean getDownloadJavadocs() {
        return this.downloadJavadocs;
    }

    public void setDownloadJavadocs(boolean downloadJavadoc) {
        this.downloadJavadocs = downloadJavadoc;
    }

    public boolean getDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    protected void setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
    }

    protected boolean isResolveDependencies() {
        return this.resolveDependencies;
    }

    protected abstract boolean getUseProjectReferences();

    protected abstract boolean setup() throws MojoExecutionException;

    protected abstract void writeConfiguration(IdeDependency[] var1) throws MojoExecutionException;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        boolean processProject = this.setup();
        if (!processProject) {
            return;
        }
        IdeDependency[] deps = this.doDependencyResolution();
        this.resolveSourceAndJavadocArtifacts(deps);
        this.writeConfiguration(deps);
        this.reportMissingArtifacts();
    }

    protected IdeDependency[] doDependencyResolution() throws MojoExecutionException {
        if (this.ideDeps == null) {
            if (this.resolveDependencies) {
                MavenProject project = this.getProject();
                Set<Object> imported = Collections.emptySet();
                try {
                    imported = BundleUtil.getImportedPackages(project.getBasedir());
                }
                catch (IOException e1) {
                    throw new MojoExecutionException(e1.getMessage(), (Exception)e1);
                }
                ArtifactRepository localRepo = this.getLocalRepository();
                List deps = this.getProject().getDependencies();
                ArrayList<IdeDependency> dependencies = new ArrayList<IdeDependency>();
                if (deps != null) {
                    Map managedVersions = this.createManagedVersionMap(this.getArtifactFactory(), project.getId(), project.getDependencyManagement());
                    ArtifactResolutionResult artifactResolutionResult = null;
                    try {
                        ArrayList<Object> listeners = new ArrayList<Object>();
                        if (this.logger.isDebugEnabled()) {
                            listeners.add(new DebugResolutionListener(this.logger));
                        }
                        listeners.add(new WarningResolutionListener(this.logger));
                        artifactResolutionResult = this.artifactCollector.collect(this.getProjectArtifacts(), project.getArtifact(), managedVersions, localRepo, project.getRemoteArtifactRepositories(), this.getArtifactMetadataSource(), null, listeners);
                    }
                    catch (ArtifactResolutionException e) {
                        this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                        this.getLog().error((CharSequence)Messages.getString((String)"AbstractIdeSupportMojo.artifactresolution", (Object[])new Object[]{e.getGroupId(), e.getArtifactId(), e.getVersion(), e.getMessage()}));
                        return new IdeDependency[0];
                    }
                    HashSet<String> emittedReactorProjectId = new HashSet<String>();
                    for (ResolutionNode node : artifactResolutionResult.getArtifactResolutionNodes()) {
                        int dependencyDepth = node.getDepth();
                        Artifact art = node.getArtifact();
                        if (this.hasToResolveJar(art)) {
                            try {
                                this.artifactResolver.resolve(art, node.getRemoteRepositories(), this.localRepository);
                            }
                            catch (ArtifactNotFoundException e) {
                                this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                                this.getLog().warn((CharSequence)Messages.getString((String)"AbstractIdeSupportMojo.artifactdownload", (Object[])new Object[]{e.getGroupId(), e.getArtifactId(), e.getVersion(), e.getMessage()}));
                            }
                            catch (ArtifactResolutionException e) {
                                this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                                this.getLog().warn((CharSequence)Messages.getString((String)"AbstractIdeSupportMojo.artifactresolution", (Object[])new Object[]{e.getGroupId(), e.getArtifactId(), e.getVersion(), e.getMessage()}));
                            }
                        }
                        boolean includeArtifact = true;
                        if (this.getExcludes() != null) {
                            String artifactFullId = art.getGroupId() + ":" + art.getArtifactId();
                            if (this.getExcludes().contains(artifactFullId)) {
                                this.getLog().info((CharSequence)("excluded: " + artifactFullId));
                                includeArtifact = false;
                            }
                        }
                        if (!includeArtifact || this.getUseProjectReferences() && this.isAvailableAsAReactorProject(art) && !emittedReactorProjectId.add(art.getGroupId() + '-' + art.getArtifactId()) || "pom".equals(art.getType())) continue;
                        File artifactFile = art.getFile();
                        MavenProject reactorProject = this.getReactorProject(art);
                        if (reactorProject != null) {
                            artifactFile = reactorProject.getBasedir();
                        }
                        boolean isOsgiBundle = false;
                        String osgiSymbolicName = null;
                        try {
                            osgiSymbolicName = BundleUtil.getBundleSymbolicName(artifactFile);
                        }
                        catch (IOException e) {
                            this.getLog().error((CharSequence)("Unable to read jar manifest from " + artifactFile), (Throwable)e);
                        }
                        boolean bl = isOsgiBundle = osgiSymbolicName != null;
                        IdeDependency dep = new IdeDependency(art.getGroupId(), art.getArtifactId(), art.getVersion(), art.getClassifier(), this.useProjectReference(art), "test".equals(art.getScope()), "system".equals(art.getScope()), "provided".equals(art.getScope()), art.getArtifactHandler().isAddedToClasspath(), art.getFile(), art.getType(), isOsgiBundle, osgiSymbolicName, dependencyDepth, this.getProjectNameForArifact(art));
                        if (dependencies.contains(dep)) continue;
                        if (!this.pde || !"compile".equals(art.getScope()) && !"provided".equals(art.getScope())) {
                            dependencies.add(dep);
                            continue;
                        }
                        if (!imported.isEmpty()) {
                            Set<Object> exported = Collections.emptySet();
                            try {
                                exported = BundleUtil.getExportedPackages(artifactFile);
                            }
                            catch (IOException e) {
                                this.getLog().error((CharSequence)("Unable to read jar manifest from " + art.getFile()), (Throwable)e);
                            }
                            boolean matched = false;
                            for (String string : imported) {
                                if (!exported.contains(string)) continue;
                                matched = true;
                                break;
                            }
                            if (!matched) {
                                dependencies.add(dep);
                                continue;
                            }
                            this.getLog().debug((CharSequence)("Compile dependency is skipped as it is added through OSGi dependency: " + art));
                            continue;
                        }
                        dependencies.add(dep);
                    }
                }
                this.ideDeps = dependencies.toArray(new IdeDependency[dependencies.size()]);
            } else {
                this.ideDeps = new IdeDependency[0];
            }
        }
        return this.ideDeps;
    }

    public abstract String getProjectNameForArifact(Artifact var1);

    private Set getProjectArtifacts() throws MojoExecutionException {
        TreeSet<Artifact> artifacts = new TreeSet<Artifact>();
        for (Dependency dependency : this.getProject().getDependencies()) {
            VersionRange versionRange;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException(Messages.getString((String)"AbstractIdeSupportMojo.unabletoparseversion", (Object[])new Object[]{dependency.getArtifactId(), dependency.getVersion(), dependency.getManagementKey(), e.getMessage()}), (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact art = this.getArtifactFactory().createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion e : dependency.getExclusions()) {
                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            art.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(art);
        }
        return artifacts;
    }

    protected boolean isAvailableAsAReactorProject(Artifact artifact) {
        return this.getReactorProject(artifact) != null;
    }

    protected MavenProject getReactorProject(Artifact artifact) {
        if (this.reactorProjects != null) {
            for (MavenProject reactorProject : this.reactorProjects) {
                if (!reactorProject.getGroupId().equals(artifact.getGroupId()) || !reactorProject.getArtifactId().equals(artifact.getArtifactId())) continue;
                if (reactorProject.getVersion().equals(artifact.getVersion())) {
                    return reactorProject;
                }
                this.getLog().info((CharSequence)("Artifact " + artifact.getId() + " already available as a reactor project, but with different version. Expected: " + artifact.getVersion() + ", found: " + reactorProject.getVersion()));
            }
        }
        return null;
    }

    protected IdeDependency[] getWorkspaceArtefacts() {
        return new IdeDependency[0];
    }

    private Map createManagedVersionMap(ArtifactFactory artifactFactory, String projectId, DependencyManagement dependencyManagement) throws MojoExecutionException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new MojoExecutionException(Messages.getString((String)"AbstractIdeSupportMojo.unabletoparseversion", (Object[])new Object[]{projectId, d.getVersion(), d.getManagementKey(), e.getMessage()}), (Exception)((Object)e));
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    private void resolveSourceAndJavadocArtifacts(IdeDependency[] deps) {
        List missingSources = this.resolveDependenciesWithClassifier(deps, "sources", this.getDownloadSources());
        this.missingSourceDependencies.addAll(missingSources);
        List missingJavadocs = this.resolveDependenciesWithClassifier(deps, "javadoc", this.getDownloadJavadocs());
        this.missingJavadocDependencies.addAll(missingJavadocs);
    }

    private List resolveDependenciesWithClassifier(IdeDependency[] deps, String inClassifier, boolean includeRemoteRepositories) {
        ArrayList<IdeDependency> missingClassifierDependencies = new ArrayList<IdeDependency>();
        List remoteRepos = includeRemoteRepositories ? this.getRemoteArtifactRepositories() : Collections.EMPTY_LIST;
        for (int j = 0; j < deps.length; ++j) {
            IdeDependency dependency = deps[j];
            if (dependency.isReferencedProject() || dependency.isSystemScoped()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Searching for sources for " + dependency.getId() + ":" + dependency.getClassifier() + " at " + dependency.getId() + ":" + inClassifier));
            }
            Artifact baseArtifact = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
            if (!(baseArtifact = IdeUtils.resolveArtifact((ArtifactResolver)this.artifactResolver, (Artifact)baseArtifact, (List)remoteRepos, (ArtifactRepository)this.localRepository, (Log)this.getLog())).isResolved()) continue;
            Artifact artifact = IdeUtils.createArtifactWithClassifier((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion(), (String)dependency.getClassifier(), (String)inClassifier, (ArtifactFactory)this.artifactFactory);
            File notAvailableMarkerFile = IdeUtils.getNotAvailableMarkerFile((ArtifactRepository)this.localRepository, (Artifact)artifact);
            if (this.forceRecheck && notAvailableMarkerFile.exists() && !notAvailableMarkerFile.delete()) {
                this.getLog().warn((CharSequence)Messages.getString((String)"AbstractIdeSupportMojo.unabletodeletenotavailablemarkerfile", (Object)notAvailableMarkerFile));
            }
            if (notAvailableMarkerFile.exists()) continue;
            if ((artifact = IdeUtils.resolveArtifact((ArtifactResolver)this.artifactResolver, (Artifact)artifact, (List)remoteRepos, (ArtifactRepository)this.localRepository, (Log)this.getLog())).isResolved()) {
                if ("sources".equals(inClassifier)) {
                    dependency.setSourceAttachment(artifact.getFile());
                    continue;
                }
                if (!"javadoc".equals(inClassifier)) continue;
                dependency.setJavadocAttachment(artifact.getFile());
                continue;
            }
            if (includeRemoteRepositories) {
                try {
                    notAvailableMarkerFile.createNewFile();
                    this.getLog().debug((CharSequence)Messages.getString((String)"AbstractIdeSupportMojo.creatednotavailablemarkerfile", (Object)notAvailableMarkerFile));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)Messages.getString((String)"AbstractIdeSupportMojo.failedtocreatenotavailablemarkerfile", (Object)notAvailableMarkerFile));
                }
            }
            missingClassifierDependencies.add(dependency);
        }
        return missingClassifierDependencies;
    }

    private void reportMissingArtifacts() {
        StringBuffer msg = new StringBuffer();
        if (!this.missingSourceDependencies.isEmpty()) {
            if (this.getDownloadSources()) {
                msg.append(Messages.getString((String)"AbstractIdeSupportMojo.sourcesnotavailable"));
            } else {
                msg.append(Messages.getString((String)"AbstractIdeSupportMojo.sourcesnotdownloaded"));
            }
            for (IdeDependency art : this.missingSourceDependencies) {
                msg.append(Messages.getString((String)"AbstractIdeSupportMojo.sourcesmissingitem", (Object)art.getId()));
            }
            msg.append("\n");
        }
        if (!this.missingJavadocDependencies.isEmpty()) {
            if (this.getDownloadJavadocs()) {
                msg.append(Messages.getString((String)"AbstractIdeSupportMojo.javadocnotavailable"));
            } else {
                msg.append(Messages.getString((String)"AbstractIdeSupportMojo.javadocnotdownloaded"));
            }
            for (IdeDependency art : this.missingJavadocDependencies) {
                msg.append(Messages.getString((String)"AbstractIdeSupportMojo.javadocmissingitem", (Object)art.getId()));
            }
            msg.append("\n");
        }
        this.getLog().info((CharSequence)msg);
    }

    public abstract List getExcludes();

    protected boolean hasToResolveJar(Artifact art) {
        return !this.getUseProjectReferences() || !this.isAvailableAsAReactorProject(art);
    }

    protected boolean useProjectReference(Artifact art) {
        return this.getUseProjectReferences() && this.isAvailableAsAReactorProject(art);
    }

    protected boolean isMavenVersion(String version) {
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)version);
            ArtifactVersion mavenVersion = this.runtimeInformation.getApplicationVersion();
            return versionRange.containsVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected boolean isOSGiBundle() {
        File base = this.project.getBasedir();
        File mf = new File(base, "META-INF/MANIFEST.MF");
        if (mf.isFile()) {
            String bundleName;
            Manifest manifest = null;
            try {
                FileInputStream is = new FileInputStream(mf);
                manifest = new Manifest(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (manifest != null && (bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                return true;
            }
        }
        return false;
    }
}

