/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.bundle.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tuscany.maven.bundle.plugin.BundleUtil;

public class ThirdPartyBundleBuildMojo
extends AbstractMojo {
    private MavenProject project;
    private String symbolicName;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        String projectGroupId = this.project.getGroupId();
        HashSet<File> jarFiles = new HashSet<File>();
        for (Object o : this.project.getArtifacts()) {
            Artifact artifact = (Artifact)o;
            if (!"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((CharSequence)("Skipping artifact: " + artifact));
                continue;
            }
            if (!"jar".equals(artifact.getType()) || projectGroupId.equals(artifact.getGroupId())) continue;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Artifact: " + artifact));
            }
            String bundleName = null;
            try {
                bundleName = BundleUtil.getBundleSymbolicName(artifact.getFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            if (bundleName != null) {
                // empty if block
            }
            if (artifact.getFile().exists()) {
                log.info((CharSequence)("Adding third party jar: " + artifact));
                jarFiles.add(artifact.getFile());
                continue;
            }
            log.warn((CharSequence)("Third party jar not found: " + artifact));
        }
        try {
            String version = BundleUtil.osgiVersion(this.project.getVersion());
            Manifest mf = BundleUtil.libraryManifest(jarFiles, this.project.getName(), this.symbolicName, version, "lib");
            File file = new File(this.project.getBasedir(), "META-INF");
            file.mkdir();
            file = new File(file, "MANIFEST.MF");
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Generating " + file));
            }
            FileOutputStream fos = new FileOutputStream(file);
            BundleUtil.write(mf, fos);
            fos.close();
            File lib = new File(this.project.getBasedir(), "lib");
            if (lib.isDirectory()) {
                for (File c : lib.listFiles()) {
                    c.delete();
                }
            }
            lib.mkdir();
            byte[] buf = new byte[4096];
            for (File jar : jarFiles) {
                int len;
                File jarFile = new File(lib, jar.getName());
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Copying " + jar + " to " + jarFile));
                }
                FileInputStream in = new FileInputStream(jar);
                FileOutputStream out = new FileOutputStream(jarFile);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

