/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.bundle.plugin;

import java.util.StringTokenizer;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class OSGIArtifactVersion
implements ArtifactVersion {
    private Integer buildNumber;
    private Integer incrementalVersion;
    private Integer majorVersion;
    private Integer minorVersion;
    private String qualifier;
    private String unparsed;

    public OSGIArtifactVersion(String version) {
        this.parseVersion(version);
    }

    public int compareTo(Object o) {
        ArtifactVersion otherVersion = (ArtifactVersion)o;
        int result = this.getMajorVersion() - otherVersion.getMajorVersion();
        if (result == 0) {
            result = this.getMinorVersion() - otherVersion.getMinorVersion();
        }
        if (result == 0) {
            result = this.getIncrementalVersion() - otherVersion.getIncrementalVersion();
        }
        if (result == 0) {
            String otherQualifier;
            result = this.qualifier != null ? ((otherQualifier = otherVersion.getQualifier()) != null ? (this.qualifier.length() > otherQualifier.length() && this.qualifier.startsWith(otherQualifier) ? -1 : (this.qualifier.length() < otherQualifier.length() && otherQualifier.startsWith(this.qualifier) ? 1 : this.qualifier.compareTo(otherQualifier))) : -1) : (otherVersion.getQualifier() != null ? 1 : this.getBuildNumber() - otherVersion.getBuildNumber());
        }
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactVersion)) {
            return false;
        }
        return 0 == this.compareTo(other);
    }

    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    public int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        int result = 1229;
        result = 1223 * result + this.getMajorVersion();
        result = 1223 * result + this.getMinorVersion();
        result = 1223 * result + this.getIncrementalVersion();
        result = 1223 * result + this.getBuildNumber();
        if (null != this.getQualifier()) {
            result = 1223 * result + this.getQualifier().hashCode();
        }
        return result;
    }

    public final void parseVersion(String version) {
        String part1;
        this.unparsed = version;
        int index = version.indexOf("-");
        String part2 = null;
        if (index < 0) {
            part1 = version;
        } else {
            part1 = version.substring(0, index);
            part2 = version.substring(index + 1);
        }
        if (part2 != null) {
            try {
                if (part2.length() == 1 || !part2.startsWith("0")) {
                    this.buildNumber = Integer.valueOf(part2);
                } else {
                    this.qualifier = part2;
                }
            }
            catch (NumberFormatException e) {
                this.qualifier = part2;
            }
        }
        if (part1.indexOf(".") < 0 && !part1.startsWith("0")) {
            try {
                this.majorVersion = Integer.valueOf(part1);
            }
            catch (NumberFormatException e) {
                this.qualifier = version;
                this.buildNumber = null;
            }
        } else {
            StringTokenizer tok;
            block20: {
                tok = new StringTokenizer(part1, ".");
                if (tok.hasMoreTokens()) {
                    String s = tok.nextToken();
                    try {
                        this.majorVersion = Integer.valueOf(s);
                        if (!tok.hasMoreTokens()) break block20;
                        s = tok.nextToken();
                        try {
                            this.minorVersion = Integer.valueOf(s);
                            if (!tok.hasMoreTokens()) break block20;
                            s = tok.nextToken();
                            try {
                                this.incrementalVersion = Integer.valueOf(s);
                            }
                            catch (NumberFormatException e) {
                                this.qualifier = s;
                            }
                        }
                        catch (NumberFormatException e) {
                            this.qualifier = s;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.qualifier = s;
                    }
                }
            }
            if (tok.hasMoreTokens()) {
                StringBuffer qualifier = new StringBuffer(this.qualifier != null ? this.qualifier : "");
                qualifier.append(tok.nextToken());
                while (tok.hasMoreTokens()) {
                    qualifier.append("_");
                    qualifier.append(tok.nextToken());
                }
                this.qualifier = qualifier.toString();
            }
        }
    }

    public String toString() {
        return this.unparsed;
    }
}

