/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.bundle.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.tuscany.maven.bundle.plugin.ArtifactAggregation;
import org.apache.tuscany.maven.bundle.plugin.ArtifactManifest;
import org.apache.tuscany.maven.bundle.plugin.BundleAggregatorMojo;
import org.apache.tuscany.maven.bundle.plugin.BundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBundlesBuildMojo
extends AbstractMojo {
    private static final String GATEWAY_BUNDLE = "org.apache.tuscany.sca.gateway";
    private MavenProject project;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory factory;
    private ArtifactResolver resolver;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactRepository local;
    private List remoteRepos;
    private File targetDirectory;
    private String featuresName = "features";
    private File[] excludeDirectories;
    private String[] excludeGroupIds;
    private String[] includeGroupIds;
    private boolean useDistributionName = true;
    private boolean generateTargetPlatform = true;
    private boolean expandThirdPartyBundle = false;
    private String executionEnvironment;
    private String[] eclipseFeatures;
    private boolean useDefaultLocation = true;
    private boolean generateGatewayBundle;
    private boolean gatewayReexport;
    private boolean generatePlugin;
    private boolean generateConfig = true;
    private boolean generateAggregatedBundle = false;
    private boolean generateBundleStart = true;
    private boolean includeConflictingDepedencies = true;
    private boolean generateManifestJar = true;
    private String manifestJarName = "tuscany-sca-manifest.jar";
    private String equinoxManifestJarName = "tuscany-sca-equinox-manifest.jar";
    private String artifactTypes;
    private boolean generateAntScript = true;
    private ArtifactAggregation[] artifactAggregations;
    private ArtifactManifest[] artifactManifests;
    private String eclipseBuddyPolicy = null;
    private static final String XML_PI = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String ASL_HEADER = "<!--\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n * \n *   http://www.apache.org/licenses/LICENSE-2.0\n * \n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n-->";

    private Manifest findManifest(Artifact artifact) throws IOException {
        if (this.artifactManifests == null) {
            return null;
        }
        for (ArtifactManifest m : this.artifactManifests) {
            if (!m.matches(artifact)) continue;
            File mf = m.getManifestFile();
            if (mf != null) {
                FileInputStream is = new FileInputStream(mf);
                Manifest manifest = new Manifest(is);
                is.close();
                this.getLog().info((CharSequence)("MANIFEST.MF found for " + artifact + " (" + mf + ")"));
                return manifest;
            }
            this.getLog().info((CharSequence)("Overriding the manifest for " + artifact));
            Manifest manifest = BundleUtil.getManifest(artifact.getFile());
            HashSet<File> jarFiles = new HashSet<File>();
            jarFiles.add(artifact.getFile());
            String symbolicName = BundleUtil.getBundleSymbolicName(manifest);
            if (symbolicName == null) continue;
            String version = manifest.getMainAttributes().getValue("Bundle-Version");
            manifest = BundleUtil.libraryManifest(jarFiles, symbolicName, symbolicName, version, null, this.eclipseBuddyPolicy, this.executionEnvironment);
            manifest.getMainAttributes().remove(new Attributes.Name("Bundle-ClassPath"));
            return manifest;
        }
        return null;
    }

    private ArtifactFilter createResolvingArtifactFilter(String scope) {
        ScopeArtifactFilter filter;
        if (scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + scope + "'"));
            filter = new ScopeArtifactFilter(scope);
        } else {
            filter = null;
        }
        return filter;
    }

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        Set<Artifact> artifacts = null;
        if (this.includeConflictingDepedencies) {
            try {
                artifacts = this.getDependencyArtifacts(this.project);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        } else {
            artifacts = this.project.getArtifacts();
        }
        try {
            File root = this.targetDirectory == null ? new File(this.project.getBuild().getDirectory(), "plugins/") : this.targetDirectory;
            root.mkdirs();
            HashSet<String> excludedFileNames = new HashSet<String>();
            if (this.excludeDirectories != null) {
                for (File f : this.excludeDirectories) {
                    if (!f.isDirectory()) continue;
                    for (String n : f.list()) {
                        excludedFileNames.add(n);
                    }
                }
            }
            HashSet<String> includedGroupIds = new HashSet<String>();
            if (this.includeGroupIds != null) {
                for (String g : this.includeGroupIds) {
                    includedGroupIds.add(g);
                }
            }
            HashSet<String> excludedGroupIds = new HashSet<String>();
            if (this.excludeGroupIds != null) {
                for (String g : this.excludeGroupIds) {
                    excludedGroupIds.add(g);
                }
            }
            ArrayList<MavenProject> poms = new ArrayList<MavenProject>();
            poms.add(this.project);
            if (this.useDistributionName) {
                for (Object o : this.project.getArtifacts()) {
                    Artifact artifact = (Artifact)o;
                    if (!"pom".equals(artifact.getType()) || !artifact.getGroupId().equals(this.project.getGroupId()) || !artifact.getArtifactId().startsWith("tuscany-feature-")) continue;
                    log.info((CharSequence)("Dependent distribution: " + artifact));
                    MavenProject pomProject = this.buildProject(artifact);
                    poms.add(pomProject);
                }
            }
            ProjectSet bundleSymbolicNames = new ProjectSet(poms);
            ProjectSet bundleLocations = new ProjectSet(poms);
            ProjectSet jarNames = new ProjectSet(poms);
            ProjectSet serviceProviders = new ProjectSet(poms);
            for (Artifact artifact : artifacts) {
                File dir;
                String dirName;
                int index;
                String[] types;
                HashSet<String> typeSet;
                if (!("compile".equals(artifact.getScope()) || "runtime".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || this.generateTargetPlatform && "test".equals(artifact.getScope()))) {
                    log.info((CharSequence)("Skipping artifact: " + artifact));
                    continue;
                }
                if (this.artifactTypes == null) {
                    this.artifactTypes = "jar,bundle";
                }
                if (!(typeSet = new HashSet<String>(Arrays.asList(types = this.artifactTypes.trim().split("( |\t|\n|\r|\f|,)+")))).contains(artifact.getType())) {
                    log.debug((CharSequence)("Artifact with unknown type is skipped: " + artifact));
                    continue;
                }
                if (excludedGroupIds.contains(artifact.getGroupId())) {
                    log.debug((CharSequence)("Artifact groupId is excluded: " + artifact));
                    continue;
                }
                if (!includedGroupIds.isEmpty() && !includedGroupIds.contains(artifact.getGroupId())) {
                    log.debug((CharSequence)("Artifact groupId is not included: " + artifact));
                    continue;
                }
                File artifactFile = artifact.getFile();
                if (!artifactFile.exists()) {
                    log.warn((CharSequence)("Artifact doesn't exist: " + artifact));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Processing artifact: " + artifact));
                }
                Manifest customizedMF = this.findManifest(artifact);
                Manifest mf = null;
                String bundleName = null;
                try {
                    mf = BundleUtil.getManifest(artifactFile);
                    bundleName = BundleUtil.getBundleSymbolicName(mf);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                if (bundleName != null && customizedMF == null) {
                    if (excludedFileNames.contains(artifactFile.getName())) {
                        log.debug((CharSequence)("Artifact file is excluded: " + artifact));
                        continue;
                    }
                    log.info((CharSequence)("Adding OSGi bundle artifact: " + artifact));
                    if (!this.expandThirdPartyBundle || artifact.getGroupId().startsWith("org.apache.tuscany.sca") || artifact.getGroupId().startsWith("org.eclipse")) {
                        ModuleBundlesBuildMojo.copyFile(artifactFile, root);
                        bundleSymbolicNames.add(artifact, bundleName);
                        bundleLocations.add(artifact, artifactFile.getName());
                        jarNames.add(artifact, artifactFile.getName());
                        if (!ModuleBundlesBuildMojo.isServiceProvider(mf)) continue;
                        serviceProviders.add(artifact, bundleName);
                        continue;
                    }
                    this.setBundleClassPath(mf, artifactFile);
                    index = artifactFile.getName().lastIndexOf(46);
                    dirName = artifactFile.getName().substring(0, index);
                    dir = new File(root, dirName);
                    File file = new File(dir, "META-INF");
                    file.mkdirs();
                    file = new File(file, "MANIFEST.MF");
                    FileOutputStream fos = new FileOutputStream(file);
                    BundleUtil.write(mf, fos);
                    fos.close();
                    ModuleBundlesBuildMojo.copyFile(artifactFile, dir);
                    bundleSymbolicNames.add(artifact, bundleName);
                    bundleLocations.add(artifact, dir.getName());
                    jarNames.add(artifact, dirName + "/" + artifactFile.getName());
                    if (!ModuleBundlesBuildMojo.isServiceProvider(mf)) continue;
                    serviceProviders.add(artifact, bundleName);
                    continue;
                }
                if ("war".equals(artifact.getType())) {
                    if (excludedFileNames.contains(artifactFile.getName())) {
                        log.debug((CharSequence)("Artifact file is excluded: " + artifact));
                        continue;
                    }
                    log.info((CharSequence)("Adding WAR artifact: " + artifact));
                    ModuleBundlesBuildMojo.copyFile(artifactFile, root);
                    continue;
                }
                index = artifactFile.getName().lastIndexOf(46);
                dirName = artifactFile.getName().substring(0, index);
                dir = new File(root, dirName);
                if (excludedFileNames.contains(dir.getName())) {
                    log.debug((CharSequence)("Artifact file is excluded: " + artifact));
                    continue;
                }
                if (this.artifactAggregations != null) {
                    boolean aggregated = false;
                    for (ArtifactAggregation group : this.artifactAggregations) {
                        if (!group.matches(artifact)) continue;
                        group.getArtifacts().add(artifact);
                        aggregated = true;
                        break;
                    }
                    if (aggregated) continue;
                }
                log.info((CharSequence)("Adding JAR artifact: " + artifact));
                File file = new File(dir, "META-INF");
                file.mkdirs();
                String symbolicName = null;
                if (customizedMF == null) {
                    String version = BundleUtil.osgiVersion(artifact.getVersion());
                    HashSet<File> jarFiles = new HashSet<File>();
                    jarFiles.add(artifactFile);
                    symbolicName = artifact.getGroupId() + "." + artifact.getArtifactId();
                    mf = BundleUtil.libraryManifest(jarFiles, symbolicName, symbolicName, version, null, this.eclipseBuddyPolicy, this.executionEnvironment);
                    file = new File(file, "MANIFEST.MF");
                    FileOutputStream fos = new FileOutputStream(file);
                    BundleUtil.write(mf, fos);
                    fos.close();
                    log.info((CharSequence)("Writing generated manifest for: " + artifact + " to " + file));
                } else {
                    mf = customizedMF;
                    symbolicName = BundleUtil.getBundleSymbolicName(mf);
                    if (symbolicName == null) {
                        throw new MojoExecutionException("Invalid customized MANIFEST.MF for " + artifact);
                    }
                    this.setBundleClassPath(mf, artifactFile);
                    File artifactManifest = null;
                    if (this.artifactManifests != null) {
                        for (ArtifactManifest m : this.artifactManifests) {
                            if (!m.matches(artifact)) continue;
                            artifactManifest = m.getManifestFile();
                            break;
                        }
                    }
                    file = new File(file, "MANIFEST.MF");
                    if (artifactManifest != null) {
                        log.info((CharSequence)("Copying: " + artifactManifest + " to " + file));
                        ModuleBundlesBuildMojo.copyManifest(artifactManifest, file);
                    } else {
                        FileOutputStream fos = new FileOutputStream(file);
                        BundleUtil.write(mf, fos);
                        fos.close();
                        log.info((CharSequence)("Writing generated manifest for: " + artifact + " to " + file));
                    }
                }
                ModuleBundlesBuildMojo.copyFile(artifactFile, dir);
                bundleSymbolicNames.add(artifact, symbolicName);
                bundleLocations.add(artifact, dir.getName());
                jarNames.add(artifact, dirName + "/" + artifactFile.getName());
                if (!ModuleBundlesBuildMojo.isServiceProvider(mf)) continue;
                serviceProviders.add(artifact, symbolicName);
            }
            if (this.artifactAggregations != null) {
                for (ArtifactAggregation group : this.artifactAggregations) {
                    if (group.getArtifacts().isEmpty()) continue;
                    String symbolicName = group.getSymbolicName();
                    String version = group.getVersion();
                    File dir = new File(root, symbolicName + "-" + version);
                    dir.mkdir();
                    HashSet<File> jarFiles = new HashSet<File>();
                    Artifact artifact = null;
                    for (Artifact a : group.getArtifacts()) {
                        log.info((CharSequence)("Aggragating JAR artifact: " + a));
                        artifact = a;
                        jarFiles.add(a.getFile());
                        ModuleBundlesBuildMojo.copyFile(a.getFile(), dir);
                        jarNames.add(a, symbolicName + "-" + version + "/" + a.getFile().getName());
                    }
                    Manifest mf = BundleUtil.libraryManifest(jarFiles, symbolicName, symbolicName, version, null, this.eclipseBuddyPolicy, this.executionEnvironment);
                    File file = new File(dir, "META-INF");
                    file.mkdirs();
                    file = new File(file, "MANIFEST.MF");
                    FileOutputStream fos = new FileOutputStream(file);
                    BundleUtil.write(mf, fos);
                    fos.close();
                    log.info((CharSequence)"Written aggregate manifest");
                    bundleSymbolicNames.add(artifact, symbolicName);
                    bundleLocations.add(artifact, dir.getName());
                    if (!ModuleBundlesBuildMojo.isServiceProvider(mf)) continue;
                    serviceProviders.add(artifact, symbolicName);
                }
            }
            if (this.generateGatewayBundle) {
                this.generateGatewayBundle(serviceProviders);
            }
            if (this.generateTargetPlatform) {
                this.generatePDETarget(bundleSymbolicNames, root, log);
            }
            if (this.generatePlugin) {
                File pluginxml = new File(this.project.getBasedir(), "plugin.xml");
                FileOutputStream pluginXMLFile = new FileOutputStream(pluginxml);
                ModuleBundlesBuildMojo.writePluginXML(new PrintStream(pluginXMLFile));
                pluginXMLFile.close();
            }
            if (this.generateConfig) {
                this.generateEquinoxConfig(bundleLocations, root, log);
            }
            if (this.generateManifestJar) {
                this.generateManifestJar(jarNames, root, log);
                this.generateEquinoxLauncherManifestJar(jarNames, root, log);
            }
            if (this.generateAntScript) {
                this.generateANTPath(jarNames, root, log);
            }
            if (this.generateAggregatedBundle) {
                this.generateAggregatedBundles(bundleLocations, root, log);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private Set<Artifact> getDependencyArtifacts(MavenProject project) throws DependencyTreeBuilderException, ArtifactResolutionException, ArtifactNotFoundException {
        Artifact artifact;
        int state;
        DependencyNode depNode;
        Log log = this.getLog();
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        ArtifactFilter artifactFilter = this.createResolvingArtifactFilter("runtime");
        DependencyNode rootNode = this.dependencyTreeBuilder.buildDependencyTree(project, this.local, this.factory, this.artifactMetadataSource, artifactFilter, this.artifactCollector);
        CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
        rootNode.accept((DependencyNodeVisitor)visitor);
        for (Object node : visitor.getNodes()) {
            depNode = (DependencyNode)node;
            state = depNode.getState();
            if (state != 0 || (artifact = depNode.getArtifact()).equals(project.getArtifact())) continue;
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
            artifacts.add(artifact);
        }
        for (Object node : visitor.getNodes()) {
            DefaultArtifactVersion v2;
            DefaultArtifactVersion v1;
            depNode = (DependencyNode)node;
            state = depNode.getState();
            if (state != 2) continue;
            artifact = depNode.getArtifact();
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
            if (state != 2) continue;
            Artifact related = depNode.getRelatedArtifact();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Dependency node: " + depNode));
            }
            if ((v1 = new DefaultArtifactVersion(artifact.getVersion())).compareTo((Object)(v2 = new DefaultArtifactVersion(related.getVersion()))) <= 0 || !artifacts.add(artifact)) continue;
            log.info((CharSequence)("Dependency node added: " + depNode));
        }
        return artifacts;
    }

    private static boolean isServiceProvider(Manifest mf) {
        String export;
        return mf != null && (export = mf.getMainAttributes().getValue("Export-Package")) != null && export.contains("META-INF.services;partial=true;mandatory:=partial");
    }

    private void generateGatewayBundle(ProjectSet bundleSymbolicNames) throws FileNotFoundException, IOException {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        StringBuffer requireBundle = new StringBuffer();
        for (String name : new HashSet(bundleSymbolicNames.artifactToNameMap.values())) {
            requireBundle.append(name).append(";").append("resolution").append(":=").append("optional");
            if (this.gatewayReexport) {
                requireBundle.append(";").append("visibility").append(":=").append("reexport");
            }
            requireBundle.append(",");
        }
        int len = requireBundle.length();
        if (len > 0 && requireBundle.charAt(len - 1) == ',') {
            requireBundle.deleteCharAt(len - 1);
            attrs.putValue("Require-Bundle", requireBundle.toString());
            attrs.putValue("Manifest-Version", "1.0");
            attrs.putValue("Implementation-Vendor", "The Apache Software Foundation");
            attrs.putValue("Implementation-Vendor-Id", "org.apache");
            attrs.putValue("Bundle-Version", "2.0.0");
            attrs.putValue("Bundle-ManifestVersion", "2");
            attrs.putValue("Bundle-SymbolicName", GATEWAY_BUNDLE);
            attrs.putValue("Bundle-Name", "Apache Tuscany SCA Gateway Bundle");
            attrs.putValue("Bundle-Vendor", "The Apache Software Foundation");
            attrs.putValue("Export-Package", "META-INF.services");
            attrs.putValue("DynamicImport-Package", "*");
            attrs.putValue("Bundle-ActivationPolicy", "lazy");
            File file = new File(this.targetDirectory, "tuscany-gateway-" + this.project.getVersion() + ".jar");
            this.getLog().info((CharSequence)("Generating gateway bundle: " + file.getAbsolutePath()));
            FileOutputStream fos = new FileOutputStream(file);
            JarOutputStream jos = new JarOutputStream((OutputStream)fos, manifest);
            ModuleBundlesBuildMojo.addFileToJar(jos, "META-INF/LICENSE", ((Object)((Object)this)).getClass().getResource("LICENSE.txt"));
            ModuleBundlesBuildMojo.addFileToJar(jos, "META-INF/NOTICE", ((Object)((Object)this)).getClass().getResource("NOTICE.txt"));
            jos.close();
        }
    }

    private void setBundleClassPath(Manifest mf, File artifactFile) {
        String cp = mf.getMainAttributes().getValue("Bundle-ClassPath");
        cp = cp == null ? artifactFile.getName() : cp + "," + artifactFile.getName();
        mf.getMainAttributes().putValue("Bundle-ClassPath", cp);
    }

    private void generateANTPath(ProjectSet jarNames, File root, Log log) throws FileNotFoundException, IOException {
        for (Map.Entry e : jarNames.nameMap.entrySet()) {
            Set jars = (Set)e.getValue();
            File feature = new File(root, "../" + this.featuresName + "/" + (this.useDistributionName ? this.trim((String)e.getKey()) : ""));
            feature.mkdirs();
            File antPath = new File(feature, "build-path.xml");
            log.info((CharSequence)("Generating ANT build path: " + antPath.getCanonicalPath()));
            FileOutputStream fos = new FileOutputStream(antPath);
            PrintStream ps = new PrintStream(fos);
            ps.println(ASL_HEADER);
            String name = this.trim((String)e.getKey());
            ps.println("<project name=\"tuscany." + name + "\">");
            ps.println("  <property name=\"tuscany.distro\" value=\"" + name + "\"/>");
            ps.println("  <property name=\"tuscany.manifest\" value=\"" + new File(feature, this.manifestJarName).getCanonicalPath() + "\"/>");
            ps.println("  <path id=\"tuscany.path\">");
            ps.println("    <fileset dir=\"" + root.getCanonicalPath() + "\">");
            for (String jar : jars) {
                ps.println("      <include name=\"" + jar + "\"/>");
            }
            ps.println("    </fileset>");
            ps.println("  </path>");
            ps.println("</project>");
        }
    }

    private void generateManifestJar(ProjectSet jarNames, File root, Log log) throws FileNotFoundException, IOException {
        for (Map.Entry e : jarNames.nameMap.entrySet()) {
            MavenProject pom = jarNames.getProject((String)e.getKey());
            Set jars = (Set)e.getValue();
            File feature = new File(root, "../" + this.featuresName + "/" + (this.useDistributionName ? this.trim((String)e.getKey()) : ""));
            feature.mkdirs();
            File mfJar = new File(feature, this.manifestJarName);
            log.info((CharSequence)("Generating manifest jar: " + mfJar.getCanonicalPath()));
            FileOutputStream fos = new FileOutputStream(mfJar);
            Manifest mf = new Manifest();
            StringBuffer cp = new StringBuffer();
            String path = (this.useDistributionName ? "../../" : "../") + root.getName();
            for (String jar : jars) {
                cp.append(path).append('/').append(jar).append(' ');
            }
            if (cp.length() > 0) {
                cp.deleteCharAt(cp.length() - 1);
            }
            Attributes attrs = mf.getMainAttributes();
            attrs.putValue("Manifest-Version", "1.0");
            attrs.putValue("Implementation-Title", pom.getName());
            attrs.putValue("Implementation-Vendor", "The Apache Software Foundation");
            attrs.putValue("Implementation-Vendor-Id", "org.apache");
            attrs.putValue("Implementation-Version", pom.getVersion());
            attrs.putValue("Class-Path", cp.toString());
            attrs.putValue("Main-Class", "org.apache.tuscany.sca.node.launcher.NodeMain");
            JarOutputStream jos = new JarOutputStream((OutputStream)fos, mf);
            ModuleBundlesBuildMojo.addFileToJar(jos, "META-INF/LICENSE", ((Object)((Object)this)).getClass().getResource("LICENSE.txt"));
            ModuleBundlesBuildMojo.addFileToJar(jos, "META-INF/NOTICE", ((Object)((Object)this)).getClass().getResource("NOTICE.txt"));
            jos.close();
        }
    }

    private void generateEquinoxLauncherManifestJar(ProjectSet jarNames, File root, Log log) throws Exception {
        String equinoxLauncher = "org.apache.tuscany.sca:tuscany-node-launcher-equinox";
        Artifact artifact = (Artifact)this.project.getArtifactMap().get(equinoxLauncher);
        if (artifact == null) {
            return;
        }
        Set artifacts = this.resolveTransitively(artifact).getArtifacts();
        File feature = new File(root, "../" + this.featuresName + "/");
        feature.mkdirs();
        File mfJar = new File(feature, this.equinoxManifestJarName);
        log.info((CharSequence)("Generating equinox manifest jar: " + mfJar.getCanonicalPath()));
        FileOutputStream fos = new FileOutputStream(mfJar);
        Manifest mf = new Manifest();
        StringBuffer cp = new StringBuffer();
        String path = "../" + root.getName();
        for (Object o : artifacts) {
            Artifact a = (Artifact)o;
            if ("test".equals(a.getScope())) continue;
            String id = ArtifactUtils.versionlessKey((Artifact)a);
            String jar = (String)jarNames.artifactToNameMap.get(id);
            if (jar == null) continue;
            cp.append(path).append('/').append(jar).append(' ');
        }
        if (cp.length() > 0) {
            cp.deleteCharAt(cp.length() - 1);
        }
        Attributes attrs = mf.getMainAttributes();
        attrs.putValue("Manifest-Version", "1.0");
        attrs.putValue("Implementation-Title", artifact.getId());
        attrs.putValue("Implementation-Vendor", "The Apache Software Foundation");
        attrs.putValue("Implementation-Vendor-Id", "org.apache");
        attrs.putValue("Implementation-Version", artifact.getVersion());
        attrs.putValue("Class-Path", cp.toString());
        attrs.putValue("Main-Class", "org.apache.tuscany.sca.node.equinox.launcher.NodeMain");
        JarOutputStream jos = new JarOutputStream((OutputStream)fos, mf);
        ModuleBundlesBuildMojo.addFileToJar(jos, "META-INF/LICENSE", ((Object)((Object)this)).getClass().getResource("LICENSE.txt"));
        ModuleBundlesBuildMojo.addFileToJar(jos, "META-INF/NOTICE", ((Object)((Object)this)).getClass().getResource("NOTICE.txt"));
        jos.close();
    }

    private void generateEquinoxConfig(ProjectSet bundleLocations, File root, Log log) throws IOException {
        for (Map.Entry e : bundleLocations.nameMap.entrySet()) {
            HashSet<String> locations = new HashSet<String>((Collection)e.getValue());
            if (this.generateGatewayBundle) {
                locations.add("tuscany-gateway-" + this.project.getVersion() + ".jar");
            }
            File feature = new File(root, "../" + this.featuresName + "/" + (this.useDistributionName ? this.trim((String)e.getKey()) : ""));
            File config = new File(feature, "configuration");
            config.mkdirs();
            File ini = new File(config, "config.ini");
            log.info((CharSequence)("Generating configuation: " + ini.getCanonicalPath()));
            FileOutputStream fos = new FileOutputStream(ini);
            PrintStream ps = new PrintStream(fos);
            int size = locations.size();
            if (size > 0) {
                ps.println("osgi.bundles=\\");
                int count = 0;
                for (String f : locations) {
                    if (f.startsWith("osgi")) {
                        ++count;
                        continue;
                    }
                    ps.print("    ");
                    ps.print(f);
                    if (this.generateBundleStart) {
                        ps.print("@:start");
                    }
                    if (count == size - 1) {
                        ps.println();
                    } else {
                        ps.println(",\\");
                    }
                    ++count;
                }
            }
            ps.println("eclipse.ignoreApp=true");
            ps.println("osgi.noShutdown=true");
            ps.close();
        }
    }

    private void generateAggregatedBundles(ProjectSet bundleLocations, File root, Log log) throws Exception {
        for (Map.Entry e : bundleLocations.nameMap.entrySet()) {
            HashSet locations = new HashSet((Collection)e.getValue());
            String featureName = this.useDistributionName ? this.trim((String)e.getKey()) : "";
            File feature = new File(root, "../" + this.featuresName + "/" + featureName);
            String bundleFileName = "tuscany-bundle.jar";
            File bundleFile = new File(feature, bundleFileName);
            log.info((CharSequence)("Generating aggregated OSGi bundle: " + bundleFile));
            File[] files = new File[locations.size()];
            int i = 0;
            for (String child : locations) {
                files[i++] = new File(root, child);
            }
            String bundleVersion = "2.0.0";
            String bundleName = "org.apache.tuscany.sca.bundle";
            BundleAggregatorMojo.aggregateBundles(log, root, files, bundleFile, bundleName, bundleVersion);
        }
    }

    private void generatePDETarget(ProjectSet bundleSymbolicNames, File root, Log log) throws FileNotFoundException, IOException {
        for (Map.Entry e : bundleSymbolicNames.nameMap.entrySet()) {
            HashSet<String> bundles = new HashSet<String>((Collection)e.getValue());
            String name = this.trim((String)e.getKey());
            File feature = new File(root, "../" + this.featuresName + "/" + (this.useDistributionName ? name : ""));
            feature.mkdirs();
            File target = new File(feature, "tuscany.target");
            log.info((CharSequence)("Generating target definition: " + target.getCanonicalPath()));
            FileOutputStream targetFile = new FileOutputStream(target);
            if (!bundles.contains("org.eclipse.osgi")) {
                bundles.add("org.eclipse.osgi");
            }
            if (this.generateGatewayBundle) {
                bundles.add(GATEWAY_BUNDLE);
            }
            this.writeTarget(new PrintStream(targetFile), name, bundles, this.eclipseFeatures);
            targetFile.close();
            File target35 = new File(feature, "tuscany-pde35.target");
            log.info((CharSequence)("Generating target definition: " + target35.getCanonicalPath()));
            FileOutputStream target35File = new FileOutputStream(target35);
            this.writePDE35Target(new PrintStream(target35File), name, bundles, this.eclipseFeatures);
            target35File.close();
        }
    }

    private MavenProject buildProject(Artifact artifact) throws ProjectBuildingException, InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException, DependencyTreeBuilderException {
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepos, this.local);
        if (pomProject.getDependencyArtifacts() == null) {
            pomProject.setDependencyArtifacts(pomProject.createArtifacts(this.factory, null, (ArtifactFilter)new ScopeArtifactFilter("test")));
        }
        if (this.includeConflictingDepedencies) {
            pomProject.setArtifacts(this.getDependencyArtifacts(pomProject));
        } else {
            ArtifactResolutionResult result = this.resolver.resolveTransitively(pomProject.getDependencyArtifacts(), pomProject.getArtifact(), this.remoteRepos, this.local, this.artifactMetadataSource);
            pomProject.setArtifacts(result.getArtifacts());
        }
        return pomProject;
    }

    private ArtifactResolutionResult resolveTransitively(Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact originatingArtifact = this.factory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.resolver.resolveTransitively(Collections.singleton(artifact), originatingArtifact, this.local, this.remoteRepos, this.artifactMetadataSource, null);
    }

    private String trim(String artifactId) {
        if (artifactId.startsWith("tuscany-feature-")) {
            return artifactId.substring("tuscany-feature-".length());
        }
        return artifactId;
    }

    private static void copyFile(File jar, File dir) throws FileNotFoundException, IOException {
        int len;
        byte[] buf = new byte[4096];
        File jarFile = new File(dir, jar.getName());
        FileInputStream in = new FileInputStream(jar);
        FileOutputStream out = new FileOutputStream(jarFile);
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    private static void copyManifest(File mfFrom, File mfTo) throws FileNotFoundException, IOException {
        int len;
        byte[] buf = new byte[4096];
        FileInputStream in = new FileInputStream(mfFrom);
        FileOutputStream out = new FileOutputStream(mfTo);
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    private static void addFileToJar(JarOutputStream out, String entryName, URL file) throws FileNotFoundException, IOException {
        int len;
        byte[] buf = new byte[4096];
        InputStream in = file.openStream();
        out.putNextEntry(new ZipEntry(entryName));
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.closeEntry();
    }

    private void writeTarget(PrintStream ps, String pom, Set<String> ids, String[] features) {
        ps.println(XML_PI);
        ps.println("<?pde version=\"3.2\"?>");
        ps.println(ASL_HEADER);
        ps.println("<target name=\"Eclipse Target - " + pom + "\">");
        if (this.executionEnvironment != null) {
            ps.println("  <targetJRE>");
            ps.println("    <execEnv>" + this.executionEnvironment + "</execEnv>");
            ps.println("  </targetJRE>");
        }
        if (this.useDefaultLocation) {
            ps.println("  <location useDefault=\"true\"/>");
        } else {
            ps.println("  <location path=\"" + this.targetDirectory + "\"/>");
        }
        ps.println("  <content>");
        ps.println("    <plugins>");
        for (String id : ids) {
            ps.println("      <plugin id=\"" + id + "\"/>");
        }
        ps.println("    </plugins>");
        ps.println("    <features>");
        if (features != null) {
            for (String f : features) {
                ps.println("      <feature id=\"" + f + "\"/>");
            }
        }
        ps.println("    </features>");
        if (this.useDefaultLocation) {
            ps.println("    <extraLocations>");
            ps.println("      <location path=\"" + this.targetDirectory + "\"/>");
            ps.println("    </extraLocations>");
        }
        ps.println("  </content>");
        ps.println("</target>");
    }

    private void writePDE35Target(PrintStream ps, String pom, Set<String> ids, String[] features) {
        ps.println(XML_PI);
        ps.println("<?pde version=\"3.5\"?>");
        ps.println(ASL_HEADER);
        ps.println("<target name=\"Eclipse PDE 3.5 Target - " + pom + "\">");
        if (this.executionEnvironment != null) {
            ps.println("  <targetJRE path=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + this.executionEnvironment + "\"/>");
        }
        ps.println("<locations>");
        if (ids.size() > 0) {
            ps.println("  <location path=\"" + this.targetDirectory + "\" type=\"Directory\">");
            ps.println("    <includeBundles>");
            for (String id : ids) {
                ps.println("      <plugin id=\"" + id + "\"/>");
            }
            ps.println("    </includeBundles>");
            ps.println("  </location>");
        }
        ps.println("</locations>");
        ps.println("</target>");
    }

    private static void writePluginXML(PrintStream ps) {
        ps.println(XML_PI);
        ps.println("<?pde version=\"3.2\"?>");
        ps.println(ASL_HEADER);
        ps.println("<plugin>");
        ps.println("<extension point = \"org.eclipse.pde.core.targets\">");
        ps.println("<target");
        ps.println("id=\"org.apache.tuscany.sca.target\"");
        ps.println("name=\"Apache Tuscany Eclipse Target\"");
        ps.println("path=\"tuscany.target\"/>");
        ps.println("</extension>");
        ps.println("</plugin>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectSet {
        private Map<String, MavenProject> projects;
        private Map<String, Set<String>> nameMap = new HashMap<String, Set<String>>();
        private Map<String, String> artifactToNameMap = new HashMap<String, String>();

        public ProjectSet(List<MavenProject> projects) {
            this.projects = new HashMap<String, MavenProject>();
            for (MavenProject p : projects) {
                this.projects.put(p.getArtifactId(), p);
            }
        }

        private MavenProject getProject(String artifactId) {
            return this.projects.get(artifactId);
        }

        private void add(Artifact artifact, String name) {
            String key = ArtifactUtils.versionlessKey((Artifact)artifact);
            for (MavenProject p : this.projects.values()) {
                Artifact a = (Artifact)p.getArtifactMap().get(key);
                if (a == null) continue;
                Set<String> names = this.nameMap.get(p.getArtifactId());
                if (names == null) {
                    names = new HashSet<String>();
                    this.nameMap.put(p.getArtifactId(), names);
                }
                names.add(name);
            }
            this.artifactToNameMap.put(key, name);
        }
    }
}

