/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.bundle.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderParser {
    private static final String PATH_SEPARATOR = ",";
    private static final String SEGMENT_SEPARATOR = ";";
    private static final String ATTRIBUTE_SEPARATOR = "=";
    private static final String DIRECTIVE_SEPARATOR = ":=";
    private static final char QUOTE_CHAR = '\"';
    private static final String QUOTE = "\"";

    public static List<HeaderClause> parse(String header) {
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("A header cannot be an empty string.");
            }
            String[] clauseStrings = HeaderParser.parseDelimitedString(header, PATH_SEPARATOR);
            ArrayList<HeaderClause> completeList = new ArrayList<HeaderClause>();
            for (int i = 0; clauseStrings != null && i < clauseStrings.length; ++i) {
                completeList.add(HeaderParser.parseClause(clauseStrings[i]));
            }
            return completeList;
        }
        return null;
    }

    private static HeaderClause parseClause(String clauseString) throws IllegalArgumentException {
        String[] pieces = HeaderParser.parseDelimitedString(clauseString, SEGMENT_SEPARATOR);
        int pathCount = 0;
        for (int pieceIdx = 0; pieceIdx < pieces.length && pieces[pieceIdx].indexOf(61) < 0; ++pieceIdx) {
            ++pathCount;
        }
        String[] paths = new String[pathCount];
        System.arraycopy(pieces, 0, paths, 0, pathCount);
        HashMap<String, String> dirsMap = new HashMap<String, String>();
        HashMap<String, String> attrsMap = new HashMap<String, String>();
        int idx = -1;
        String sep = null;
        for (int pieceIdx = pathCount; pieceIdx < pieces.length; ++pieceIdx) {
            idx = pieces[pieceIdx].indexOf(DIRECTIVE_SEPARATOR);
            if (idx >= 0) {
                sep = DIRECTIVE_SEPARATOR;
            } else {
                idx = pieces[pieceIdx].indexOf(ATTRIBUTE_SEPARATOR);
                if (idx >= 0) {
                    sep = ATTRIBUTE_SEPARATOR;
                } else {
                    throw new IllegalArgumentException("Not a directive/attribute: " + clauseString);
                }
            }
            String key = pieces[pieceIdx].substring(0, idx).trim();
            String value = pieces[pieceIdx].substring(idx + sep.length()).trim();
            if (value.startsWith(QUOTE) && value.endsWith(QUOTE)) {
                value = value.substring(1, value.length() - 1);
            }
            if (sep.equals(DIRECTIVE_SEPARATOR)) {
                if (dirsMap.get(key) != null) {
                    throw new IllegalArgumentException("Duplicate directive: " + key);
                }
                dirsMap.put(key, value);
                continue;
            }
            if (attrsMap.get(key) != null) {
                throw new IllegalArgumentException("Duplicate attribute: " + key);
            }
            attrsMap.put(key, value);
        }
        StringBuffer path = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            path.append(paths[i]);
            if (i == paths.length - 1) continue;
            path.append(';');
        }
        HeaderClause descriptor = new HeaderClause();
        descriptor.text = clauseString;
        descriptor.value = path.toString();
        HeaderClause.access$202(descriptor, paths);
        descriptor.attributes = attrsMap;
        descriptor.directives = dirsMap;
        return descriptor;
    }

    private static String[] parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    public static QName getQName(String qname) {
        if (qname == null) {
            return null;
        }
        if ((qname = qname.trim()).startsWith("{")) {
            int h = qname.indexOf(125);
            if (h != -1) {
                return new QName(qname.substring(1, h), qname.substring(h + 1));
            }
        } else {
            int h = qname.indexOf(35);
            if (h != -1) {
                return new QName(qname.substring(0, h), qname.substring(h + 1));
            }
        }
        return new QName(qname);
    }

    public static String toHeader(List<HeaderClause> descriptors) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < descriptors.size(); ++i) {
            HeaderClause descriptor = descriptors.get(i);
            buf.append(descriptor);
            if (i == descriptors.size() - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public static String merge(String ... headers) {
        ArrayList<HeaderClause> merged = new ArrayList<HeaderClause>();
        for (String header : headers) {
            if (header == null || header.length() == 0) continue;
            List<HeaderClause> descriptors = HeaderParser.parse(header);
            merged.addAll(descriptors);
        }
        HashSet<String> values = new HashSet<String>();
        Iterator i = merged.iterator();
        while (i.hasNext()) {
            if (values.add(((HeaderClause)i.next()).getValue())) continue;
            i.remove();
        }
        return HeaderParser.toHeader(merged);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeaderClause {
        private String text;
        private String value;
        private String[] valueComponents;
        private Map<String, String> attributes;
        private Map<String, String> directives;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String[] getValueComponents() {
            return this.valueComponents;
        }

        public void setValueComponents(String[] valueComponents) {
            this.valueComponents = valueComponents;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public String toString() {
            String text = null;
            if (text == null) {
                StringBuffer buf = new StringBuffer();
                if (this.value == null) {
                    int start = buf.length();
                    for (int i = 0; i < this.valueComponents.length; ++i) {
                        if (i != this.valueComponents.length - 1) {
                            buf.append(this.valueComponents[i]).append(';');
                            continue;
                        }
                        buf.append(this.valueComponents[i]);
                    }
                    int end = buf.length();
                    if (end > start) {
                        this.value = buf.substring(start, end);
                    }
                }
                buf.append(this.value);
                for (Map.Entry<String, String> e : this.attributes.entrySet()) {
                    buf.append(';').append(e.getKey()).append("=\"").append(e.getValue()).append(HeaderParser.QUOTE);
                }
                for (Map.Entry<String, String> e : this.directives.entrySet()) {
                    buf.append(';').append(e.getKey()).append(":=\"").append(e.getValue()).append(HeaderParser.QUOTE);
                }
                text = buf.toString();
            }
            return text;
        }

        static /* synthetic */ String[] access$202(HeaderClause x0, String[] x1) {
            x0.valueComponents = x1;
            return x1;
        }
    }
}

