/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.bundle.plugin;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tuscany.maven.bundle.plugin.OSGIArtifactVersion;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleUtil {
    static final String META_INF_SERVICES = "META-INF.services;partial=true;mandatory:=partial";
    private static final Logger logger = Logger.getLogger(BundleUtil.class.getName());
    private static String J2SE = "J2SE-";
    private static String JAVASE = "JavaSE-";
    private static String PROFILE_EXT = ".profile";

    public static String getBundleSymbolicName(File file) throws IOException {
        Manifest manifest = BundleUtil.getManifest(file);
        return BundleUtil.getBundleSymbolicName(manifest);
    }

    static String getBundleSymbolicName(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        String bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bundleName == null) {
            return bundleName;
        }
        int sc = bundleName.indexOf(59);
        if (sc != -1) {
            bundleName = bundleName.substring(0, sc);
        }
        return bundleName;
    }

    static Manifest getManifest(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        Manifest manifest = null;
        if (file.isDirectory()) {
            File mf = new File(file, "META-INF/MANIFEST.MF");
            if (mf.isFile()) {
                FileInputStream is = new FileInputStream(mf);
                manifest = new Manifest(new FileInputStream(mf));
                ((InputStream)is).close();
            }
        } else {
            JarFile jar = new JarFile(file, false);
            manifest = jar.getManifest();
            jar.close();
        }
        return manifest;
    }

    static Manifest libraryManifest(Set<File> jarFiles, String name, String symbolicName, String version, String dir) throws IllegalStateException {
        return BundleUtil.libraryManifest(jarFiles, name, symbolicName, version, dir, null, null);
    }

    static Manifest libraryManifest(Set<File> jarFiles, String name, String symbolicName, String version, String dir, String buddyPolicy, String env) throws IllegalStateException {
        try {
            StringBuffer classpath = new StringBuffer();
            HashSet<String> exportedPackages = new HashSet<String>();
            for (File jarFile : jarFiles) {
                if (!jarFile.exists()) {
                    logger.warning(jarFile + " doesn't exist.");
                    continue;
                }
                BundleUtil.addPackages(jarFile, exportedPackages, version);
                if (dir != null) {
                    classpath.append(dir).append("/");
                }
                classpath.append(jarFile.getName());
                classpath.append(",");
            }
            if (env == null) {
                env = "JavaSE-1.6";
            }
            Set<String> sysPackages = BundleUtil.getSystemPackages(env);
            StringBuffer exports = new StringBuffer();
            StringBuffer imports = new StringBuffer();
            HashSet<String> pkgs = new HashSet<String>();
            for (String export : exportedPackages) {
                String packageName = BundleUtil.packageName(export);
                if (!pkgs.contains(packageName) && !sysPackages.contains(packageName)) {
                    if (!"META-INF.services".equals(packageName)) {
                        imports.append(export);
                        imports.append(',');
                    }
                    pkgs.add(packageName);
                    exports.append(export);
                    exports.append(',');
                    continue;
                }
                logger.warning("Duplicate or system package skipped: " + export);
            }
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Manifest-Version", "1.0");
            attributes.putValue("Bundle-ManifestVersion", "2");
            attributes.putValue("Bundle-SymbolicName", symbolicName);
            attributes.putValue("Bundle-Name", name);
            attributes.putValue("Bundle-Version", version);
            attributes.putValue("DynamicImport-Package", "javax.transaction;version=\"1.1\",javax.transaction.xa;version=\"1.1\",*");
            if (buddyPolicy != null && buddyPolicy.length() > 0) {
                attributes.putValue("Eclipse-BuddyPolicy", buddyPolicy);
            }
            if (exports.length() > 1) {
                attributes.putValue("Export-Package", exports.substring(0, exports.length() - 1));
            }
            if (classpath.length() > 1) {
                attributes.putValue("Bundle-ClassPath", classpath.substring(0, classpath.length() - 1));
            }
            return manifest;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static void write(Manifest manifest, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        Attributes attributes = manifest.getMainAttributes();
        BundleUtil.write(attributes, "Manifest-Version", dos);
        BundleUtil.write(attributes, "Bundle-ManifestVersion", dos);
        BundleUtil.write(attributes, "Bundle-SymbolicName", dos);
        BundleUtil.write(attributes, "Bundle-Name", dos);
        BundleUtil.write(attributes, "Bundle-Version", dos);
        BundleUtil.write(attributes, "DynamicImport-Package", dos);
        BundleUtil.write(attributes, "Bundle-ClassPath", dos);
        BundleUtil.write(attributes, "Import-Package", dos);
        BundleUtil.write(attributes, "Export-Package", dos);
        BundleUtil.write(attributes, "Eclipse-BuddyPolicy", dos);
        dos.flush();
    }

    private static void addPackages(File jarFile, Set<String> packages, String version) throws IOException {
        String ver = ";version=" + version;
        BundleUtil.addAllPackages(jarFile, packages, ver);
    }

    private static void write(Attributes attributes, String key, DataOutputStream dos) throws IOException {
        String value = attributes.getValue(key);
        if (value == null) {
            return;
        }
        StringBuffer line = new StringBuffer();
        line.append(key);
        line.append(": ");
        line.append(new String(value.getBytes("UTF8")));
        line.append("\r\n");
        int l = line.length();
        if (l > 72) {
            int i = 70;
            while (i < l - 2) {
                line.insert(i, "\r\n ");
                i += 72;
                l += 3;
            }
        }
        dos.writeBytes(line.toString());
    }

    private static String stripExport(String export) {
        int sc = export.indexOf(59);
        if (sc == -1) {
            return export;
        }
        String base = export.substring(0, sc);
        int v = export.indexOf("version=");
        if (v != -1) {
            sc = export.indexOf(59, v + 1);
            if (sc != -1) {
                return base + ";" + export.substring(v, sc);
            }
            return base + ";" + export.substring(v);
        }
        return base;
    }

    private static void addAllPackages(File jarFile, Set<String> packages, String version) throws IOException {
        ZipEntry entry;
        ZipInputStream is = new ZipInputStream(new FileInputStream(jarFile));
        while ((entry = is.getNextEntry()) != null) {
            String pkg;
            String entryName = entry.getName();
            if (entryName.startsWith("META-INF/services/")) {
                packages.add(META_INF_SERVICES);
            }
            if (entry.isDirectory() || entryName == null || entryName.length() <= 0 || entryName.startsWith(".") || !entryName.endsWith(".class") || entryName.lastIndexOf("/") <= 0 || !Character.isJavaIdentifierStart(entryName.charAt(0)) || (pkg = entryName.substring(0, entryName.lastIndexOf("/")).replace('/', '.')).endsWith(".enum")) continue;
            packages.add(pkg + version);
        }
        is.close();
    }

    private static Set<String> getSystemPackages(String env) throws IOException {
        HashSet<String> sysPackages = new HashSet<String>();
        InputStream is = BundleUtil.class.getResourceAsStream("/" + env + ".profile");
        if (is != null) {
            Properties props = new Properties();
            props.load(is);
            String pkgs = (String)props.get("org.osgi.framework.system.packages");
            if (pkgs != null) {
                for (String p : pkgs.split(",")) {
                    sysPackages.add(p.trim());
                }
            }
        }
        return sysPackages;
    }

    private static String packageName(String export) {
        int sc = export.indexOf(59);
        if (sc != -1) {
            export = export.substring(0, sc);
        }
        return export;
    }

    public static Set<String> getExportedPackages(File file) throws IOException {
        if (!file.exists()) {
            return Collections.emptySet();
        }
        HashSet<String> packages = new HashSet<String>();
        Manifest manifest = BundleUtil.getManifest(file);
        String bundleName = null;
        String exports = null;
        if (manifest != null) {
            exports = manifest.getMainAttributes().getValue("Export-Package");
            bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        }
        if (bundleName == null) {
            HashSet<String> allPackages = new HashSet<String>();
            BundleUtil.addAllPackages(file, allPackages, "");
            for (String p : allPackages) {
                packages.add(BundleUtil.packageName(p));
            }
            return packages;
        }
        packages.addAll(BundleUtil.parsePackages(exports));
        return packages;
    }

    public static Set<String> getImportedPackages(File file) throws IOException {
        if (!file.exists()) {
            return Collections.emptySet();
        }
        Manifest manifest = BundleUtil.getManifest(file);
        String bundleName = null;
        String imports = null;
        if (manifest != null) {
            imports = manifest.getMainAttributes().getValue("Import-Package");
            bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            if (imports != null && bundleName != null) {
                return BundleUtil.parsePackages(imports);
            }
        }
        return Collections.emptySet();
    }

    private static Set<String> parsePackages(String header) {
        if (header == null) {
            return Collections.emptySet();
        }
        HashSet<String> packages = new HashSet<String>();
        StringBuffer buffer = new StringBuffer();
        boolean q = false;
        int n = header.length();
        for (int i = 0; i < n; ++i) {
            char c = header.charAt(i);
            if (c == '\"') {
                boolean bl = q = !q;
            }
            if (!q && c == ',') {
                String export = buffer.toString();
                packages.add(BundleUtil.packageName(export));
                buffer = new StringBuffer();
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() != 0) {
            String export = buffer.toString();
            packages.add(BundleUtil.packageName(export));
        }
        return packages;
    }

    static String osgiVersion(String mavenVersion) {
        OSGIArtifactVersion ver = new OSGIArtifactVersion(mavenVersion);
        String qualifer = ver.getQualifier();
        if (qualifer != null) {
            StringBuffer buf = new StringBuffer(qualifer);
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
                buf.setCharAt(i, '_');
            }
            qualifer = buf.toString();
        }
        Version osgiVersion = new Version(ver.getMajorVersion(), ver.getMinorVersion(), ver.getIncrementalVersion(), qualifer);
        String version = osgiVersion.toString();
        return version;
    }

    private static URL findInSystemBundle(String entry) {
        ClassLoader loader = BundleUtil.class.getClassLoader();
        return loader == null ? ClassLoader.getSystemResource(entry) : loader.getResource(entry);
    }

    private static URL findNextBestProfile(String javaEdition, Version javaVersion) {
        URL result = null;
        int minor = javaVersion.getMinor();
        while ((result = BundleUtil.findInSystemBundle(javaEdition + javaVersion.getMajor() + "." + minor + PROFILE_EXT)) == null && --minor > 0) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties findVMProfile(Properties properties) {
        String javaProfile;
        Properties result = new Properties();
        String j2meConfig = properties.getProperty("microedition.configuration");
        String j2meProfiles = properties.getProperty("microedition.profiles");
        String vmProfile = null;
        String javaEdition = null;
        Version javaVersion = null;
        if (j2meConfig != null && j2meConfig.length() > 0 && j2meProfiles != null && j2meProfiles.length() > 0) {
            String[] j2meProfileList = ManifestElement.getArrayFromList((String)j2meProfiles, (String)" ");
            if (j2meProfileList != null && j2meProfileList.length > 0) {
                vmProfile = j2meConfig + '_' + j2meProfileList[j2meProfileList.length - 1];
            }
        } else {
            String javaSpecVersion = properties.getProperty("java.specification.version");
            if (javaSpecVersion != null) {
                StringTokenizer st = new StringTokenizer(javaSpecVersion, " _-");
                javaSpecVersion = st.nextToken();
                String javaSpecName = properties.getProperty("java.specification.name");
                if ("J2ME Foundation Specification".equals(javaSpecName)) {
                    vmProfile = "CDC-" + javaSpecVersion + "_Foundation-" + javaSpecVersion;
                } else {
                    Version v16 = new Version("1.6");
                    javaEdition = J2SE;
                    try {
                        javaVersion = new Version(javaSpecVersion);
                        if (v16.compareTo((Object)javaVersion) <= 0) {
                            javaEdition = JAVASE;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    vmProfile = javaEdition + javaSpecVersion;
                }
            }
        }
        URL url = null;
        String propJavaProfile = FrameworkProperties.getProperty((String)"osgi.java.profile");
        if (propJavaProfile != null) {
            try {
                url = new URL(propJavaProfile);
            }
            catch (MalformedURLException e1) {
                url = BundleUtil.findInSystemBundle(propJavaProfile);
            }
        }
        if (url == null && vmProfile != null && (url = BundleUtil.findInSystemBundle(javaProfile = vmProfile + PROFILE_EXT)) == null) {
            url = BundleUtil.getNextBestProfile(javaEdition, javaVersion);
        }
        if (url == null) {
            url = BundleUtil.findInSystemBundle("OSGi_Minimum-1.1.profile");
        }
        if (url != null) {
            InputStream in = null;
            try {
                in = url.openStream();
                result.load(new BufferedInputStream(in));
            }
            catch (IOException e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ee) {}
                }
            }
        }
        if (result.getProperty("osgi.java.profile.name") == null) {
            if (vmProfile != null) {
                result.put("osgi.java.profile.name", vmProfile.replace('_', '/'));
            } else {
                result.put("osgi.java.profile.name", "OSGi/Minimum-1.1");
            }
        }
        return result;
    }

    private static URL getNextBestProfile(String javaEdition, Version javaVersion) {
        if (javaVersion == null || javaEdition != J2SE && javaEdition != JAVASE) {
            return null;
        }
        URL bestProfile = BundleUtil.findNextBestProfile(javaEdition, javaVersion);
        if (bestProfile == null && javaEdition == JAVASE) {
            bestProfile = BundleUtil.findNextBestProfile(J2SE, javaVersion);
        }
        return bestProfile;
    }
}

