/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.bundle.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.tuscany.maven.bundle.plugin.AggregatedBundleActivator;
import org.apache.tuscany.maven.bundle.plugin.HeaderParser;

public class BundleAggregatorMojo
extends AbstractMojo {
    private File rootDirectory;
    private File targetBundleFile;
    private String bundleName = "org.apache.tuscany.sca.bundle";
    private String bundleVersion = "2.0.0";
    private static final byte[] buf = new byte[4096];

    public static void aggregateBundles(Log log, File root, File[] files, File targetBundleFile, String bundleName, String bundleVersion) throws Exception {
        targetBundleFile.getParentFile().mkdirs();
        HashSet<File> jarFiles = new HashSet<File>();
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        for (File child : files) {
            Manifest manifest = null;
            if (child.isDirectory()) {
                File mf = new File(child, "META-INF/MANIFEST.MF");
                if (mf.isFile()) {
                    String classpath;
                    FileInputStream is = new FileInputStream(mf);
                    manifest = new Manifest(is);
                    is.close();
                    if (manifest != null && (classpath = manifest.getMainAttributes().getValue("Bundle-ClassPath")) != null) {
                        for (HeaderParser.HeaderClause clause : HeaderParser.parse(classpath)) {
                            if (clause.getValue().equals(".")) continue;
                            jarFiles.add(new File(child, clause.getValue()));
                        }
                    }
                }
            } else if (child.getName().endsWith(".jar")) {
                JarFile jar = new JarFile(child);
                manifest = jar.getManifest();
                jar.close();
                if (manifest != null) {
                    String id = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                    if (id != null && (id.startsWith("org.eclipse.") || id.startsWith("org.apache.tuscany.sca.gateway"))) {
                        manifest = null;
                    } else {
                        jarFiles.add(child);
                    }
                }
            }
            if (manifest == null) continue;
            log.debug((CharSequence)("Bundle file: " + child));
            manifests.add(manifest);
        }
        Manifest merged = new Manifest();
        Attributes attributes = merged.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-License", "http://www.apache.org/licenses/LICENSE-2.0.txt");
        attributes.putValue("Bundle-DocURL", "http://www.apache.org/");
        attributes.putValue("Bundle-RequiredExecutionEnvironment", "J2SE-1.5,JavaSE-1.6");
        attributes.putValue("Bundle-Vendor", "The Apache Software Foundation");
        attributes.putValue("Bundle-Version", bundleVersion);
        attributes.putValue("Bundle-SymbolicName", bundleName);
        attributes.putValue("SCA-Version", "1.1");
        attributes.putValue("Bundle-Name", bundleName);
        for (Manifest mf : manifests) {
            for (Map.Entry<Object, Object> e : mf.getMainAttributes().entrySet()) {
                Attributes.Name key = (Attributes.Name)e.getKey();
                String name = key.toString();
                String oldValue = attributes.getValue(name);
                String value = (String)e.getValue();
                if (name.equals("Export-Package") || name.equals("Import-Package") || name.equals("Require-Bundle") || name.equals("DynamicImport-Package") || name.equals("Bundle-ClassPath") || name.equals("Private-Package") || name.equals("Bundle-Description")) {
                    attributes.putValue(name, HeaderParser.merge(oldValue, value));
                    continue;
                }
                if (name.equals("Bundle-Activator")) {
                    oldValue = attributes.getValue("Tuscany-Bundle-Activator-List");
                    attributes.putValue("Tuscany-Bundle-Activator-List", HeaderParser.merge(oldValue, value));
                    continue;
                }
                if (!name.equals("Main-Class") && !name.startsWith("Eclipse-") && !name.startsWith("Bundle-")) continue;
            }
        }
        log.info((CharSequence)("Generating " + targetBundleFile));
        attributes.putValue("Bundle-Activator", AggregatedBundleActivator.class.getName());
        String bundleClassPath = attributes.getValue("Bundle-ClassPath");
        bundleClassPath = HeaderParser.merge(bundleClassPath, ".");
        for (File f : jarFiles) {
            bundleClassPath = HeaderParser.merge(bundleClassPath, f.getName());
        }
        attributes.putValue("Bundle-ClassPath", bundleClassPath);
        FileOutputStream fos = new FileOutputStream(targetBundleFile);
        JarOutputStream bundle = new JarOutputStream((OutputStream)fos, merged);
        for (File file : jarFiles) {
            log.info((CharSequence)("Adding " + file));
            BundleAggregatorMojo.addEntry(bundle, file.getName(), file);
        }
        String classFile = AggregatedBundleActivator.class.getName().replace(".", "/") + ".class";
        InputStream classStream = BundleAggregatorMojo.class.getClassLoader().getResourceAsStream(classFile);
        BundleAggregatorMojo.addEntry(bundle, classFile, classStream);
        bundle.close();
    }

    private static void addDir(JarOutputStream jos, File root, File dir) throws IOException, FileNotFoundException {
        for (File file : dir.listFiles()) {
            String uri;
            if (file.isDirectory()) {
                BundleAggregatorMojo.addDir(jos, root, file);
                continue;
            }
            if (!file.isFile() || "META-INF/MANIFEST.MF".equals(uri = root.toURI().relativize(file.toURI()).toString())) continue;
            BundleAggregatorMojo.addEntry(jos, uri, file);
        }
    }

    private static void addEntry(JarOutputStream jos, String name, File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        BundleAggregatorMojo.addEntry(jos, name, in);
    }

    private static void addEntry(JarOutputStream jos, String name, InputStream in) throws IOException {
        int len;
        ZipEntry entry = new ZipEntry(name);
        jos.putNextEntry(entry);
        while ((len = in.read(buf)) > 0) {
            jos.write(buf, 0, len);
        }
        in.close();
        jos.closeEntry();
    }

    private static void generateJar(File root, File jar, Manifest mf) throws IOException {
        FileOutputStream fos = new FileOutputStream(jar);
        JarOutputStream jos = mf != null ? new JarOutputStream((OutputStream)fos, mf) : new JarOutputStream(fos);
        BundleAggregatorMojo.addDir(jos, root, root);
        jos.close();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Log log = this.getLog();
            if (!this.rootDirectory.isDirectory()) {
                log.warn((CharSequence)(this.rootDirectory + " is not a directory"));
                return;
            }
            File[] files = this.rootDirectory.listFiles();
            BundleAggregatorMojo.aggregateBundles(log, this.rootDirectory, files, this.targetBundleFile, this.bundleName, this.bundleVersion);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

