/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.receivers.AbstractInOutSyncMessageReceiver;
import org.apache.tuscany.sca.binding.ws.axis2.provider.TuscanyServiceProvider;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ServiceInOutSyncMessageReceiver
extends AbstractInOutSyncMessageReceiver {
    private static final Logger logger = Logger.getLogger(Axis2ServiceInOutSyncMessageReceiver.class.getName());
    private TuscanyServiceProvider provider;

    public Axis2ServiceInOutSyncMessageReceiver(TuscanyServiceProvider provider) {
        this.provider = provider;
    }

    public Axis2ServiceInOutSyncMessageReceiver() {
    }

    public void invokeBusinessLogic(MessageContext inMC, MessageContext outMC) throws AxisFault {
        try {
            OMElement requestOM = inMC.getEnvelope().getBody().getFirstElement();
            SOAPEnvelope soapEnvelope = this.getSOAPFactory(inMC).getDefaultEnvelope();
            outMC.setEnvelope(soapEnvelope);
            this.provider.invoke(requestOM, inMC, outMC);
            outMC.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"true");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof FaultException && ((FaultException)t).getFaultInfo() instanceof OMElement) {
                OMElement faultDetail = (OMElement)((FaultException)t).getFaultInfo();
                inMC.setProperty("faultName", (Object)faultDetail.getQName().getLocalPart());
                AxisFault f = new AxisFault(null, e.getMessage(), "faultNode", "faultRole", faultDetail);
                throw f;
            }
            if (t instanceof Exception) {
                throw AxisFault.makeFault((Throwable)((Exception)t));
            }
            logger.log(Level.SEVERE, e.getMessage(), t);
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (Throwable e) {
            if (!"AsyncResponse".equals(e.getMessage())) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

