/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.impl;

import java.net.URI;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.binding.sca.DistributedSCABinding;
import org.apache.tuscany.sca.binding.sca.impl.DistributedSCABindingImpl;
import org.apache.tuscany.sca.binding.sca.impl.RemoteBindingHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class RuntimeSCAServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponentService service;
    private BindingProviderFactory<DistributedSCABinding> distributedProviderFactory;
    private ServiceBindingProvider distributedProvider;
    private DistributedSCABinding distributedBinding;

    public RuntimeSCAServiceBindingProvider(ExtensionPointRegistry extensionPoints, RuntimeComponent component, RuntimeComponentService service, SCABinding binding) {
        this.service = service;
        if (service.getInterfaceContract().getInterface().isRemotable()) {
            ProviderFactoryExtensionPoint factoryExtensionPoint = (ProviderFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
            this.distributedProviderFactory = (BindingProviderFactory)factoryExtensionPoint.getProviderFactory(DistributedSCABinding.class);
            if (this.distributedProviderFactory != null) {
                URI serviceURI = null;
                try {
                    serviceURI = new URI(binding.getURI());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (RemoteBindingHelper.isTargetRemote() || serviceURI != null && serviceURI.isAbsolute()) {
                    this.distributedBinding = new DistributedSCABindingImpl();
                    this.distributedBinding.setSCABinding(binding);
                    this.distributedProvider = this.distributedProviderFactory.createServiceBindingProvider(component, service, (Binding)this.distributedBinding);
                }
            }
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        if (this.distributedProvider != null) {
            return this.distributedProvider.getBindingInterfaceContract();
        }
        if (this.service.getService() != null) {
            return this.service.getService().getInterfaceContract();
        }
        return this.service.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        if (this.distributedProvider != null) {
            this.distributedProvider.start();
        }
    }

    public void stop() {
        if (this.distributedProvider != null) {
            this.distributedProvider.stop();
        }
        if (this.distributedBinding != null) {
            SCABinding scaBinding = this.distributedBinding.getSCABinding();
            try {
                URI tempURI = new URI(scaBinding.getURI());
                if (!tempURI.isAbsolute()) {
                    scaBinding.setURI(null);
                }
            }
            catch (Exception ex) {
                scaBinding.setURI(null);
            }
        }
    }
}

