/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca;

import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.provider.SCADefinitionsProvider;
import org.apache.tuscany.sca.provider.SCADefinitionsProviderException;

public class SCABindingDefinitionsProvider
implements SCADefinitionsProvider {
    private String definitionsFile = "org/apache/tuscany/sca/binding/sca/definitions.xml";
    URLArtifactProcessor urlArtifactProcessor = null;

    public SCABindingDefinitionsProvider(ExtensionPointRegistry registry) {
        URLArtifactProcessorExtensionPoint documentProcessors = (URLArtifactProcessorExtensionPoint)registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.urlArtifactProcessor = (URLArtifactProcessor)documentProcessors.getProcessor(SCADefinitions.class);
    }

    public SCADefinitions getSCADefinition() throws SCADefinitionsProviderException {
        final URL definitionsFileUrl = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return this.getClass().getClassLoader().getResource(SCABindingDefinitionsProvider.this.definitionsFile);
            }
        });
        SCADefinitions scaDefn = null;
        try {
            final URI uri = new URI(this.definitionsFile);
            scaDefn = AccessController.doPrivileged(new PrivilegedExceptionAction<SCADefinitions>(){

                @Override
                public SCADefinitions run() throws ContributionReadException {
                    return (SCADefinitions)SCABindingDefinitionsProvider.this.urlArtifactProcessor.read(null, uri, definitionsFileUrl);
                }
            });
        }
        catch (Exception e) {
            throw new SCADefinitionsProviderException((Throwable)e);
        }
        return scaDefn;
    }
}

