/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.List;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jsonrpc.JSONRPCBinding;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc10Request;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc10Response;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20BatchRequest;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20Error;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20Request;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20Response;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpcRequest;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpcResponse;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JavaToSmd;
import org.apache.tuscany.sca.databinding.json.jackson.JacksonHelper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.oasisopen.sca.ServiceRuntimeException;

public class JsonRpcServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    transient MessageFactory messageFactory;
    transient Binding binding;
    transient String serviceName;
    transient Object serviceInstance;
    transient RuntimeEndpoint endpoint;
    transient Class<?> serviceInterface;

    public JsonRpcServlet(MessageFactory messageFactory, RuntimeEndpoint endpoint, Class<?> serviceInterface, Object serviceInstance) {
        this.endpoint = endpoint;
        this.messageFactory = messageFactory;
        this.binding = endpoint.getBinding();
        this.serviceName = this.binding.getName();
        this.serviceInterface = serviceInterface;
        this.serviceInstance = serviceInstance;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("smd".equals(request.getQueryString())) {
            this.handleSMDRequest(request, response);
            return;
        }
        try {
            this.handleJsonRpcInvocation(request, response);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof LoginException) {
                response.setHeader("WWW-Authenticate", "BASIC realm=\"ldap-realm\"");
                response.sendError(401);
            }
            throw re;
        }
    }

    private void handleJsonRpcInvocation(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException, IOException, ServletException {
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        JsonNode root = null;
        if (request.getMethod().equals("GET")) {
            try {
                String params = new String(Base64.decodeBase64((byte[])URLDecoder.decode(request.getParameter("params"), charset).getBytes()));
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                sb.append("\"method\": \"" + request.getParameter("method") + "\",");
                sb.append("\"params\": " + params + ",");
                sb.append("\"id\":" + request.getParameter("id"));
                sb.append("}");
                root = JacksonHelper.MAPPER.readTree(sb.toString());
            }
            catch (Throwable e) {
                JsonRpc10Response error = new JsonRpc10Response((JsonNode)JsonNodeFactory.instance.textNode(request.getParameter("id")), e);
                error.write(response.getWriter());
                return;
            }
        } else {
            root = JacksonHelper.MAPPER.readTree((Reader)request.getReader());
        }
        try {
            JsonRpcResponse jsonResult;
            JsonRpcRequest jsonReq;
            if (root.isArray()) {
                ArrayNode input = (ArrayNode)root;
                JsonRpc20BatchRequest batchReq = new JsonRpc20BatchRequest(input);
                for (int i = 0; i < batchReq.getRequests().size(); ++i) {
                    JsonRpcResponse result = batchReq.getBatchResponse().getResponses().get(i);
                    if (result != null) continue;
                    result = this.invoke(batchReq.getRequests().get(i));
                    batchReq.getBatchResponse().getResponses().set(i, result);
                }
                ArrayNode responses = batchReq.getBatchResponse().toJSONArray();
                JacksonHelper.MAPPER.writeValue((Writer)response.getWriter(), (Object)responses);
            } else if (root.has("jsonrpc")) {
                jsonReq = new JsonRpc20Request((ObjectNode)root);
                jsonResult = this.invoke((JsonRpc20Request)jsonReq);
                if (jsonResult != null) {
                    jsonResult.write(response.getWriter());
                }
            } else {
                jsonReq = new JsonRpc10Request((ObjectNode)root);
                jsonResult = this.invoke((JsonRpc10Request)jsonReq);
                if (jsonResult != null) {
                    jsonResult.write(response.getWriter());
                }
            }
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    private JsonRpcResponse invoke(JsonRpc20Request request) throws Exception {
        if (request.isNotification()) {
            return null;
        }
        String method = request.getMethod();
        Object[] params = request.getParams();
        Object result = null;
        Operation jsonOperation = this.findOperation(method);
        Message requestMessage = this.messageFactory.createMessage();
        requestMessage.setOperation(jsonOperation);
        requestMessage.getHeaders().put("RequestMessage", request);
        if (jsonOperation.getInputWrapper().getDataBinding().equals("JSON")) {
            requestMessage.setBody((Object)new Object[]{JacksonHelper.toString((JsonNode)request.getJsonNode())});
        } else {
            requestMessage.setBody((Object)params);
        }
        requestMessage.setBody((Object)params);
        Message responseMessage = null;
        try {
            responseMessage = this.endpoint.getInvocationChain(jsonOperation).getHeadInvoker().invoke(requestMessage);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof LoginException) {
                throw re;
            }
            JsonRpc20Error error = new JsonRpc20Error(request.getId(), re);
            return error;
        }
        if (!responseMessage.isFault()) {
            if (jsonOperation.getOutputWrapper().getDataBinding().equals("JSON")) {
                result = responseMessage.getBody();
                return new JsonRpc20Response((ObjectNode)JacksonHelper.MAPPER.readTree(result.toString()));
            }
            if (((List)jsonOperation.getOutputType().getLogical()).size() == 0) {
                try {
                    JsonRpc20Response response = new JsonRpc20Response(request.getId(), null);
                    return response;
                }
                catch (Exception e) {
                    throw new ServiceRuntimeException("Unable to create JSON response", (Throwable)e);
                }
            }
            try {
                result = responseMessage.getBody();
                JsonRpc20Response response = new JsonRpc20Response(request.getId(), (JsonNode)result);
                return response;
            }
            catch (Exception e) {
                throw new ServiceRuntimeException("Unable to create JSON response", (Throwable)e);
            }
        }
        Throwable exception = (Throwable)responseMessage.getBody();
        JsonRpc20Error error = new JsonRpc20Error(request.getId(), exception);
        return error;
    }

    private JsonRpc10Response invoke(JsonRpc10Request request) throws Exception {
        if (request.isNotification()) {
            return null;
        }
        String method = request.getMethod();
        Object[] params = request.getParams();
        Object result = null;
        Operation jsonOperation = this.findOperation(method);
        Message requestMessage = this.messageFactory.createMessage();
        requestMessage.setOperation(jsonOperation);
        requestMessage.getHeaders().put("RequestMessage", request);
        if (jsonOperation.getInputWrapper().getDataBinding().equals("JSON")) {
            requestMessage.setBody((Object)new Object[]{JacksonHelper.toString((JsonNode)request.getJsonNode())});
        } else {
            requestMessage.setBody((Object)params);
        }
        Message responseMessage = null;
        try {
            responseMessage = this.endpoint.getInvocationChain(jsonOperation).getHeadInvoker().invoke(requestMessage);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof LoginException) {
                throw e;
            }
            JsonRpc10Response error = new JsonRpc10Response(request.getId(), e);
            return error;
        }
        if (!responseMessage.isFault()) {
            if (jsonOperation.getOutputWrapper().getDataBinding().equals("JSON")) {
                result = responseMessage.getBody();
                return new JsonRpc10Response((ObjectNode)JacksonHelper.MAPPER.readTree(result.toString()));
            }
            if (((List)jsonOperation.getOutputType().getLogical()).size() == 0) {
                JsonRpc10Response response = new JsonRpc10Response(request.getId(), (JsonNode)JsonNodeFactory.instance.nullNode());
                return response;
            }
            result = responseMessage.getBody();
            JsonRpc10Response response = new JsonRpc10Response(request.getId(), (JsonNode)result);
            return response;
        }
        Throwable exception = (Throwable)responseMessage.getBody();
        JsonRpc10Response error = new JsonRpc10Response(request.getId(), exception);
        return error;
    }

    private Operation findOperation(String method) {
        if (method.contains(".")) {
            method = method.substring(method.lastIndexOf(".") + 1);
        }
        List operations = this.endpoint.getComponentServiceInterfaceContract().getInterface().getOperations();
        Operation result = null;
        for (Operation o : operations) {
            if (o.isDynamic()) {
                return o;
            }
            if (!o.getName().equalsIgnoreCase(method)) continue;
            result = o;
            break;
        }
        return result;
    }

    protected void handleSMDRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, UnsupportedEncodingException {
        String serviceUrl = request.getRequestURL().toString();
        String smd = null;
        smd = "2.0".equals(((JSONRPCBinding)this.binding).getVersion()) ? JavaToSmd.interfaceToSmd20(this.serviceInterface, serviceUrl) : JavaToSmd.interfaceToSmd(this.serviceInterface, serviceUrl);
        response.setContentType("application/json;charset=utf-8");
        ServletOutputStream out = response.getOutputStream();
        byte[] bout = smd.getBytes("UTF-8");
        out.write(bout);
        out.flush();
        out.close();
    }
}

