/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.jsonrpc.JSONRPCBinding;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc10Request;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpc20Request;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpcRequest;
import org.apache.tuscany.sca.databinding.json.jackson.JacksonHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.oasisopen.sca.ServiceRuntimeException;

public class JsonRpcInvoker
implements Invoker,
DataExchangeSemantics {
    private EndpointReference endpointReference;
    private Operation operation;
    private String uri;
    private HttpClient httpClient;

    public JsonRpcInvoker(EndpointReference endpointReference, Operation operation, HttpClient httpClient) {
        this.endpointReference = endpointReference;
        this.operation = operation;
        this.uri = endpointReference.getDeployedURI();
        this.httpClient = httpClient;
    }

    public Message invoke(Message msg) {
        block14: {
            HttpPost post = null;
            HttpResponse response = null;
            try {
                String requestId = UUID.randomUUID().toString();
                post = new HttpPost(this.uri);
                StringEntity entity = null;
                Object[] args = (Object[])msg.getBody();
                String db = msg.getOperation().getInputWrapper().getDataBinding();
                if (!db.equals("JSON")) {
                    Object[] params = new Object[]{};
                    args = (Object[])msg.getBody();
                    if (args instanceof Object[]) {
                        params = args;
                    }
                    JsonRpcRequest req = null;
                    req = "2.0".equals(((JSONRPCBinding)this.endpointReference.getBinding()).getVersion()) ? new JsonRpc20Request(requestId, msg.getOperation().getName(), params) : new JsonRpc10Request(requestId, msg.getOperation().getName(), params);
                    final JsonRpcRequest json = req;
                    ContentProducer cp = new ContentProducer(){

                        public void writeTo(OutputStream outstream) throws IOException {
                            try {
                                json.write(outstream);
                            }
                            catch (Exception e) {
                                throw new IOException(e);
                            }
                        }
                    };
                    entity = new EntityTemplate(cp);
                } else {
                    entity = new StringEntity((String)args[0], "UTF-8");
                }
                post.setEntity((HttpEntity)entity);
                response = this.httpClient.execute((HttpUriRequest)post);
                if (response.getStatusLine().getStatusCode() == 200) {
                    entity = response.getEntity();
                    String entityResponse = EntityUtils.toString((HttpEntity)entity);
                    entity.consumeContent();
                    if (!db.equals("JSON")) {
                        DataType outputType;
                        DataType returnType;
                        ObjectNode jsonResponse = (ObjectNode)JacksonHelper.MAPPER.readTree(entityResponse);
                        if (jsonResponse.has("error") && jsonResponse.get("error") != NullNode.instance) {
                            this.processException(jsonResponse);
                        }
                        DataType dataType = returnType = (outputType = this.operation.getOutputType()) != null && !((List)outputType.getLogical()).isEmpty() ? (DataType)((List)outputType.getLogical()).get(0) : null;
                        if (returnType == null) {
                            msg.setBody(null);
                            return msg;
                        }
                        if (!requestId.equalsIgnoreCase(jsonResponse.get("id").getTextValue())) {
                            throw new ServiceRuntimeException("Invalid response id:" + requestId);
                        }
                        JsonNode rawResult = jsonResponse.get("result");
                        Class returnClass = returnType.getPhysical();
                        Type genericReturnType = returnType.getGenericType();
                        ObjectMapper mapper = JsonRpcInvoker.createObjectMapper(returnClass);
                        String json = mapper.writeValueAsString((Object)rawResult);
                        Object body = mapper.readValue(json, TypeFactory.type((Type)genericReturnType));
                        msg.setBody(body);
                    } else {
                        msg.setBody((Object)entityResponse);
                    }
                    break block14;
                }
                response.getEntity().consumeContent();
                throw new ServiceRuntimeException("Abnormal HTTP response: " + response.getStatusLine().toString());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Exception e) {
                msg.setFaultBody((Object)e);
            }
            catch (Throwable e) {
                throw new ServiceRuntimeException(e);
            }
        }
        return msg;
    }

    public static ObjectMapper createObjectMapper(Class<?> cls) {
        return JacksonHelper.createObjectMapper(cls);
    }

    private String opt(ObjectNode node, String name) {
        JsonNode value = node.get(name);
        if (value == null) {
            return null;
        }
        return value.getValueAsText();
    }

    protected void processException(ObjectNode responseMessage) throws Throwable {
        JsonNode error = responseMessage.get("error");
        if (error != null) {
            JsonNode data = error.get("data");
            if (data instanceof ObjectNode) {
                ObjectNode fault = (ObjectNode)data;
                String javaClass = this.opt(fault, "class");
                String message = this.opt(fault, "message");
                String stackTrace = this.opt(fault, "stackTrace");
                if (javaClass != null) {
                    if (stackTrace != null) {
                        message = message + "\n" + stackTrace;
                    }
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (this.operation instanceof JavaOperation) {
                        Method method = ((JavaOperation)this.operation).getJavaMethod();
                        classLoader = method.getDeclaringClass().getClassLoader();
                    }
                    Class<?> exceptionClass = Class.forName(javaClass, false, classLoader);
                    Constructor<?> ctor = null;
                    Throwable ex = null;
                    try {
                        ctor = exceptionClass.getConstructor(String.class, Throwable.class);
                        ex = (Throwable)ctor.newInstance(message, null);
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            ctor = exceptionClass.getConstructor(String.class);
                            ex = (Throwable)ctor.newInstance(message);
                        }
                        catch (NoSuchMethodException e2) {
                            try {
                                ctor = exceptionClass.getConstructor(Throwable.class);
                                ex = (Throwable)ctor.newInstance(null);
                            }
                            catch (NoSuchMethodException e3) {
                                ctor = exceptionClass.getConstructor(new Class[0]);
                                ex = (Throwable)ctor.newInstance(new Object[0]);
                            }
                        }
                    }
                    throw ex;
                }
            }
            throw new ServiceRuntimeException(error.toString());
        }
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

