/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.tuscany.sca.binding.jsonrpc.JSONRPCBinding;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JSONRPCDatabindingHelper;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JsonRpcServlet;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class JSONRPCServiceBindingProvider
implements ServiceBindingProvider {
    private MessageFactory messageFactory;
    private RuntimeEndpoint endpoint;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private InterfaceContract serviceContract;
    private JSONRPCBinding binding;
    private ServletHost servletHost;
    private List<String> servletMappings = new ArrayList<String>();

    public JSONRPCServiceBindingProvider(RuntimeEndpoint endpoint, MessageFactory messageFactory, ServletHost servletHost) {
        this.endpoint = endpoint;
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        this.binding = (JSONRPCBinding)endpoint.getBinding();
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
        try {
            this.serviceContract = (InterfaceContract)this.service.getInterfaceContract().clone();
        }
        catch (CloneNotSupportedException e) {
            this.serviceContract = this.service.getInterfaceContract();
        }
        JSONRPCDatabindingHelper.setDataBinding(this.serviceContract.getInterface());
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.serviceContract;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        Class<?> serviceInterface = this.getTargetJavaClass(this.serviceContract.getInterface());
        Object proxy = this.component.getComponentContext().getServiceReference(serviceInterface, this.endpoint).getService();
        JsonRpcServlet serviceServlet = new JsonRpcServlet(this.messageFactory, this.endpoint, serviceInterface, proxy);
        String mapping = this.registerServlet((Servlet)serviceServlet);
        this.servletMappings.add(mapping);
    }

    public String registerServlet(Servlet servlet) {
        String mappedURI;
        String deployedURI;
        String servletMapping = this.binding.getURI();
        if (!servletMapping.endsWith("/")) {
            servletMapping = servletMapping + "/";
        }
        if (!servletMapping.endsWith("*")) {
            servletMapping = servletMapping + "*";
        }
        if ((deployedURI = (mappedURI = this.servletHost.addServletMapping(servletMapping, servlet))).endsWith("*")) {
            deployedURI = deployedURI.substring(0, deployedURI.length() - 1);
        }
        this.binding.setURI(deployedURI);
        this.endpoint.setDeployedURI(deployedURI);
        return mappedURI;
    }

    public void stop() {
        for (String mapping : this.servletMappings) {
            this.servletHost.removeServletMapping(mapping);
        }
    }

    private Class<?> getTargetJavaClass(Interface targetInterface) {
        return ((JavaInterface)targetInterface).getJavaClass();
    }
}

