/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.jsonrpc.JSONRPCBinding;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JSONRPCReferenceBindingProvider;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JSONRPCServiceBindingProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.host.http.client.HttpClientFactory;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class JSONRPCBindingProviderFactory
implements BindingProviderFactory<JSONRPCBinding> {
    private MessageFactory messageFactory;
    private ServletHost servletHost;
    private HttpClientFactory httpClientFactory;

    public JSONRPCBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.servletHost = ServletHostHelper.getServletHost((ExtensionPointRegistry)extensionPoints);
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
        this.httpClientFactory = HttpClientFactory.getInstance((ExtensionPointRegistry)extensionPoints);
    }

    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeEndpointReference endpointReference) {
        return new JSONRPCReferenceBindingProvider(this.httpClientFactory, (EndpointReference)endpointReference);
    }

    public ServiceBindingProvider createServiceBindingProvider(RuntimeEndpoint endpoint) {
        return new JSONRPCServiceBindingProvider(endpoint, this.messageFactory, this.servletHost);
    }

    public Class<JSONRPCBinding> getModelType() {
        return JSONRPCBinding.class;
    }
}

