/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.protocol;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpcRequest;
import org.apache.tuscany.sca.databinding.json.jackson.JacksonHelper;
import org.apache.wink.json4j.JSONException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class JsonRpc20Request
extends JsonRpcRequest {
    protected ObjectNode mappedParams;

    public JsonRpc20Request(String id, String method, Object[] params) {
        super((JsonNode)JsonNodeFactory.instance.textNode(id), method, params);
        this.jsonNode.put("jsonrpc", "2.0");
        this.mappedParams = null;
    }

    public JsonRpc20Request(String id, String method, ObjectNode mappedParams) {
        super((JsonNode)JsonNodeFactory.instance.textNode(id), method, null);
        this.jsonNode.put("jsonrpc", "2.0");
        this.mappedParams = mappedParams;
        this.jsonNode.put("params", (JsonNode)mappedParams);
    }

    public JsonRpc20Request(ObjectNode req) throws JSONException {
        super(req);
        JsonNode args;
        boolean v20;
        JsonNode node = req.get("jsonrpc");
        boolean bl = v20 = node != null && "2.0".equals(node.getTextValue());
        if (!v20) {
            throw new IllegalArgumentException("Invalid request: jsonrpc attribute must be \"2.0\"");
        }
        this.method = req.get("method").getTextValue();
        JsonNode idNode = req.get("id");
        if (idNode != null) {
            this.id = idNode;
        }
        if ((args = req.get("params")) instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)args;
            this.params = new Object[array.size()];
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i] = array.get(i);
            }
        } else if (args instanceof ObjectNode) {
            ObjectNode map;
            this.mappedParams = map = (ObjectNode)args;
            this.params = null;
        } else if (args == null) {
            this.params = new Object[0];
        } else {
            throw new IllegalArgumentException("Invalid request: params is not a JSON array - " + args);
        }
    }

    @Override
    public void write(OutputStream os) throws Exception {
        HashMap<String, Object> jsonRequest = new HashMap<String, Object>();
        jsonRequest.put("jsonrpc", "2.0");
        jsonRequest.put("id", this.id);
        jsonRequest.put("method", this.method);
        if (this.mappedParams != null) {
            jsonRequest.put("params", this.mappedParams);
        } else {
            List<Object> parameters = null;
            parameters = this.params != null ? Arrays.asList(this.params) : Collections.emptyList();
            jsonRequest.put("params", parameters);
        }
        JacksonHelper.MAPPER.writeValue(os, jsonRequest);
    }

    public ObjectNode getMappedParams() {
        return this.mappedParams;
    }
}

