/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.protocol;

import org.apache.tuscany.sca.binding.jsonrpc.protocol.JsonRpcResponse;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class JsonRpc20Error
extends JsonRpcResponse {
    public static final int PARSE_ERROR = 32700;
    public static final String PARSE_ERROR_MSG = "Parse error: Invalid JSON was received by the server. An error occurred on the server while parsing the JSON text.";
    public static final int INVALID_REQUEST = -32600;
    public static final String INVALID_REQUEST_MSG = "Invalid Request: The JSON sent is not a valid Request object.";
    public static final int METHOD_NOT_FOUND = -32601;
    public static final String METHOD_NOT_FOUND_MSG = "Method not found: The method does not exist / is not available.";
    public static final int INVALID_PARAMS = -32602;
    public static final String INVALID_PARAMS_MSG = "Invalid params  Invalid method parameter(s).";
    public static final int INTERNAL_ERROR = -32603;
    public static final String INTERNAL_ERROR_MSG = "Internal error  Internal JSON-RPC error.";

    public JsonRpc20Error(JsonNode id, Throwable t) {
        super(id, t);
        this.jsonNode.put("jsonrpc", "2.0");
        this.jsonNode.put("code", -32603);
    }

    public JsonRpc20Error(JsonNode id, int code, String message, JsonNode data) {
        super(id, (JsonNode)JsonNodeFactory.instance.nullNode());
        this.jsonNode.put("jsonrpc", "2.0");
        ObjectNode error = JsonNodeFactory.instance.objectNode();
        error.put("code", code);
        error.put("message", message);
        error.put("data", data);
        this.jsonNode.put("error", (JsonNode)error);
    }

    public JsonRpc20Error(ObjectNode jsonNode) {
        super(jsonNode);
    }
}

